/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.OClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.OLocalClusterWrapperStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODefaultClusterOwnershipAssignmentStrategy
implements OClusterOwnershipAssignmentStrategy {
    private final ODistributedAbstractPlugin manager;

    public ODefaultClusterOwnershipAssignmentStrategy(ODistributedAbstractPlugin manager) {
        this.manager = manager;
    }

    @Override
    public List<String> assignClusterOwnershipOfClass(ODatabaseInternal iDatabase, OModifiableDistributedConfiguration cfg, OClass iClass, Set<String> availableNodes) {
        Iterator<String> it = availableNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (cfg.getServerRole(node) == ODistributedConfiguration.ROLES.MASTER) continue;
            it.remove();
        }
        if (availableNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (!(iClass.getClusterSelection() instanceof OLocalClusterWrapperStrategy)) {
            ((OClassImpl)iClass).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterWrapperStrategy(this.manager, iDatabase.getName(), iClass, iClass.getClusterSelection()));
        }
        if (iClass.isAbstract()) {
            return Collections.EMPTY_LIST;
        }
        int[] clusterIds = iClass.getClusterIds();
        HashSet<String> clusterNames = new HashSet<String>(clusterIds.length);
        for (int clusterId : clusterIds) {
            String clusterName = iDatabase.getClusterNameById(clusterId);
            if (clusterName == null) continue;
            clusterNames.add(clusterName);
        }
        Map<String, String> clusterToAssignOwnership = this.reassignClusters((ODistributedConfiguration)cfg, availableNodes, clusterNames);
        for (Map.Entry<String, String> entry : clusterToAssignOwnership.entrySet()) {
            String cluster = entry.getKey();
            String node = entry.getValue();
            this.assignClusterOwnership(iDatabase, cfg, iClass, cluster, node);
        }
        Collection allClusterNames = iDatabase.getClusterNames();
        ArrayList<String> serversToCreateANewCluster = new ArrayList<String>();
        for (String server : availableNodes) {
            String newClusterName;
            List ownedClusters = cfg.getOwnedClustersByServer(clusterNames, server);
            if (!ownedClusters.isEmpty()) continue;
            int i = 0;
            while (allClusterNames.contains(newClusterName = iClass.getName().toLowerCase() + "_" + i)) {
                ++i;
            }
            serversToCreateANewCluster.add(newClusterName);
            this.assignClusterOwnership(iDatabase, cfg, iClass, newClusterName, server);
        }
        return serversToCreateANewCluster;
    }

    protected Map<String, String> reassignClusters(ODistributedConfiguration cfg, Set<String> availableNodes, Set<String> clusterNames) {
        Set allConfiguredNodes = cfg.getServers(clusterNames);
        ArrayList<OPair> nodeOwners = new ArrayList<OPair>(allConfiguredNodes.size());
        for (String server : allConfiguredNodes) {
            List ownedClusters = cfg.getOwnedClustersByServer(clusterNames, server);
            Iterator it = ownedClusters.iterator();
            while (it.hasNext()) {
                String cluster = (String)it.next();
                if (cfg.getConfiguredClusterOwner(cluster) == null) continue;
                it.remove();
            }
            nodeOwners.add(new OPair((Comparable)((Object)server), (Object)ownedClusters));
        }
        Collections.sort(nodeOwners, new Comparator<OPair<String, List<String>>>(){

            @Override
            public int compare(OPair<String, List<String>> o1, OPair<String, List<String>> o2) {
                return ((List)o2.getValue()).size() - ((List)o1.getValue()).size();
            }
        });
        HashMap<String, String> clusterToAssignOwnership = new HashMap<String, String>();
        HashSet clustersOfClassToReassign = new HashSet();
        for (OPair owner : nodeOwners) {
            String server = (String)((Object)owner.getKey());
            List ownedClusters = (List)owner.getValue();
            if (availableNodes.contains(server)) continue;
            clustersOfClassToReassign.addAll(ownedClusters);
        }
        int currentServerIndex = 0;
        int clusterAssigned = 0;
        for (OPair owner : nodeOwners) {
            int targetClustersPerNode;
            String server = (String)((Object)owner.getKey());
            List ownedClusters = (List)owner.getValue();
            int nodesLeft = availableNodes.size() - currentServerIndex;
            int n = targetClustersPerNode = nodesLeft < 1 ? 1 : (clusterNames.size() - clusterAssigned) / nodesLeft;
            if (targetClustersPerNode == 0 || nodesLeft > 0 && (clusterNames.size() - clusterAssigned) % nodesLeft > 0) {
                ++targetClustersPerNode;
            }
            if (ownedClusters.size() > targetClustersPerNode) {
                while (ownedClusters.size() > targetClustersPerNode) {
                    clustersOfClassToReassign.add(ownedClusters.remove(ownedClusters.size() - 1));
                }
            } else if (ownedClusters.size() < targetClustersPerNode) {
                while (ownedClusters.size() < targetClustersPerNode && !clustersOfClassToReassign.isEmpty()) {
                    Iterator it = clustersOfClassToReassign.iterator();
                    boolean reassigned = false;
                    while (it.hasNext()) {
                        String cluster = (String)it.next();
                        List serverPerClusterList = cfg.getConfiguredServers(cluster);
                        if (serverPerClusterList == null || !serverPerClusterList.contains(server)) continue;
                        it.remove();
                        clusterToAssignOwnership.put(cluster, server);
                        ownedClusters.add(cluster);
                        reassigned = true;
                        break;
                    }
                    if (reassigned) continue;
                    break;
                }
            }
            clusterAssigned += ownedClusters.size();
            ++currentServerIndex;
        }
        return clusterToAssignOwnership;
    }

    private void assignClusterOwnership(ODatabaseInternal iDatabase, OModifiableDistributedConfiguration cfg, OClass iClass, String cluster, String node) {
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Class '%s': change mastership of cluster '%s' (id=%d) to node '%s'", (Object[])new Object[]{iClass, cluster, iDatabase.getClusterIdByName(cluster), node});
        cfg.setServerOwner(cluster, node);
    }
}

