/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedSyncConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.impl.OConflictResolverDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedWorker;
import com.orientechnologies.orient.server.distributed.impl.OSynchronizedTaskWrapper;
import com.orientechnologies.orient.server.distributed.impl.task.OUnreachableServerLocalTask;
import com.orientechnologies.orient.server.distributed.impl.task.OWaitForTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ODistributedDatabaseImpl
implements ODistributedDatabase {
    public static final String DISTRIBUTED_SYNC_JSON_FILENAME = "distributed-sync.json";
    private static final String NODE_LOCK_PREFIX = "orientdb.reqlock.";
    private static final HashSet<Integer> ALL_QUEUES = new HashSet();
    protected final ODistributedAbstractPlugin manager;
    protected final ODistributedMessageServiceImpl msgService;
    protected final String databaseName;
    protected ODistributedDatabaseRepairer repairer;
    protected ODistributedSyncConfiguration syncConfiguration;
    protected ConcurrentHashMap<ORID, ODistributedLock> lockManager = new ConcurrentHashMap(256);
    protected ConcurrentHashMap<ODistributedRequestId, ODistributedTxContext> activeTxContexts = new ConcurrentHashMap(64);
    protected final List<ODistributedWorker> workerThreads = new ArrayList<ODistributedWorker>();
    protected ODistributedWorker lockThread;
    protected ODistributedWorker unlockThread;
    private AtomicLong totalSentRequests = new AtomicLong();
    private AtomicLong totalReceivedRequests = new AtomicLong();
    private TimerTask txTimeoutTask = null;
    private CountDownLatch waitForOnline = new CountDownLatch(1);
    private volatile boolean running = true;
    private AtomicBoolean parsing = new AtomicBoolean(true);
    private final AtomicReference<ODistributedMomentum> filterByMomentum = new AtomicReference();
    private String localNodeName;

    public ODistributedDatabaseImpl(OHazelcastPlugin manager, ODistributedMessageServiceImpl msgService, String iDatabaseName, ODistributedConfiguration cfg) {
        this.manager = manager;
        this.msgService = msgService;
        this.databaseName = iDatabaseName;
        this.localNodeName = manager.getLocalNodeName();
        ODistributedDatabaseImpl prev = msgService.databases.put(iDatabaseName, this);
        if (prev != null) {
            prev.shutdown();
        }
        this.startAcceptingRequests();
        if (iDatabaseName.equals("OSystem")) {
            return;
        }
        this.checkLocalNodeInConfiguration(cfg);
        this.startTxTimeoutTimerTask();
        this.repairer = new OConflictResolverDatabaseRepairer(manager, this.databaseName);
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgSent", "Number of replication messages sent from current node", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalSentRequests.get();
            }
        }, "distributed.db.*.msgSent");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgReceived", "Number of replication messages received from external nodes", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalReceivedRequests.get();
            }
        }, "distributed.db.*.msgReceived");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".activeContexts", "Number of active distributed transactions", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.activeTxContexts.size();
            }
        }, "distributed.db.*.activeContexts");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".workerThreads", "Number of worker threads", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.workerThreads.size();
            }
        }, "distributed.db.*.workerThreads");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".recordLocks", "Number of record locked", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.lockManager.size();
            }
        }, "distributed.db.*.recordLocks");
    }

    public OLogSequenceNumber getLastLSN(String server) {
        if (server == null) {
            return null;
        }
        return this.getSyncConfiguration().getLastLSN(server);
    }

    public void waitForOnline() {
        try {
            this.waitForOnline.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void processRequest(ODistributedRequest request, boolean waitForAcceptingRequests) {
        if (!this.running) {
            return;
        }
        ORemoteTask task = request.getTask();
        if (waitForAcceptingRequests) {
            this.waitIsReady(task);
            if (!this.running) {
                return;
            }
        }
        this.totalReceivedRequests.incrementAndGet();
        int[] partitionKeys = task.getPartitionKey();
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)task.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' partitionKeys=%s task=%s", (Object[])new Object[]{request, this.databaseName, Arrays.toString(partitionKeys), task});
        }
        if (partitionKeys.length > 1 || partitionKeys[0] == -1) {
            Set<Integer> involvedWorkerQueues = partitionKeys.length > 1 ? this.getInvolvedQueuesByPartitionKeys(partitionKeys) : ALL_QUEUES;
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Request %s on database '%s' involvedQueues=%s", (Object[])new Object[]{request, this.databaseName, involvedWorkerQueues});
            if (involvedWorkerQueues.size() == 1) {
                this.processRequest(involvedWorkerQueues.iterator().next(), request);
            } else {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Request %s on database '%s' waiting for all the previous requests to be completed", (Object[])new Object[]{request, this.databaseName});
                CountDownLatch syncLatch = new CountDownLatch(involvedWorkerQueues.size());
                ODistributedRequest syncRequest = new ODistributedRequest(this.manager.getTaskFactory(), request.getId().getNodeId(), -1L, this.databaseName, (ORemoteTask)new OSynchronizedTaskWrapper(syncLatch));
                for (int queue : involvedWorkerQueues) {
                    this.workerThreads.get(queue).processRequest(syncRequest);
                }
                long taskTimeout = task.getDistributedTimeout();
                try {
                    if (taskTimeout <= 0L) {
                        syncLatch.await();
                    } else {
                        long start = System.currentTimeMillis();
                        long cycleTimeout = Math.min(taskTimeout, 2000L);
                        boolean locked = false;
                        do {
                            if (!syncLatch.await(cycleTimeout, TimeUnit.MILLISECONDS)) continue;
                            locked = true;
                            break;
                        } while (this.workerThreads.size() != 0 && System.currentTimeMillis() - start < taskTimeout);
                        if (!locked) {
                            String msg = String.format("Cannot execute distributed request (%s) because all worker threads (%d) are busy (pending=%d)", request, this.workerThreads.size(), syncLatch.getCount());
                            ODistributedWorker.sendResponseBack(this, this.manager, request, (Object)new ODistributedOperationException(msg));
                            return;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    String msg = String.format("Cannot execute distributed request (%s) because all worker threads (%d) are busy", request, this.workerThreads.size());
                    ODistributedWorker.sendResponseBack(this, this.manager, request, (Object)new ODistributedOperationException(msg));
                    return;
                }
                CountDownLatch queueLatch = new CountDownLatch(1);
                int i = 0;
                for (int queue : involvedWorkerQueues) {
                    ODistributedRequest req;
                    if (i++ == 0) {
                        String senderNodeName = this.manager.getNodeNameById(request.getId().getNodeId());
                        request.setTask((ORemoteTask)new OSynchronizedTaskWrapper(queueLatch, senderNodeName, task));
                        req = request;
                    } else {
                        req = new ODistributedRequest(this.manager.getTaskFactory(), request.getId().getNodeId(), -1L, this.databaseName, (ORemoteTask)new OWaitForTask(queueLatch));
                    }
                    this.workerThreads.get(queue).processRequest(req);
                }
            }
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -2) {
            boolean found = false;
            for (ODistributedWorker q : this.workerThreads) {
                if (!q.isWaitingForNextRequest() || !q.localQueue.isEmpty()) continue;
                q.processRequest(request);
                found = true;
                break;
            }
            if (!found) {
                for (ODistributedWorker q : this.workerThreads) {
                    if (!q.localQueue.isEmpty()) continue;
                    q.processRequest(request);
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.workerThreads.get(0).processRequest(request);
            }
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -3) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)request.getTask().getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' dispatched to the lock worker", (Object[])new Object[]{request, this.databaseName});
            this.lockThread.processRequest(request);
        } else if (partitionKeys.length == 1 && partitionKeys[0] == -4) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)request.getTask().getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' dispatched to the unlock worker", (Object[])new Object[]{request, this.databaseName});
            this.unlockThread.processRequest(request);
        } else {
            this.processRequest(partitionKeys[0], request);
        }
    }

    public void waitIsReady(ORemoteTask task) {
        if (task.isNodeOnlineRequired() && !this.parsing.get()) {
            while (!this.parsing.get()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    protected Set<Integer> getInvolvedQueuesByPartitionKeys(int[] partitionKeys) {
        HashSet<Integer> involvedWorkerQueues = new HashSet<Integer>(partitionKeys.length);
        for (int pk : partitionKeys) {
            if (pk < 0) continue;
            involvedWorkerQueues.add(pk % this.workerThreads.size());
        }
        return involvedWorkerQueues;
    }

    protected void processRequest(int partitionKey, ODistributedRequest request) {
        if (this.workerThreads.isEmpty()) {
            throw new ODistributedException("There are no worker threads to process request " + request);
        }
        int partition = partitionKey % this.workerThreads.size();
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)request.getTask().getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Request %s on database '%s' dispatched to the worker %d", (Object[])new Object[]{request, this.databaseName, partition});
        this.workerThreads.get(partition).processRequest(request);
    }

    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback) {
        boolean afterSendCallBackCalled = false;
        try {
            ODistributedResponse oDistributedResponse;
            this.checkForServerOnline(iRequest);
            String databaseName = iRequest.getDatabaseName();
            if (iNodes.isEmpty()) {
                ODistributedServerLog.error((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for database '%s' request: %s", (Object[])new Object[]{databaseName, iRequest});
                throw new ODistributedException("No nodes configured for partition '" + databaseName + "' request: " + iRequest);
            }
            ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(databaseName);
            ORemoteTask task = iRequest.getTask();
            boolean checkNodesAreOnline = task.isNodeOnlineRequired();
            Set nodesConcurToTheQuorum = this.manager.getDistributedStrategy().getNodesConcurInQuorum((ODistributedServerManager)this.manager, cfg, iRequest, iNodes, databaseName, localResult);
            int availableNodes = checkNodesAreOnline ? this.manager.getNodesWithStatus(iNodes, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP, ODistributedServerManager.DB_STATUS.SYNCHRONIZING) : iNodes.size();
            int expectedResponses = localResult != null ? availableNodes + 1 : availableNodes;
            int quorum = this.calculateQuorum(task.getQuorumType(), iClusterNames, cfg, expectedResponses, nodesConcurToTheQuorum.size(), checkNodesAreOnline, this.localNodeName);
            boolean groupByResponse = task.getResultStrategy() != ORemoteTask.RESULT_STRATEGY.UNION;
            boolean waitLocalNode = this.waitForLocalNode(cfg, iClusterNames, iNodes);
            ODistributedResponseManager currentResponseMgr = new ODistributedResponseManager((ODistributedServerManager)this.manager, iRequest, iNodes, nodesConcurToTheQuorum, expectedResponses, quorum, waitLocalNode, this.adjustTimeoutWithLatency(iNodes, task.getSynchronousTimeout(expectedResponses)), this.adjustTimeoutWithLatency(iNodes, task.getTotalTimeout(availableNodes)), groupByResponse);
            if (localResult != null) {
                currentResponseMgr.setLocalResult(this.localNodeName, localResult);
            }
            if (!(iNodes instanceof List)) {
                iNodes = new ArrayList<String>(iNodes);
            }
            if (iNodes.size() > 1) {
                Collections.sort((List)iNodes);
            }
            this.msgService.registerRequest(iRequest.getId().getMessageId(), currentResponseMgr);
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending request %s...", (Object[])new Object[]{iRequest});
            }
            for (String node : iNodes) {
                try {
                    ORemoteServerController remoteServer = this.manager.getRemoteServer(node);
                    remoteServer.sendRequest(iRequest);
                }
                catch (Throwable e) {
                    currentResponseMgr.removeServerBecauseUnreachable(node);
                    String reason = e.getMessage();
                    if (e instanceof ODistributedException && e.getCause() instanceof IOException) {
                        reason = e.getCause().getMessage();
                        this.manager.closeRemoteServer(node);
                    } else if (e instanceof OSecurityAccessException) {
                        this.manager.closeRemoteServer(node);
                        try {
                            ORemoteServerController remoteServer = this.manager.getRemoteServer(node);
                            remoteServer.sendRequest(iRequest);
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (!this.manager.isNodeAvailable(node)) {
                        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending distributed request %s. The target node is not available. Active nodes: %s", (Throwable)e, (Object[])new Object[]{iRequest, this.manager.getAvailableNodeNames(databaseName)});
                        continue;
                    }
                    ODistributedServerLog.error((Object)this, (String)this.localNodeName, (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending distributed request %s (err=%s). Active nodes: %s", (Object[])new Object[]{iRequest, reason, this.manager.getAvailableNodeNames(databaseName)});
                }
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sent request %s", (Object[])new Object[]{iRequest});
            }
            this.totalSentRequests.incrementAndGet();
            afterSendCallBackCalled = true;
            if (iAfterSentCallback != null) {
                iAfterSentCallback.call((Object)iRequest.getId());
            }
            if (iExecutionMode == ODistributedRequest.EXECUTION_MODE.RESPONSE) {
                oDistributedResponse = this.waitForResponse(iRequest, currentResponseMgr);
                return oDistributedResponse;
            }
            oDistributedResponse = null;
            return oDistributedResponse;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new ODistributedException("Error on executing distributed request (" + iRequest + ") against database '" + this.databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes), (Throwable)e);
        }
        finally {
            if (iAfterSentCallback != null && !afterSendCallBackCalled) {
                iAfterSentCallback.call((Object)iRequest.getId());
            }
        }
    }

    private long adjustTimeoutWithLatency(Collection<String> iNodes, long timeout) {
        int delta = 0;
        if (iNodes != null) {
            for (String n : iNodes) {
                delta = (int)((long)delta + this.msgService.getCurrentLatency(n));
            }
        }
        if (delta > 1000) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Adjusted timeouts by adding +%dms because the average latency recorded against servers %s", (Object[])new Object[]{delta, iNodes});
        }
        return timeout + (long)delta;
    }

    public void setOnline() {
        ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Publishing ONLINE status for database %s.%s...", (Object[])new Object[]{this.localNodeName, this.databaseName});
        this.manager.setDatabaseStatus(this.localNodeName, this.databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
        this.waitForOnline.countDown();
    }

    public ORawBuffer getRecordIfLocked(ORID rid) {
        ODistributedLock currentLock = this.lockManager.get(rid);
        if (currentLock != null) {
            return currentLock.record;
        }
        return null;
    }

    public boolean lockRecord(ORID rid, ODistributedRequestId iRequestId, long timeout) {
        ODatabaseDocumentInternal db;
        ORawBuffer originalRecord = null;
        if (rid.isPersistent() && (db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined()) != null) {
            originalRecord = (ORawBuffer)db.getStorage().getUnderlying().readRecord((ORecordId)rid, null, false, true, null).getResult();
        }
        ODistributedLock lock = new ODistributedLock(iRequestId, originalRecord);
        boolean newLock = true;
        ODistributedLock currentLock = this.lockManager.putIfAbsent(rid, lock);
        if (currentLock != null) {
            if (iRequestId.equals((Object)currentLock.reqId)) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s locked record %s in database '%s' owned by %s (thread=%d)", (Object[])new Object[]{iRequestId, rid, this.databaseName, currentLock.reqId, Thread.currentThread().getId()});
                currentLock = null;
                newLock = false;
            } else {
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        if (timeout > 0L) {
                            if (!currentLock.lock.await(timeout, TimeUnit.MILLISECONDS)) {
                                continue;
                            }
                        } else {
                            currentLock.lock.await();
                        }
                        currentLock = this.lockManager.putIfAbsent(rid, lock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (currentLock != null && (timeout == 0L || System.currentTimeMillis() - startTime < timeout));
            }
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            if (currentLock == null) {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Locked record %s in database '%s' (reqId=%s thread=%d)", (Object[])new Object[]{rid, this.databaseName, iRequestId, Thread.currentThread().getId()});
            } else {
                ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot lock record %s in database '%s' owned by %s (reqId=%s thread=%d)", (Object[])new Object[]{rid, this.databaseName, currentLock.reqId, iRequestId, Thread.currentThread().getId()});
            }
        }
        if (currentLock != null) {
            throw new ODistributedRecordLockedException(this.manager.getLocalNodeName(), rid, currentLock.reqId, timeout);
        }
        return newLock;
    }

    public void unlockRecord(OIdentifiable iRecord, ODistributedRequestId requestId) {
        if (requestId == null) {
            return;
        }
        ODistributedLock owner = this.lockManager.remove(iRecord.getIdentity());
        if (owner != null) {
            if (!owner.reqId.equals((Object)requestId)) {
                ODistributedServerLog.error((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: cannot unlock record %s in database '%s' because owner %s <> current %s (thread=%d)", (Object[])new Object[]{iRecord, this.databaseName, owner.reqId, requestId, Thread.currentThread().getId()});
                return;
            }
            owner.lock.countDown();
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s unlocked record %s in database '%s' (owner=%s, thread=%d)", (Object[])new Object[]{requestId, iRecord, this.databaseName, owner != null ? owner.reqId : "null", Thread.currentThread().getId()});
        }
    }

    public void unlockResourcesOfServer(ODatabaseDocumentInternal database, String serverName) {
        int nodeLeftId = this.manager.getNodeIdByName(serverName);
        int rollbacks = 0;
        Iterator<ODistributedTxContext> pendingReqIterator = this.activeTxContexts.values().iterator();
        while (pendingReqIterator.hasNext()) {
            ODistributedTxContext pReq = pendingReqIterator.next();
            if (pReq == null || pReq.getReqId().getNodeId() != nodeLeftId) continue;
            ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: rolling back transaction (req=%s)", (Object[])new Object[]{pReq.getReqId()});
            try {
                pReq.rollback(database);
                ++rollbacks;
            }
            catch (Throwable t) {
                ODistributedServerLog.error((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: error on rolling back transaction (req=%s)", (Object[])new Object[]{pReq.getReqId()});
            }
            pReq.destroy();
            pendingReqIterator.remove();
        }
        int recordLocks = 0;
        for (Map.Entry<ORID, ODistributedLock> entry : this.lockManager.entrySet()) {
            ODistributedLock lock = entry.getValue();
            if (lock == null || lock.reqId == null || lock.reqId.getNodeId() != nodeLeftId) continue;
            OLogManager.instance().debug((Object)this, "Unlocking record %s acquired with req=%s", new Object[]{entry.getKey(), lock.reqId});
            ++recordLocks;
        }
        ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: rolled back %d transactions and %d single locks in database '%s' owned by server '%s'", (Object[])new Object[]{rollbacks, recordLocks, this.databaseName, serverName});
    }

    public ODistributedTxContext registerTxContext(ODistributedRequestId reqId) {
        ODistributedTxContextImpl ctx = new ODistributedTxContextImpl(this, reqId);
        ODistributedTxContext prevCtx = this.activeTxContexts.putIfAbsent(reqId, ctx);
        if (prevCtx != null) {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: repeating request %s in database '%s' (thread=%d)", (Object[])new Object[]{reqId, this.databaseName, Thread.currentThread().getId()});
            ctx = prevCtx;
        } else {
            ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: registered request %s in database '%s' (thread=%d)", (Object[])new Object[]{reqId, this.databaseName, Thread.currentThread().getId()});
        }
        return ctx;
    }

    public ODistributedTxContext popTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = this.activeTxContexts.remove(requestId);
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: pop request %s for database %s -> %s", (Object[])new Object[]{requestId, this.databaseName, ctx});
        return ctx;
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public boolean exists() {
        try {
            this.manager.getServerInstance().getStoragePath(this.databaseName);
            return true;
        }
        catch (OConfigurationException e) {
            return false;
        }
    }

    public ODistributedSyncConfiguration getSyncConfiguration() {
        if (this.syncConfiguration == null) {
            String path = this.manager.getServerInstance().getDatabaseDirectory() + this.databaseName + "/" + DISTRIBUTED_SYNC_JSON_FILENAME;
            File cfgFile = new File(path);
            try {
                this.syncConfiguration = new ODistributedSyncConfiguration((ODistributedServerManager)this.manager, this.databaseName, cfgFile);
            }
            catch (IOException e) {
                throw new ODistributedException("Cannot open database distributed sync configuration file: " + cfgFile);
            }
        }
        return this.syncConfiguration;
    }

    public void filterBeforeThisMomentum(ODistributedMomentum momentum) {
        this.filterByMomentum.set(momentum);
    }

    public void handleUnreachableNode(String nodeName) {
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction: rolling back all the pending transactions coordinated by the unreachable server '%s'", (Object[])new Object[]{nodeName});
        OUnreachableServerLocalTask task = new OUnreachableServerLocalTask(nodeName);
        ODistributedRequest rollbackRequest = new ODistributedRequest(this.manager.getTaskFactory(), this.manager.getLocalNodeId(), this.manager.getNextMessageIdCounter(), null, (ORemoteTask)task);
        this.processRequest(rollbackRequest, false);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ODatabaseDocumentTx getDatabaseInstance() {
        return this.manager.getServerInstance().openDatabase(this.databaseName, "internal", "internal", null, true);
    }

    public long getReceivedRequests() {
        return this.totalReceivedRequests.get();
    }

    public long getProcessedRequests() {
        long total = 0L;
        if (this.lockThread != null) {
            total += this.lockThread.getProcessedRequests();
        }
        if (this.unlockThread != null) {
            total += this.unlockThread.getProcessedRequests();
        }
        for (ODistributedWorker workerThread : this.workerThreads) {
            if (workerThread == null) continue;
            total += workerThread.getProcessedRequests();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        try {
            if (this.txTimeoutTask != null) {
                this.txTimeoutTask.cancel();
            }
            if (this.repairer != null) {
                this.repairer.shutdown();
            }
            if (this.lockThread != null) {
                this.lockThread.sendShutdown();
            }
            if (this.unlockThread != null) {
                this.unlockThread.sendShutdown();
            }
            for (ODistributedWorker workerThread : this.workerThreads) {
                if (workerThread == null) continue;
                workerThread.sendShutdown();
            }
            if (this.lockThread != null) {
                try {
                    this.lockThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.unlockThread != null) {
                try {
                    this.unlockThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (ODistributedWorker workerThread : this.workerThreads) {
                if (workerThread == null) continue;
                try {
                    workerThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lockThread = null;
            this.unlockThread = null;
            this.workerThreads.clear();
            try {
                this.getSyncConfiguration().save();
            }
            catch (IOException e) {
                ODistributedServerLog.warn((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on saving distributed LSN table for database '%s'", (Object[])new Object[]{this.databaseName});
            }
            this.syncConfiguration = null;
            ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Shutting down distributed database manager '%s'. Pending objects: txs=%d locks=%d", (Object[])new Object[]{this.databaseName, this.activeTxContexts.size(), this.lockManager.size()});
            this.lockManager.clear();
            this.activeTxContexts.clear();
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgSent");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgReceived");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".activeContexts");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".workerThreads");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".recordLocks");
        }
        finally {
            ODistributedServerManager.DB_STATUS serverStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName);
            if (serverStatus == ODistributedServerManager.DB_STATUS.ONLINE || serverStatus == ODistributedServerManager.DB_STATUS.SYNCHRONIZING) {
                try {
                    this.manager.setDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void checkForServerOnline(ODistributedRequest iRequest) throws ODistributedException {
        ODistributedServerManager.NODE_STATUS srvStatus = this.manager.getNodeStatus();
        if (srvStatus == ODistributedServerManager.NODE_STATUS.OFFLINE || srvStatus == ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN) {
            ODistributedServerLog.error((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Local server is not online (status='%s'). Request %s will be ignored", (Object[])new Object[]{srvStatus, iRequest});
            throw new OOfflineNodeException("Local server is not online (status='" + srvStatus + "'). Request " + iRequest + " will be ignored");
        }
    }

    protected boolean waitForLocalNode(ODistributedConfiguration cfg, Collection<String> iClusterNames, Collection<String> iNodes) {
        boolean waitLocalNode;
        block1: {
            block2: {
                waitLocalNode = false;
                if (!iNodes.contains(this.localNodeName)) break block1;
                if (iClusterNames != null && !iClusterNames.isEmpty()) break block2;
                if (!cfg.isReadYourWrites(null).booleanValue()) break block1;
                waitLocalNode = true;
                break block1;
            }
            for (String clName : iClusterNames) {
                if (!cfg.isReadYourWrites(clName).booleanValue()) continue;
                waitLocalNode = true;
                break;
            }
        }
        return waitLocalNode;
    }

    protected int calculateQuorum(OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType, Collection<String> clusterNames, ODistributedConfiguration cfg, int allAvailableNodes, int masterAvailableNodes, boolean checkNodesAreOnline, String localNodeName) {
        int quorum = 1;
        if (clusterNames == null || clusterNames.isEmpty()) {
            clusterNames = new ArrayList<String>(1);
            clusterNames.add(null);
        }
        for (String cluster : clusterNames) {
            int clusterQuorum = 0;
            switch (quorumType) {
                case NONE: {
                    break;
                }
                case READ: {
                    clusterQuorum = cfg.getReadQuorum(cluster, allAvailableNodes, localNodeName);
                    break;
                }
                case WRITE: {
                    clusterQuorum = cfg.getWriteQuorum(cluster, masterAvailableNodes, localNodeName);
                    break;
                }
                case ALL: {
                    clusterQuorum = allAvailableNodes;
                }
            }
            quorum = Math.max(quorum, clusterQuorum);
        }
        if (quorum < 0) {
            quorum = 0;
        }
        if (checkNodesAreOnline && quorum > allAvailableNodes) {
            throw new ODistributedException("Quorum (" + quorum + ") cannot be reached on server '" + localNodeName + "' database '" + this.databaseName + "' because it is major than available nodes (" + allAvailableNodes + ")");
        }
        return quorum;
    }

    protected ODistributedResponse waitForResponse(ODistributedRequest iRequest, ODistributedResponseManager currentResponseMgr) throws InterruptedException {
        long elapsed;
        long beginTime = System.currentTimeMillis();
        if (!currentResponseMgr.waitForSynchronousResponses() && (elapsed = System.currentTimeMillis() - beginTime) > currentResponseMgr.getSynchTimeout()) {
            ODistributedServerLog.warn((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Timeout (%dms) on waiting for synchronous responses from nodes=%s responsesSoFar=%s request=(%s)", (Object[])new Object[]{elapsed, currentResponseMgr.getExpectedNodes(), currentResponseMgr.getRespondingNodes(), iRequest});
        }
        return currentResponseMgr.getFinalResponse();
    }

    protected void checkLocalNodeInConfiguration(ODistributedConfiguration cfg) {
        this.manager.executeInDistributedDatabaseLock(this.databaseName, 0L, cfg != null ? cfg.modify() : null, new OCallable<Void, OModifiableDistributedConfiguration>(){

            public Void call(OModifiableDistributedConfiguration lastCfg) {
                List foundPartition = lastCfg.addNewNodeInServerList(ODistributedDatabaseImpl.this.localNodeName);
                if (foundPartition != null) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Adding node '%s' in partition: %s db=%s v=%d", (Object[])new Object[]{ODistributedDatabaseImpl.this.localNodeName, foundPartition, ODistributedDatabaseImpl.this.databaseName, lastCfg.getVersion()});
                }
                return null;
            }
        });
    }

    protected String getLocalNodeName() {
        return this.localNodeName;
    }

    private void startAcceptingRequests() {
        int totalWorkers = OGlobalConfiguration.DISTRIBUTED_DB_WORKERTHREADS.getValueAsInteger();
        if (totalWorkers < 1) {
            throw new ODistributedException("Cannot create configured distributed workers (" + totalWorkers + ")");
        }
        this.lockThread = new ODistributedWorker(this, this.databaseName, -3);
        this.lockThread.start();
        this.unlockThread = new ODistributedWorker(this, this.databaseName, -4);
        this.unlockThread.start();
        for (int i = 0; i < totalWorkers; ++i) {
            ODistributedWorker workerThread = new ODistributedWorker(this, this.databaseName, i);
            this.workerThreads.add(workerThread);
            workerThread.start();
            ALL_QUEUES.add(i);
        }
    }

    public void setLSN(String sourceNodeName, OLogSequenceNumber taskLastLSN, boolean updateLastOperationTimestamp) throws IOException {
        if (taskLastLSN == null) {
            return;
        }
        ODistributedSyncConfiguration cfg = this.getSyncConfiguration();
        cfg.setLastLSN(sourceNodeName, taskLastLSN, updateLastOperationTimestamp);
    }

    public ODistributedDatabaseRepairer getDatabaseRepairer() {
        return this.repairer;
    }

    private void startTxTimeoutTimerTask() {
        this.txTimeoutTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ODatabaseDocumentTx database = null;
                try {
                    long now = System.currentTimeMillis();
                    long timeout = OGlobalConfiguration.DISTRIBUTED_TX_EXPIRE_TIMEOUT.getValueAsLong();
                    Iterator<ODistributedTxContext> it = ODistributedDatabaseImpl.this.activeTxContexts.values().iterator();
                    while (it.hasNext()) {
                        long started;
                        long elapsed;
                        if (!ODistributedDatabaseImpl.this.isRunning()) {
                            break;
                        }
                        ODistributedTxContext ctx = it.next();
                        if (ctx == null || (elapsed = now - (started = ctx.getStartedOn())) <= timeout) continue;
                        if (database == null) {
                            database = ODistributedDatabaseImpl.this.getDatabaseInstance();
                        }
                        ODistributedServerLog.debug((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s on database '%s' is expired after %dms", (Object[])new Object[]{ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, elapsed});
                        try {
                            ctx.rollback((ODatabaseDocumentInternal)database);
                            ctx.destroy();
                        }
                        catch (Throwable t) {
                            ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on rolling back distributed transaction %s on database '%s'", (Object[])new Object[]{ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName});
                        }
                        finally {
                            it.remove();
                        }
                    }
                }
                catch (Throwable t) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on checking for expired distributed transaction on database '%s'", (Object[])new Object[]{ODistributedDatabaseImpl.this.databaseName});
                }
                finally {
                    if (database != null) {
                        database.close();
                    }
                }
            }
        };
        Orient.instance().scheduleTask(this.txTimeoutTask, OGlobalConfiguration.DISTRIBUTED_TX_EXPIRE_TIMEOUT.getValueAsLong(), OGlobalConfiguration.DISTRIBUTED_TX_EXPIRE_TIMEOUT.getValueAsLong() / 2L);
    }

    private boolean isRunning() {
        return this.running;
    }

    public void suspend() {
        if (this.parsing.get()) {
            if (this.unlockThread != null) {
                this.unlockThread.reset();
            }
            for (ODistributedWorker w : this.workerThreads) {
                if (w == null) continue;
                w.reset();
            }
        }
        this.parsing.set(false);
    }

    public void resume() {
        this.parsing.set(true);
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("\n\nDATABASE '" + this.databaseName + "' ON SERVER '" + this.manager.getLocalNodeName() + "'");
        buffer.append("\n- " + this.manager.getLockManagerExecutor().dumpLocks());
        buffer.append("\n- " + ODistributedOutput.formatRecordLocks(this.manager, this.databaseName));
        buffer.append("\n- MESSAGES IN QUEUES:");
        buffer.append("\n - QUEUE LOCK EXECUTING: " + this.lockThread.getProcessing());
        int i = 0;
        for (ODistributedRequest m : this.lockThread.localQueue) {
            if (m == null) continue;
            buffer.append("\n  - " + i + " = " + m.toString());
        }
        buffer.append("\n - QUEUE UNLOCK EXECUTING: " + this.unlockThread.getProcessing());
        i = 0;
        for (ODistributedRequest m : this.unlockThread.localQueue) {
            if (m == null) continue;
            buffer.append("\n  - " + i + " = " + m.toString());
        }
        for (ODistributedWorker t : this.workerThreads) {
            buffer.append("\n - QUEUE " + t.id + " EXECUTING: " + t.getProcessing());
            i = 0;
            for (ODistributedRequest m : t.localQueue) {
                if (m == null) continue;
                buffer.append("\n  - " + i + " = " + m.toString());
            }
        }
        return buffer.toString();
    }

    public class ODistributedLock {
        final ORawBuffer record;
        final ODistributedRequestId reqId;
        final CountDownLatch lock;
        final long acquiredOn;

        private ODistributedLock(ODistributedRequestId reqId, ORawBuffer record) {
            this.record = record;
            this.reqId = reqId;
            this.lock = new CountDownLatch(1);
            this.acquiredOn = System.currentTimeMillis();
        }
    }
}

