/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class OAbstractReadRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;

    public OAbstractReadRecordTask() {
    }

    public OAbstractReadRecordTask(ORecordId iRid) {
        this.rid = iRid;
    }

    public ORecord getRecord() {
        return this.rid.getRecord();
    }

    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ORecord record = (ORecord)database.load((ORID)this.rid);
        if (record == null) {
            return null;
        }
        return new ORawBuffer(record);
    }

    public void toStream(DataOutput out) throws IOException {
        this.rid.toStream(out);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.rid = new ORecordId();
        this.rid.fromStream(in);
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.READ;
    }

    public String toString() {
        return this.getName() + "(" + this.rid + ")";
    }

    public boolean isIdempotent() {
        return true;
    }
}

