/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OResurrectRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;

public class ODeleteRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 4;

    public ODeleteRecordTask() {
    }

    public ODeleteRecordTask(ORecord record) {
        super(record);
    }

    public ODeleteRecordTask(ORecordId rid, int version) {
        super(rid, version);
    }

    public ORecord getRecord() {
        return null;
    }

    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Deleting record %s/%s v.%d", (Object[])new Object[]{database.getName(), this.rid.toString(), this.version});
        this.prepareUndoOperation();
        if (this.previousRecord == null) {
            return true;
        }
        ORecord loadedRecord = this.previousRecord.copy();
        if (loadedRecord != null) {
            loadedRecord.delete();
        }
        return true;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        return new OFixCreateRecordTask(this.rid, this.version);
    }

    public ORemoteTask getUndoTask(ODistributedRequestId reqId) {
        if (this.previousRecord == null) {
            return null;
        }
        OResurrectRecordTask task = new OResurrectRecordTask(this.previousRecord);
        task.setLockRecords(false);
        return task;
    }

    public void checkRecordExists() {
    }

    public String getName() {
        return "record_delete";
    }

    public String toString() {
        return this.getName() + "(" + this.rid + ")";
    }

    public int getFactoryId() {
        return 4;
    }
}

