/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ODistributedLockTask
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 26;
    private String resource;
    private long timeout;
    private boolean acquire;

    public ODistributedLockTask() {
    }

    public ODistributedLockTask(String resource, long timeout, boolean acquire) {
        this.resource = resource;
        this.timeout = timeout;
        this.acquire = acquire;
    }

    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (this.acquire) {
            iManager.getLockManagerExecutor().acquireExclusiveLock(this.resource, this.getNodeSource(), this.timeout);
        } else {
            iManager.getLockManagerExecutor().releaseExclusiveLock(this.resource, this.getNodeSource());
        }
        return true;
    }

    public ORemoteTask getUndoTask(ODistributedRequestId reqId) {
        if (this.acquire) {
            return new ODistributedLockTask(this.resource, this.timeout, false);
        }
        return null;
    }

    public int[] getPartitionKey() {
        return this.acquire ? LOCK : UNLOCK;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.ANY;
    }

    public boolean isUsingDatabase() {
        return false;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.resource);
        out.writeBoolean(this.acquire);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.resource = in.readUTF();
        this.acquire = in.readBoolean();
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public boolean isIdempotent() {
        return false;
    }

    public long getDistributedTimeout() {
        return this.timeout > 0L ? this.timeout : OGlobalConfiguration.DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "exc_lock";
    }

    public int getFactoryId() {
        return 26;
    }

    public String toString() {
        return this.getName() + " " + (this.acquire ? "acquire" : "release") + " resource=" + this.resource;
    }
}

