/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class ORepairClusterTask
extends OTxTask {
    public static final int FACTORYID = 18;
    private int clusterId;

    public ORepairClusterTask() {
    }

    public ORepairClusterTask(int clusterId) {
        this.clusterId = clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        Iterator iterator;
        String clusterName = database.getClusterNameById(this.clusterId);
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Repair cluster: repairing cluster '%s' db=%s (reqId=%s)...", (Object[])new Object[]{clusterName, database.getName(), requestId});
        ODatabaseRecordThreadLocal.INSTANCE.set(database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        ODistributedTxContext reqContext = ddb.registerTxContext(requestId);
        try {
            ODistributedConfiguration dCfg = iManager.getDatabaseConfiguration(database.getName());
            reqContext.lock((ORID)new ORecordId(this.clusterId, -1L));
            for (OAbstractRecordReplicatedTask task : this.tasks) {
                if (!task.checkForClusterAvailability(iManager.getLocalNodeName(), dCfg)) {
                    String taskResult = "_non_local_cluster";
                    continue;
                }
                task.setLockRecords(false);
                task.checkRecordExists();
                task.execute(requestId, iServer, iManager, database);
                reqContext.addUndoTask(task.getUndoTask(requestId));
            }
            iterator = null;
        }
        catch (Throwable e) {
            Throwable throwable;
            try {
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Repair cluster: rolling back transaction db=%s (reqId=%s error=%s)...", (Object[])new Object[]{database.getName(), requestId, e});
                reqContext.unlock();
                throwable = e;
            }
            catch (Throwable throwable2) {
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Repair cluster: transaction completed db=%s (reqId=%s)...", (Object[])new Object[]{database.getName(), requestId});
                throw throwable2;
            }
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Repair cluster: transaction completed db=%s (reqId=%s)...", (Object[])new Object[]{database.getName(), requestId});
            return throwable;
        }
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Repair cluster: transaction completed db=%s (reqId=%s)...", (Object[])new Object[]{database.getName(), requestId});
        return iterator;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeInt(this.clusterId);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        this.clusterId = in.readInt();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public String getName() {
        return "repair_cluster";
    }

    @Override
    public int getFactoryId() {
        return 18;
    }

    @Override
    public ORemoteTask getUndoTask(ODistributedRequestId reqId) {
        return null;
    }

    @Override
    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        return null;
    }
}

