/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OUpdateDatabaseConfigurationTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 24;
    private String databaseName;
    private ODocument configuration;

    public OUpdateDatabaseConfigurationTask() {
    }

    public OUpdateDatabaseConfigurationTask(String databaseName, ODocument cfg) {
        this.databaseName = databaseName;
        this.configuration = cfg;
    }

    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedStorage stg = (ODistributedStorage)iManager.getStorage(this.databaseName);
        if (stg != null) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Replacing distributed cfg for database '%s'\nnew: %s", (Object[])new Object[]{this.databaseName, this.configuration});
            stg.setDistributedConfiguration(new OModifiableDistributedConfiguration(this.configuration));
        }
        return true;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public boolean isUsingDatabase() {
        return false;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        byte[] stream = this.configuration.toStream();
        out.writeInt(stream.length);
        out.write(stream);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.databaseName = in.readUTF();
        int length = in.readInt();
        byte[] stream = new byte[length];
        in.readFully(stream);
        this.configuration = new ODocument().fromStream(stream);
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public boolean isIdempotent() {
        return true;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "upd_db_cfg";
    }

    public int getFactoryId() {
        return 24;
    }

    public String toString() {
        return this.getName();
    }
}

