/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.console;

import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.graph.graphml.OGraphMLReader;
import com.orientechnologies.orient.graph.graphml.OGraphSONReader;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.orient.OBonsaiTreeRepair;
import com.tinkerpop.blueprints.impls.orient.OGraphRepair;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class OGremlinConsole
extends OConsoleDatabaseApp {
    public OGremlinConsole(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result;
        try {
            boolean tty = false;
            try {
                if (OGremlinConsole.setTerminalToCBreak()) {
                    tty = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            OGremlinConsole console = new OGremlinConsole(args);
            if (tty) {
                console.setReader((OConsoleReader)new TTYConsoleReader());
            }
            result = console.run();
        }
        finally {
            try {
                OGremlinConsole.stty((String)"echo");
            }
            catch (Exception exception) {}
        }
        System.exit(result);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a GREMLIN script")
    public void gremlin(@ConsoleParameter(name="script-text", description="The script text to execute") String iScriptText) {
        block3: {
            this.checkForDatabase();
            if (iScriptText == null || iScriptText.length() == 0) {
                return;
            }
            this.resetResultSet();
            long start = System.currentTimeMillis();
            try {
                Object result = this.currentDatabase.command((OCommandRequest)new OCommandGremlin(iScriptText)).execute(new Object[0]);
                float elapsed = System.currentTimeMillis() - start;
                this.out.println("\n" + result);
                this.out.printf("\nScript executed in %f ms.", Float.valueOf(elapsed));
            }
            catch (OStorageException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof OCommandExecutorNotFoundException)) break block3;
                this.out.printf("\nError: the GREMLIN command executor is not installed, check your configuration", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConsoleCommand(description="Import a database into the current one", splitInWords=false)
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        String format;
        this.checkForDatabase();
        List items = OStringSerializerHelper.smartSplit((String)text, (char)' ', (char[])new char[0]);
        String fileName = items.size() <= 0 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        String optionsAsString = fileName != null ? text.substring(((String)items.get(0)).length() + ((String)items.get(1)).length() + 1).trim() : text;
        Map options = this.parseOptions(optionsAsString);
        String string = format = options.containsKey("-format") ? (String)((List)options.get("-format")).get(0) : null;
        if (format != null && format.equalsIgnoreCase("graphml") || fileName != null && (fileName.endsWith(".graphml") || fileName.endsWith(".xml"))) {
            this.message("\nImporting GRAPHML database from " + fileName + " with options (" + optionsAsString + ")...", new Object[0]);
            try {
                OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.currentDatabase);
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                long totalEdges = g.countEdges();
                long totalVertices = g.countVertices();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new ODatabaseImportException("Input file '" + fileName + "' not exists");
                }
                InputStream is = new FileInputStream(file);
                if (fileName.endsWith(".zip")) {
                    is = new ZipInputStream(is);
                } else if (fileName.endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                try {
                    new OGraphMLReader(g).setOptions(options).setOutput(new OCommandOutputListener(){

                        public void onMessage(String iText) {
                            System.out.print("\r" + iText);
                        }
                    }).inputGraph(is);
                    g.commit();
                    this.currentDatabase.commit();
                    this.message("\nDone: imported %d vertices and %d edges", new Object[]{g.countVertices() - totalVertices, g.countEdges() - totalEdges});
                }
                finally {
                    is.close();
                }
            }
            catch (ODatabaseImportException e) {
                this.printError((Exception)((Object)e));
            }
        } else if (format != null && format.equalsIgnoreCase("graphson") || fileName != null && fileName.endsWith(".graphson")) {
            this.message("\nImporting GRAPHSON database from " + fileName + " with options (" + optionsAsString + ")...", new Object[0]);
            try {
                OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.currentDatabase);
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                long totalEdges = g.countEdges();
                long totalVertices = g.countVertices();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new ODatabaseImportException("Input file '" + fileName + "' not exists");
                }
                InputStream is = new FileInputStream(file);
                if (fileName.endsWith(".zip")) {
                    is = new ZipInputStream(is);
                } else if (fileName.endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                try {
                    new OGraphSONReader((Graph)g).setOutput(new OCommandOutputListener(){

                        public void onMessage(String iText) {
                            System.out.print("\r" + iText);
                        }
                    }).inputGraph(is, 10000);
                    g.commit();
                    this.currentDatabase.commit();
                    this.message("\nDone: imported %d vertices and %d edges", new Object[]{g.countVertices() - totalVertices, g.countEdges() - totalEdges});
                }
                finally {
                    is.close();
                }
            }
            catch (ODatabaseImportException e) {
                this.printError((Exception)((Object)e));
            }
        } else if (format == null) {
            super.importDatabase(text);
        } else {
            throw new IllegalArgumentException("Format '" + format + "' is not supported");
        }
    }

    @ConsoleCommand(description="Export a database", splitInWords=false, onlineHelp="Console-Command-Export")
    public void exportDatabase(@ConsoleParameter(name="options", description="Export options") String iText) throws IOException {
        String fileName;
        this.checkForDatabase();
        List items = OStringSerializerHelper.smartSplit((String)iText, (char)' ', (char[])new char[0]);
        String string = fileName = items.size() <= 1 || ((String)items.get(1)).charAt(0) == '-' ? null : (String)items.get(1);
        if (fileName != null && (fileName.endsWith(".graphml") || fileName.endsWith(".xml"))) {
            this.message("\nExporting database in GRAPHML format to " + iText + "...", new Object[0]);
            try {
                OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.currentDatabase);
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                File f = new File(fileName);
                if (f.getParentFile() != null) {
                    f.getParentFile().mkdirs();
                }
                f.createNewFile();
                new GraphMLWriter((Graph)g).outputGraph(fileName);
            }
            catch (ODatabaseImportException e) {
                this.printError((Exception)((Object)e));
            }
        } else {
            super.exportDatabase(iText);
        }
    }

    @ConsoleCommand(description="Repair database structure", splitInWords=false)
    public void repairDatabase(@ConsoleParameter(name="options", description="Options: [--fix-graph] [--fix-links] [-v]] [--fix-ridbags] [--fix-bonsai]", optional=true) String iOptions) throws IOException {
        boolean fix_bonsai;
        boolean fix_ridbags;
        boolean fix_links;
        boolean fix_graph;
        this.checkForDatabase();
        boolean bl = fix_graph = iOptions == null || iOptions.contains("--fix-graph");
        if (fix_graph) {
            Map options = this.parseOptions(iOptions);
            new OGraphRepair().repair(OrientGraphFactory.getNoTxGraphImplFactory().getGraph(this.currentDatabase), (OCommandOutputListener)this, options);
        }
        boolean bl2 = fix_links = iOptions == null || iOptions.contains("--fix-links");
        if (fix_links) {
            super.repairDatabase(iOptions);
        }
        if (!this.currentDatabase.getURL().startsWith("plocal")) {
            this.message("\n fix-bonsai can be run only on plocal connection \n", new Object[0]);
            return;
        }
        boolean bl3 = fix_ridbags = iOptions == null || iOptions.contains("--fix-ridbags");
        if (fix_ridbags) {
            OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
            repairer.repairDatabaseRidbags((ODatabaseDocument)this.currentDatabase, (OCommandOutputListener)this);
        }
        boolean bl4 = fix_bonsai = iOptions == null || iOptions.contains("--fix-bonsai");
        if (fix_bonsai) {
            OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
            repairer.repairDatabaseRidbags((ODatabaseDocument)this.currentDatabase, (OCommandOutputListener)this);
        }
    }

    protected void onBefore() {
        super.onBefore();
        this.out.println("\nInstalling extensions for GREMLIN language v." + OGremlinHelper.getEngineVersion());
        OGremlinHelper.global().create();
    }

    protected boolean isCollectingCommands(String iLine) {
        return super.isCollectingCommands(iLine) || iLine.trim().equalsIgnoreCase("gremlin");
    }
}

