/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.console.ODefaultConsoleReader;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.security.OSecuritySystem;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.memory.ODirectMemoryStorage;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.OSystemDatabase;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerSocketFactoryConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.OConfigurableHooksManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.OServerSocketFactory;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpDb;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import com.orientechnologies.orient.server.plugin.OServerPluginManager;
import com.orientechnologies.orient.server.security.ODefaultServerSecurity;
import com.orientechnologies.orient.server.security.OSecurityServerUser;
import com.orientechnologies.orient.server.security.OServerSecurity;
import com.orientechnologies.orient.server.token.OTokenHandlerImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;

public class OServer {
    private static final String ROOT_PASSWORD_VAR = "ORIENTDB_ROOT_PASSWORD";
    private static ThreadGroup threadGroup;
    private static Map<String, OServer> distributedServers;
    private CountDownLatch startupLatch;
    private CountDownLatch shutdownLatch;
    private final boolean shutdownEngineOnExit;
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean running = false;
    protected OServerConfigurationManager serverCfg;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected Map<String, Class<? extends ONetworkProtocol>> networkProtocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected Map<String, OServerSocketFactory> networkSocketFactories = new HashMap<String, OServerSocketFactory>();
    protected List<OServerNetworkListener> networkListeners = new ArrayList<OServerNetworkListener>();
    protected List<OServerLifecycleListener> lifecycleListeners = new ArrayList<OServerLifecycleListener>();
    protected OServerPluginManager pluginManager;
    protected OConfigurableHooksManager hookManager;
    protected ODistributedServerManager distributedManager;
    protected OServerSecurity serverSecurity;
    private OPartitionedDatabasePoolFactory dbPoolFactory;
    private SecureRandom random = new SecureRandom();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String serverRootDirectory;
    private String databaseDirectory;
    private OClientConnectionManager clientConnectionManager;
    private ClassLoader extensionClassLoader;
    private OTokenHandler tokenHandler;
    private OSystemDatabase systemDatabase;

    public OServer() throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this(true);
    }

    public OServer(boolean shutdownEngineOnExit) throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.shutdownEngineOnExit = shutdownEngineOnExit;
        this.serverRootDirectory = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}", (String)".");
        OLogManager.instance().installCustomFormatter();
        this.defaultSettings();
        threadGroup = new ThreadGroup("OrientDB Server");
        System.setProperty("com.sun.management.jmxremote", "true");
        Orient.instance().startup();
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean() && !Orient.instance().getProfiler().isRecording()) {
            Orient.instance().getProfiler().startRecording();
        }
        this.shutdownHook = new OServerShutdownHook(this);
    }

    public static OServer getInstance(String iServerId) {
        return distributedServers.get(iServerId);
    }

    public static OServer getInstanceByPath(String iPath) {
        for (Map.Entry<String, OServer> entry : distributedServers.entrySet()) {
            if (!iPath.startsWith(entry.getValue().getDatabaseDirectory())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void registerServerInstance(String iServerId, OServer iServer) {
        distributedServers.put(iServerId, iServer);
    }

    public void setExtensionClassLoader(ClassLoader extensionClassLoader) {
        this.extensionClassLoader = extensionClassLoader;
    }

    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    public OServerSecurity getSecurity() {
        return this.serverSecurity;
    }

    public boolean isActive() {
        return this.running;
    }

    public OClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void saveConfiguration() throws IOException {
        this.serverCfg.saveConfiguration();
    }

    public void restart() throws ClassNotFoundException, InvocationTargetException, InstantiationException, NoSuchMethodException, IllegalAccessException, IOException {
        try {
            this.deinit();
        }
        finally {
            Orient.instance().startup();
            this.startup(this.serverCfg.getConfiguration());
            this.activate();
        }
    }

    public OSystemDatabase getSystemDatabase() {
        return this.systemDatabase;
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loaded = this.tryLoadClass(this.extensionClassLoader, name);
        if (loaded == null && (loaded = this.tryLoadClass(Thread.currentThread().getContextClassLoader(), name)) == null && (loaded = this.tryLoadClass(this.getClass().getClassLoader(), name)) == null) {
            loaded = Class.forName(name);
        }
        return loaded;
    }

    private Class<?> tryLoadClass(ClassLoader classLoader, String name) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public OServer startup() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        Orient.instance().startup();
        this.startup(new File(OSystemVariableResolver.resolveSystemVariables((String)config)));
        return this;
    }

    public OServer startup(File iConfigurationFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        try {
            this.serverCfg = new OServerConfigurationManager(iConfigurationFile);
            return this.startupFromConfiguration();
        }
        catch (IOException e) {
            String message = "Error on reading server configuration from file: " + iConfigurationFile;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new OConfigurationException(message), (Throwable)e);
        }
    }

    public OServer startup(String iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        return this.startup(new ByteArrayInputStream(iConfiguration.getBytes()));
    }

    public OServer startup(InputStream iInputStream) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        if (iInputStream == null) {
            throw new OConfigurationException("Configuration file is null");
        }
        this.serverCfg = new OServerConfigurationManager(iInputStream);
        return this.startupFromConfiguration();
    }

    public OServer startup(OServerConfiguration iConfiguration) throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        this.serverCfg = new OServerConfigurationManager(iConfiguration);
        return this.startupFromConfiguration();
    }

    public OServer startupFromConfiguration() throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        Orient.instance();
        if (this.startupLatch == null) {
            this.startupLatch = new CountDownLatch(1);
        }
        if (this.shutdownLatch == null) {
            this.shutdownLatch = new CountDownLatch(1);
        }
        this.clientConnectionManager = new OClientConnectionManager(this);
        this.initFromConfiguration();
        if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
            System.out.println("Dumping environment after server startup...");
            OGlobalConfiguration.dumpConfiguration((PrintStream)System.out);
        }
        this.dbPoolFactory = new OPartitionedDatabasePoolFactory();
        this.dbPoolFactory.setMaxPoolSize(this.contextConfiguration.getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX));
        this.databaseDirectory = (String)this.contextConfiguration.getValue("server.database.path", (Object)(this.serverRootDirectory + "/databases/"));
        this.databaseDirectory = OFileUtils.getPath((String)OSystemVariableResolver.resolveSystemVariables((String)this.databaseDirectory));
        this.databaseDirectory = this.databaseDirectory.replace("//", "/");
        this.databaseDirectory = new File(this.databaseDirectory).getCanonicalPath();
        this.databaseDirectory = OFileUtils.getPath((String)this.databaseDirectory);
        if (!this.databaseDirectory.endsWith("/")) {
            this.databaseDirectory = this.databaseDirectory + "/";
        }
        OLogManager.instance().info((Object)this, "Databases directory: " + new File(this.databaseDirectory).getAbsolutePath(), new Object[0]);
        Orient.instance().getProfiler().registerHookValue("system.databases", "List of databases configured in Server", OProfiler.METRIC_TYPE.TEXT, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                StringBuilder dbs = new StringBuilder(64);
                for (String dbName : OServer.this.getAvailableStorageNames().keySet()) {
                    if (dbs.length() > 0) {
                        dbs.append(',');
                    }
                    dbs.append(dbName);
                }
                return dbs.toString();
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public OServer activate() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            void var2_15;
            this.serverSecurity = new ODefaultServerSecurity(this, this.serverCfg);
            Orient.instance().setSecurity((OSecuritySystem)this.serverSecurity);
            this.initSystemDatabase();
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onBeforeActivate();
            }
            OServerConfiguration configuration = this.serverCfg.getConfiguration();
            this.tokenHandler = new OTokenHandlerImpl(this);
            if (configuration.network != null) {
                if (configuration.network.sockets != null) {
                    for (OServerSocketFactoryConfiguration oServerSocketFactoryConfiguration : configuration.network.sockets) {
                        Class<?> fClass = this.loadClass(oServerSocketFactoryConfiguration.implementation);
                        OServerSocketFactory factory = (OServerSocketFactory)fClass.newInstance();
                        try {
                            factory.config(oServerSocketFactoryConfiguration.name, oServerSocketFactoryConfiguration.parameters);
                            this.networkSocketFactories.put(oServerSocketFactoryConfiguration.name, factory);
                        }
                        catch (OConfigurationException e) {
                            OLogManager.instance().error((Object)this, "Error creating socket factory", (Throwable)e, new Object[0]);
                        }
                    }
                }
                for (OServerNetworkProtocolConfiguration oServerNetworkProtocolConfiguration : configuration.network.protocols) {
                    this.networkProtocols.put(oServerNetworkProtocolConfiguration.name, this.loadClass(oServerNetworkProtocolConfiguration.implementation));
                }
                for (OServerNetworkListenerConfiguration oServerNetworkListenerConfiguration : configuration.network.listeners) {
                    this.networkListeners.add(new OServerNetworkListener(this, this.networkSocketFactories.get(oServerNetworkListenerConfiguration.socket), oServerNetworkListenerConfiguration.ipAddress, oServerNetworkListenerConfiguration.portRange, oServerNetworkListenerConfiguration.protocol, this.networkProtocols.get(oServerNetworkListenerConfiguration.protocol), oServerNetworkListenerConfiguration.parameters, oServerNetworkListenerConfiguration.commands));
                }
            } else {
                OLogManager.instance().warn((Object)this, "Network configuration was not found", new Object[0]);
            }
            try {
                this.loadStorages();
                this.loadUsers();
                this.loadDatabases();
            }
            catch (IOException iOException) {
                String string = "Error on reading server configuration";
                OLogManager.instance().error((Object)this, "Error on reading server configuration", (Throwable)iOException, new Object[0]);
                throw OException.wrapException((OException)((Object)new OConfigurationException("Error on reading server configuration")), (Throwable)iOException);
            }
            this.registerPlugins();
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onAfterActivate();
            }
            this.running = true;
            String string = "localhost:2480";
            for (OServerNetworkListener listener : this.getNetworkListeners()) {
                if (!listener.getProtocolType().getName().equals(ONetworkProtocolHttpDb.class.getName())) continue;
                String string2 = listener.getListeningAddress(true);
            }
            OLogManager.instance().info((Object)this, "OrientDB Studio available at $ANSI{blue http://%s/studio/index.html}", new Object[]{var2_15});
            OLogManager.instance().info((Object)this, "$ANSI{green:italic OrientDB Server is active} v" + OConstants.getVersion() + ".", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.running = false;
            throw e;
        }
        catch (InstantiationException e) {
            this.running = false;
            throw e;
        }
        catch (IllegalAccessException e) {
            this.running = false;
            throw e;
        }
        catch (RuntimeException e) {
            this.running = false;
            throw e;
        }
        finally {
            this.startupLatch.countDown();
        }
        return this;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
            this.shutdownHook = null;
        }
    }

    public boolean shutdown() {
        try {
            boolean bl = this.deinit();
            return bl;
        }
        finally {
            this.startupLatch = null;
            if (this.shutdownLatch != null) {
                this.shutdownLatch.countDown();
                this.shutdownLatch = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deinit() {
        if (!this.running) {
            return false;
        }
        try {
            this.running = false;
            OLogManager.instance().info((Object)this, "OrientDB Server is shutting down...", new Object[0]);
            if (this.shutdownHook != null) {
                this.shutdownHook.cancel();
            }
            Orient.instance().getProfiler().unregisterHookValue("system.databases");
            for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                oServerLifecycleListener.onBeforeDeactivate();
            }
            this.lock.lock();
            try {
                if (this.networkListeners.size() > 0) {
                    OLogManager.instance().info((Object)this, "Shutting down listeners:", new Object[0]);
                    for (OServerNetworkListener oServerNetworkListener : this.networkListeners) {
                        OLogManager.instance().info((Object)this, "- %s", new Object[]{oServerNetworkListener});
                        try {
                            oServerNetworkListener.shutdown();
                        }
                        catch (Throwable e) {
                            OLogManager.instance().error((Object)this, "Error during shutdown of listener %s.", e, new Object[]{oServerNetworkListener});
                        }
                    }
                }
                if (this.networkProtocols.size() > 0) {
                    OLogManager.instance().info((Object)this, "Shutting down protocols", new Object[0]);
                    this.networkProtocols.clear();
                }
                for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
                    try {
                        oServerLifecycleListener.onAfterDeactivate();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during deactivation of server lifecycle listener %s", (Throwable)e, new Object[]{oServerLifecycleListener});
                    }
                }
                this.clientConnectionManager.shutdown();
                if (this.pluginManager != null) {
                    this.pluginManager.shutdown();
                }
                if (this.serverSecurity != null) {
                    this.serverSecurity.shutdown();
                }
                this.networkListeners.clear();
            }
            finally {
                this.lock.unlock();
            }
            if (this.shutdownEngineOnExit && !Orient.isRegisterDatabaseByPath()) {
                try {
                    OLogManager.instance().info((Object)this, "Shutting down databases:", new Object[0]);
                    Orient.instance().shutdown();
                }
                catch (Throwable e) {
                    OLogManager.instance().error((Object)this, "Error during OrientDB shutdown", e, new Object[0]);
                }
            }
        }
        finally {
            OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete\n", new Object[0]);
            OLogManager.instance().flush();
        }
        return true;
    }

    public void waitForShutdown() {
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            OLogManager.instance().error((Object)this, "Error during waiting for OrientDB shutdown", (Throwable)e, new Object[0]);
        }
    }

    public String getStoragePath(String iName) {
        String dbPath;
        if (iName == null) {
            throw new IllegalArgumentException("Storage path is null");
        }
        String name = iName.indexOf(58) > -1 ? iName.substring(iName.indexOf(58) + 1) : iName;
        String dbName = Orient.isRegisterDatabaseByPath() ? this.getDatabaseDirectory() + name : name;
        String string = dbPath = Orient.isRegisterDatabaseByPath() ? dbName : this.getDatabaseDirectory() + name;
        if (dbPath.contains("..")) {
            throw new IllegalArgumentException("Storage path is invalid because it contains '..'");
        }
        if (dbPath.contains("*")) {
            throw new IllegalArgumentException("Storage path is invalid because of the wildcard '*'");
        }
        if (dbPath.startsWith("/") && !dbPath.startsWith(this.getDatabaseDirectory())) {
            throw new IllegalArgumentException("Storage path is invalid because it points to an absolute directory");
        }
        OStorage stg = Orient.instance().getStorage(dbName);
        if (stg != null) {
            return stg.getURL();
        }
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        String dbURL = configuration.getStoragePath(name);
        if (dbURL == null) {
            if (new File(OIOUtils.getPathFromDatabaseName((String)dbPath) + "/database.ocf").exists()) {
                dbURL = "plocal:" + dbPath;
            } else {
                throw new OConfigurationException("Database '" + name + "' is not configured on server (home=" + this.getDatabaseDirectory() + ")");
            }
        }
        return dbURL;
    }

    public Map<String, String> getAvailableStorageNames() {
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        HashMap<String, String> storages = new HashMap<String, String>();
        if (configuration.storages != null && configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : configuration.storages) {
                storages.put(OIOUtils.getDatabaseNameFromPath((String)s.name), s.path);
            }
        }
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(new File(rootDirectory), storages);
        for (OStorage storage : Orient.instance().getStorages()) {
            String storageUrl = storage.getURL();
            if (!(storage instanceof OAbstractPaginatedStorage) || !storage.exists() || storages.containsValue(storageUrl) || !this.isStorageOfCurrentServerInstance(storage)) continue;
            storages.put(OIOUtils.getDatabaseNameFromPath((String)storage.getName()), storageUrl);
        }
        if (storages != null) {
            storages.remove("OSystem");
        }
        return storages;
    }

    /*
     * Exception decompiling
     */
    protected void loadDatabases() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean askForEncryptionKey(String iDatabaseName) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println();
        System.out.println();
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------------+}"));
        System.out.println(OAnsiCode.format((String)String.format("$ANSI{yellow | INSERT THE KEY FOR THE ENCRYPTED DATABASE %-31s|}", "'" + iDatabaseName + "'")));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------------+}"));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM setting        |}"));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow | 'storage.encryptionKey' to the key to use.                               |}"));
        System.out.println(OAnsiCode.format((String)"$ANSI{yellow +--------------------------------------------------------------------------+}"));
        System.out.print(OAnsiCode.format((String)"\n$ANSI{yellow Database encryption key [BLANK=to skip opening]: }"));
        ODefaultConsoleReader reader = new ODefaultConsoleReader();
        try {
            String key = reader.readPassword();
            if (key != null && !(key = key.trim()).isEmpty()) {
                OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.setValue((Object)key);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String getDatabaseDirectory() {
        return this.databaseDirectory;
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public OServerUserConfiguration serverLogin(String iUser, String iPassword, String iResource) {
        return this.authenticateUser(iUser, iPassword, iResource);
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        return this.authenticateUser(iUserName, iPassword, iResourceToCheck) != null;
    }

    protected OServerUserConfiguration authenticateUser(String iUserName, String iPassword, String iResourceToCheck) {
        if (this.serverSecurity != null && this.serverSecurity.isEnabled()) {
            String authUsername = this.serverSecurity.authenticate(iUserName, iPassword);
            if (authUsername != null && this.serverSecurity.isAuthorized(authUsername, iResourceToCheck)) {
                return this.serverSecurity.getUser(authUsername);
            }
        } else {
            OServerUserConfiguration user = this.getUser(iUserName);
            if (user != null && user.password != null && OSecurityManager.instance().checkPassword(iPassword, user.password) && this.isAllowed(iUserName, iResourceToCheck)) {
                return user;
            }
        }
        return null;
    }

    public boolean isAllowed(String iUserName, String iResourceToCheck) {
        if (this.serverSecurity != null && this.serverSecurity.isEnabled()) {
            if (this.serverSecurity.isAuthorized(iUserName, iResourceToCheck)) {
                return true;
            }
        } else {
            OServerUserConfiguration user = this.getUser(iUserName);
            if (user != null) {
                String[] resourceParts;
                if (user.resources.equals("*")) {
                    return true;
                }
                for (String r : resourceParts = user.resources.split(",")) {
                    if (!r.equals(iResourceToCheck)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public OServerUserConfiguration getUser(String iUserName) {
        OServerUserConfiguration userCfg = null;
        if (this.serverSecurity != null && this.serverSecurity.isEnabled()) {
            userCfg = this.serverSecurity.getUser(iUserName);
        } else if (iUserName != null && !iUserName.isEmpty()) {
            userCfg = this.serverCfg.getUser(iUserName);
        }
        return userCfg;
    }

    public void dropUser(String iUserName) throws IOException {
        this.serverCfg.dropUser(iUserName);
        this.serverCfg.saveConfiguration();
    }

    public boolean existsStoragePath(String iURL) {
        return this.serverCfg.getConfiguration().getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.serverCfg.getConfiguration();
    }

    public Map<String, Class<? extends ONetworkProtocol>> getNetworkProtocols() {
        return this.networkProtocols;
    }

    public List<OServerNetworkListener> getNetworkListeners() {
        return this.networkListeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.networkListeners) {
            if (!iProtocolClass.isAssignableFrom(l.getProtocolType())) continue;
            return (RET)l;
        }
        return null;
    }

    public Collection<OServerPluginInfo> getPlugins() {
        return this.pluginManager != null ? this.pluginManager.getPlugins() : null;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerPlugin> RET getPluginByClass(Class<RET> iPluginClass) {
        if (this.startupLatch == null) {
            throw new ODatabaseException("Error on plugin lookup: the server did not start correctly");
        }
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.running) {
            throw new ODatabaseException("Error on plugin lookup the server did not start correctly.");
        }
        for (OServerPluginInfo h : this.getPlugins()) {
            if (h.getInstance() == null || !h.getInstance().getClass().equals(iPluginClass)) continue;
            return (RET)h.getInstance();
        }
        return null;
    }

    public <RET extends OServerPlugin> RET getPlugin(String iName) {
        if (this.startupLatch == null) {
            throw new ODatabaseException("Error on plugin lookup: the server did not start correctly");
        }
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.running) {
            throw new ODatabaseException("Error on plugin lookup: the server did not start correctly");
        }
        OServerPluginInfo p = this.pluginManager.getPluginByName(iName);
        if (p != null) {
            return (RET)p.getInstance();
        }
        return null;
    }

    public Object getVariable(String iName) {
        return this.variables.get(iName);
    }

    public OServer setVariable(String iName, Object iValue) {
        if (iValue == null) {
            this.variables.remove(iName);
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    public void addTemporaryUser(String iName, String iPassword, String iPermissions) {
        this.serverCfg.setEphemeralUser(iName, iPassword, iPermissions);
    }

    public void addUser(String iName, String iPassword, String iPermissions) throws IOException {
        if (iPassword == null) {
            byte[] buffer = new byte[32];
            this.random.nextBytes(buffer);
            iPassword = OSecurityManager.instance().createSHA256(OSecurityManager.byteArrayToHexStr((byte[])buffer));
        }
        iPassword = OSecurityManager.instance().createHash(iPassword, this.getContextConfiguration().getValueAsString(OGlobalConfiguration.SECURITY_USER_PASSWORD_DEFAULT_ALGORITHM), true);
        this.serverCfg.setUser(iName, iPassword, iPermissions);
        this.serverCfg.saveConfiguration();
    }

    public OServer registerLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.add(iListener);
        return this;
    }

    public OServer unregisterLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.remove(iListener);
        return this;
    }

    public ODatabase<?> openDatabase(String iDbUrl, OToken iToken) {
        String path = this.getStoragePath(iDbUrl);
        ODatabaseDocumentTx database = new ODatabaseDocumentTx(path);
        if (database.isClosed()) {
            OStorage storage = database.getStorage();
            if (storage instanceof ODirectMemoryStorage && !storage.exists()) {
                database.create();
            } else {
                database.open(iToken);
            }
        }
        return database;
    }

    public ODatabase<?> openDatabase(String iDbUrl, String user, String password) {
        return this.openDatabase(iDbUrl, user, password, null, false);
    }

    public ODatabase<?> openDatabase(String iDbUrl, String user, String password, ONetworkProtocolData data) {
        return this.openDatabase(iDbUrl, user, password, data, false);
    }

    public ODatabaseDocumentTx openDatabase(String iDbUrl, String user, String password, ONetworkProtocolData data, boolean iBypassAccess) {
        String path = this.getStoragePath(iDbUrl);
        ODatabaseDocumentTx database = new ODatabaseDocumentTx(path);
        return this.openDatabase(database, user, password, data, iBypassAccess);
    }

    public ODatabaseDocumentTx openDatabase(ODatabaseDocumentTx database, String user, String password, ONetworkProtocolData data, boolean iBypassAccess) {
        OStorage storage = database.getStorage();
        if (database.isClosed()) {
            if (storage instanceof ODirectMemoryStorage && !storage.exists()) {
                try {
                    database.create();
                }
                catch (OStorageException oStorageException) {}
            } else if (iBypassAccess) {
                this.openDatabaseBypassingSecurity((ODatabaseInternal<?>)database, data, user);
            } else {
                OServerUserConfiguration serverUser = this.serverLogin(user, password, "database.passthrough");
                if (serverUser != null) {
                    this.openDatabaseBypassingSecurity((ODatabaseInternal<?>)database, data, serverUser.name);
                } else {
                    database.open(user, password);
                    if (data != null) {
                        data.serverUser = false;
                        data.serverUsername = null;
                    }
                }
            }
        }
        return database;
    }

    public void openDatabaseBypassingSecurity(ODatabaseInternal<?> database, ONetworkProtocolData data, String user) {
        database.activateOnCurrentThread();
        database.resetInitialization();
        database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityServerUser.class);
        database.open(user, "nopassword");
        if (data != null) {
            data.serverUser = true;
            data.serverUsername = user;
        }
    }

    public ODatabaseInternal openDatabase(ODatabaseInternal database) {
        database.activateOnCurrentThread();
        if (database.isClosed()) {
            if (database.getStorage() instanceof ODirectMemoryStorage) {
                database.create();
            } else {
                this.openDatabaseBypassingSecurity(database, null, "internal");
            }
        }
        return database;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.distributedManager;
    }

    public OPartitionedDatabasePoolFactory getDatabasePoolFactory() {
        return this.dbPoolFactory;
    }

    public void setServerRootDirectory(String rootDirectory) {
        this.serverRootDirectory = rootDirectory;
    }

    protected void initFromConfiguration() {
        OServerConfiguration cfg = this.serverCfg.getConfiguration();
        this.contextConfiguration = new OContextConfiguration();
        if (cfg.properties != null) {
            for (OServerEntryConfiguration prop : cfg.properties) {
                this.contextConfiguration.setValue(prop.name, (Object)prop.value);
            }
        }
        this.hookManager = new OConfigurableHooksManager(cfg);
    }

    protected void loadUsers() throws IOException {
        try {
            OServerConfiguration configuration = this.serverCfg.getConfiguration();
            if (configuration.isAfterFirstTime) {
                return;
            }
            configuration.isAfterFirstTime = true;
            if (OGlobalConfiguration.CREATE_DEFAULT_USERS.getValueAsBoolean()) {
                this.createDefaultServerUsers();
            }
        }
        finally {
            OSystemVariableResolver.setEnv((String)ROOT_PASSWORD_VAR, (String)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStorages() {
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        if (configuration.storages == null) {
            return;
        }
        for (OServerStorageConfiguration stg : configuration.storages) {
            int idx;
            if (!stg.loadOnStartup) continue;
            if (stg.userName == null) {
                stg.userName = "admin";
            }
            if (stg.userPassword == null) {
                stg.userPassword = "admin";
            }
            if ((idx = stg.path.indexOf(58)) == -1) {
                OLogManager.instance().error((Object)this, "-> Invalid path '" + stg.path + "' for database '" + stg.name + "'", new Object[0]);
                return;
            }
            String type = stg.path.substring(0, idx);
            ODatabaseDocumentTx db = null;
            try {
                db = new ODatabaseDocumentTx(stg.path);
                if (db.exists()) {
                    db.open(stg.userName, stg.userPassword);
                } else {
                    db.create();
                    if (stg.userName.equals("admin")) {
                        if (!stg.userPassword.equals("admin")) {
                            db.getMetadata().getSecurity().getUser("admin").setPassword(stg.userPassword);
                        }
                    } else {
                        db.getMetadata().getSecurity().createUser(stg.userName, stg.userPassword, new String[]{"admin"});
                        db.getMetadata().getSecurity().dropUser("admin");
                        db.close();
                        db.open(stg.userName, stg.userPassword);
                    }
                }
                OLogManager.instance().info((Object)this, "-> Loaded " + type + " database '" + stg.name + "'", new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "-> Cannot load " + type + " database '" + stg.name + "': " + e, new Object[0]);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    protected void createDefaultServerUsers() throws IOException {
        String rootPassword;
        block10: {
            block11: {
                if (this.serverSecurity != null && !this.serverSecurity.arePasswordsStored()) {
                    return;
                }
                rootPassword = OSystemVariableResolver.resolveVariable((String)ROOT_PASSWORD_VAR);
                if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
                    rootPassword = null;
                }
                if (rootPassword != null || this.serverCfg.existsUser("root")) break block11;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println();
                System.out.println();
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow |                WARNING: FIRST RUN CONFIGURATION               |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow | This is the first time the server is running. Please type a   |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow | password of your choice for the 'root' user or leave it blank |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow | to auto-generate it.                                          |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow |                                                               |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM     |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow | setting ORIENTDB_ROOT_PASSWORD to the root password to use.   |}"));
                System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
                ODefaultConsoleReader console = new ODefaultConsoleReader();
                do {
                    System.out.print(OAnsiCode.format((String)"\n$ANSI{yellow Root password [BLANK=auto generate it]: }"));
                    rootPassword = console.readPassword();
                    if (rootPassword != null && (rootPassword = rootPassword.trim()).isEmpty()) {
                        rootPassword = null;
                    }
                    if (rootPassword == null) continue;
                    System.out.print(OAnsiCode.format((String)"$ANSI{yellow Please confirm the root password: }"));
                    String rootConfirmPassword = console.readPassword();
                    if (rootConfirmPassword != null && (rootConfirmPassword = rootConfirmPassword.trim()).isEmpty()) {
                        rootConfirmPassword = null;
                    }
                    if (rootPassword.equals(rootConfirmPassword)) break block10;
                    System.out.println(OAnsiCode.format((String)"$ANSI{red ERROR: Passwords don't match, please reinsert both of them, or press ENTER to auto generate it}"));
                } while (rootPassword != null);
                break block10;
                {
                }
            }
            OLogManager.instance().info((Object)this, "Found ORIENTDB_ROOT_PASSWORD variable, using this value as root's password", new Object[]{rootPassword});
        }
        if (!this.serverCfg.existsUser("root")) {
            this.addUser("root", rootPassword, "*");
        }
        if (!this.serverCfg.existsUser("guest")) {
            this.addUser("guest", "guest", "connect,server.listDatabases,server.dblist");
        }
    }

    public OServerPluginManager getPluginManager() {
        return this.pluginManager;
    }

    protected void registerPlugins() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.pluginManager = new OServerPluginManager();
        this.pluginManager.config(this);
        this.pluginManager.startup();
        if (this.serverSecurity != null) {
            this.serverSecurity.onAfterDynamicPlugins();
        }
        OServerConfiguration configuration = this.serverCfg.getConfiguration();
        if (configuration.handlers != null) {
            ArrayList<OServerPlugin> plugins = new ArrayList<OServerPlugin>();
            for (OServerHandlerConfiguration h : configuration.handlers) {
                OServerPlugin plugin;
                if (h.parameters != null) {
                    boolean enabled = true;
                    for (OServerParameterConfiguration p : h.parameters) {
                        if (!p.name.equals("enabled")) continue;
                        enabled = false;
                        String value = OSystemVariableResolver.resolveSystemVariables((String)p.value);
                        if (value == null || !"true".equalsIgnoreCase(value = value.trim())) continue;
                        enabled = true;
                        break;
                    }
                    if (!enabled) continue;
                }
                if ((plugin = (OServerPlugin)this.loadClass(h.clazz).newInstance()) instanceof ODistributedServerManager) {
                    this.distributedManager = (ODistributedServerManager)((Object)plugin);
                }
                this.pluginManager.registerPlugin(new OServerPluginInfo(plugin.getName(), null, null, null, plugin, null, 0L, null));
                this.pluginManager.callListenerBeforeConfig(plugin, h.parameters);
                plugin.config(this, h.parameters);
                this.pluginManager.callListenerAfterConfig(plugin, h.parameters);
                plugins.add(plugin);
            }
            for (OServerPlugin plugin : plugins) {
                this.pluginManager.callListenerBeforeStartup(plugin);
                plugin.startup();
                this.pluginManager.callListenerAfterStartup(plugin);
            }
        }
    }

    protected void defaultSettings() {
    }

    private boolean isStorageOfCurrentServerInstance(OStorage storage) {
        if (storage.getUnderlying() instanceof OLocalPaginatedStorage) {
            String rootDirectory = this.getDatabaseDirectory();
            return storage.getURL().contains(rootDirectory);
        }
        return true;
    }

    private void scanDatabaseDirectory(File directory, Map<String, String> storages) {
        File[] files;
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File db : files) {
                if (!db.isDirectory()) continue;
                File plocalFile = new File(db.getAbsolutePath() + "/database.ocf");
                String dbPath = db.getPath().replace('\\', '/');
                int lastBS = dbPath.lastIndexOf(47, dbPath.length() - 1) + 1;
                if (plocalFile.exists()) {
                    storages.put(OIOUtils.getDatabaseNameFromPath((String)dbPath.substring(lastBS)), "plocal:" + dbPath);
                    continue;
                }
                this.scanDatabaseDirectory(db, storages);
            }
        }
    }

    public OTokenHandler getTokenHandler() {
        return this.tokenHandler;
    }

    private void initSystemDatabase() {
        this.systemDatabase = new OSystemDatabase(this);
    }

    static {
        distributedServers = new ConcurrentHashMap<String, OServer>();
    }
}

