/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OAbstractDistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import java.util.List;
import java.util.Map;

public class OQuorumDistributedConflictResolver
extends OAbstractDistributedConflictResolver {
    public static final String NAME = "quorum";

    @Override
    public ODistributedConflictResolver.OConflictResult onConflict(String databaseName, String clusterName, ORecordId rid, ODistributedServerManager dManager, Map<Object, List<String>> candidates) {
        ODistributedConflictResolver.OConflictResult result = new ODistributedConflictResolver.OConflictResult(candidates);
        Object bestResult = OQuorumDistributedConflictResolver.getBestResult(candidates, null);
        if (bestResult == NOT_FOUND) {
            return result;
        }
        ODistributedConfiguration dCfg = dManager.getDatabaseConfiguration(databaseName);
        int writeQuorum = dCfg.getWriteQuorum(clusterName, dManager.getAvailableNodes(databaseName), dManager.getLocalNodeName());
        int bestResultServerCount = candidates.get(bestResult).size();
        if (bestResultServerCount >= writeQuorum) {
            OLogManager.instance().debug((Object)this, "Quorum Conflict Resolver decided the value '%s' is the winner for record %s, because satisfies the configured writeQuorum (%d). Servers ok=%s", new Object[]{bestResult, rid, writeQuorum, candidates.get(result.winner)});
            result.winner = bestResult;
        }
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

