/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;

@StatelessCheck
public class JavadocParagraphCheck
extends AbstractJavadocCheck {
    public static final String MSG_TAG_AFTER = "javadoc.paragraph.tag.after";
    public static final String MSG_LINE_BEFORE = "javadoc.paragraph.line.before";
    public static final String MSG_REDUNDANT_PARAGRAPH = "javadoc.paragraph.redundant.paragraph";
    public static final String MSG_MISPLACED_TAG = "javadoc.paragraph.misplaced.tag";
    private boolean allowNewlineParagraph = true;

    public void setAllowNewlineParagraph(boolean value) {
        this.allowNewlineParagraph = value;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{6, 10001};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (ast.getType() == 6 && JavadocParagraphCheck.isEmptyLine(ast)) {
            this.checkEmptyLine(ast);
        } else if (ast.getType() == 10001 && JavadocUtil.getFirstChild(ast).getType() == 10006) {
            this.checkParagraphTag(ast);
        }
    }

    private void checkEmptyLine(DetailNode newline) {
        DetailNode nearestToken = JavadocParagraphCheck.getNearestNode(newline);
        if (nearestToken.getType() == 10074 && !CommonUtil.isBlank(nearestToken.getText())) {
            this.log(newline.getLineNumber(), MSG_TAG_AFTER, new Object[0]);
        }
    }

    private void checkParagraphTag(DetailNode tag) {
        DetailNode newLine = JavadocParagraphCheck.getNearestEmptyLine(tag);
        if (JavadocParagraphCheck.isFirstParagraph(tag)) {
            this.log(tag.getLineNumber(), MSG_REDUNDANT_PARAGRAPH, new Object[0]);
        } else if (newLine == null || tag.getLineNumber() - newLine.getLineNumber() != 1) {
            this.log(tag.getLineNumber(), MSG_LINE_BEFORE, new Object[0]);
        }
        if (this.allowNewlineParagraph && JavadocParagraphCheck.isImmediatelyFollowedByText(tag)) {
            this.log(tag.getLineNumber(), MSG_MISPLACED_TAG, new Object[0]);
        }
    }

    private static DetailNode getNearestNode(DetailNode node) {
        DetailNode currentNode = node;
        while (currentNode.getType() == 1 || currentNode.getType() == 6) {
            currentNode = JavadocUtil.getNextSibling(currentNode);
        }
        return currentNode;
    }

    private static boolean isEmptyLine(DetailNode newLine) {
        boolean result = false;
        DetailNode previousSibling = JavadocUtil.getPreviousSibling(newLine);
        if (previousSibling != null && previousSibling.getParent().getType() == 10000) {
            if (previousSibling.getType() == 10074 && CommonUtil.isBlank(previousSibling.getText())) {
                previousSibling = JavadocUtil.getPreviousSibling(previousSibling);
            }
            result = previousSibling != null && previousSibling.getType() == 1;
        }
        return result;
    }

    private static boolean isFirstParagraph(DetailNode paragraphTag) {
        boolean result = true;
        DetailNode previousNode = JavadocUtil.getPreviousSibling(paragraphTag);
        while (previousNode != null) {
            if (previousNode.getType() == 10074 && !CommonUtil.isBlank(previousNode.getText()) || previousNode.getType() != 1 && previousNode.getType() != 6 && previousNode.getType() != 10074) {
                result = false;
                break;
            }
            previousNode = JavadocUtil.getPreviousSibling(previousNode);
        }
        return result;
    }

    private static DetailNode getNearestEmptyLine(DetailNode node) {
        DetailNode newLine = node;
        while (newLine != null) {
            DetailNode previousSibling = JavadocUtil.getPreviousSibling(newLine);
            if (newLine.getType() == 6 && JavadocParagraphCheck.isEmptyLine(newLine)) break;
            newLine = previousSibling;
        }
        return newLine;
    }

    private static boolean isImmediatelyFollowedByText(DetailNode tag) {
        DetailNode nextSibling = JavadocUtil.getNextSibling(tag);
        return nextSibling.getType() == 6 || nextSibling.getType() == -1 || nextSibling.getText().startsWith(" ");
    }
}

