/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsConfig;
import com.slack.api.methods.SlackApiResponse;
import com.slack.api.methods.impl.AsyncExecutionSupplier;
import com.slack.api.methods.impl.AsyncMethodsRateLimiter;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.queue.QueueMessage;
import com.slack.api.rate_limits.queue.RateLimitQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRateLimitQueue
extends RateLimitQueue<AsyncExecutionSupplier<? extends SlackApiResponse>, Message> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncRateLimitQueue.class);
    private static final ConcurrentMap<String, ConcurrentMap<String, AsyncRateLimitQueue>> ALL_QUEUES = new ConcurrentHashMap<String, ConcurrentMap<String, AsyncRateLimitQueue>>();
    private AsyncMethodsRateLimiter rateLimiter;

    private static ConcurrentMap<String, AsyncRateLimitQueue> getInstance(String executorName) {
        return ALL_QUEUES.computeIfAbsent(executorName, key -> new ConcurrentHashMap());
    }

    private AsyncRateLimitQueue(MethodsConfig config) {
        this.rateLimiter = new AsyncMethodsRateLimiter(config);
    }

    public void setRateLimiter(AsyncMethodsRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public static AsyncRateLimitQueue get(String executorName, String teamId) {
        if (executorName == null || teamId == null) {
            throw new IllegalArgumentException("`executorName` and `teamId` are required");
        }
        ConcurrentMap<String, AsyncRateLimitQueue> teamIdToQueue = AsyncRateLimitQueue.getInstance(executorName);
        return (AsyncRateLimitQueue)teamIdToQueue.get(teamId);
    }

    public static AsyncRateLimitQueue getOrCreate(MethodsConfig config, String teamId) {
        if (teamId == null) {
            throw new IllegalArgumentException("`teamId` is required");
        }
        ConcurrentMap<String, AsyncRateLimitQueue> teamIdToQueue = AsyncRateLimitQueue.getInstance(config.getExecutorName());
        teamIdToQueue.computeIfPresent(teamId, (key, value) -> {
            if (value.getRateLimiter().getMetricsDatastore() != config.getMetricsDatastore()) {
                value.setRateLimiter(new AsyncMethodsRateLimiter(config));
            }
            return value;
        });
        return teamIdToQueue.computeIfAbsent(teamId, key -> new AsyncRateLimitQueue(config));
    }

    @Override
    protected AsyncMethodsRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @Override
    protected Message buildNewMessage(String messageId, long epochMillisToRun, WaitTime waitTime, AsyncExecutionSupplier<? extends SlackApiResponse> methodsSupplier) {
        return new Message(messageId, epochMillisToRun, waitTime, methodsSupplier);
    }

    public static class Message
    extends QueueMessage<AsyncExecutionSupplier<? extends SlackApiResponse>> {
        private String id;
        private long millisToRun;
        private WaitTime waitTime;
        private AsyncExecutionSupplier<?> supplier;

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public long getMillisToRun() {
            return this.millisToRun;
        }

        @Override
        @Generated
        public WaitTime getWaitTime() {
            return this.waitTime;
        }

        @Override
        @Generated
        public AsyncExecutionSupplier<?> getSupplier() {
            return this.supplier;
        }

        @Override
        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Override
        @Generated
        public void setMillisToRun(long millisToRun) {
            this.millisToRun = millisToRun;
        }

        @Override
        @Generated
        public void setWaitTime(WaitTime waitTime) {
            this.waitTime = waitTime;
        }

        @Override
        @Generated
        public void setSupplier(AsyncExecutionSupplier<?> supplier) {
            this.supplier = supplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMillisToRun() != other.getMillisToRun()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            WaitTime this$waitTime = this.getWaitTime();
            WaitTime other$waitTime = other.getWaitTime();
            if (this$waitTime == null ? other$waitTime != null : !((Object)this$waitTime).equals(other$waitTime)) {
                return false;
            }
            Object this$supplier = this.getSupplier();
            Object other$supplier = other.getSupplier();
            return !(this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $millisToRun = this.getMillisToRun();
            result = result * 59 + (int)($millisToRun >>> 32 ^ $millisToRun);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            WaitTime $waitTime = this.getWaitTime();
            result = result * 59 + ($waitTime == null ? 43 : ((Object)$waitTime).hashCode());
            Object $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncRateLimitQueue.Message(id=" + this.getId() + ", millisToRun=" + this.getMillisToRun() + ", waitTime=" + this.getWaitTime() + ", supplier=" + this.getSupplier() + ")";
        }

        @Generated
        public Message(String id, long millisToRun, WaitTime waitTime, AsyncExecutionSupplier<?> supplier) {
            this.id = id;
            this.millisToRun = millisToRun;
            this.waitTime = waitTime;
            this.supplier = supplier;
        }
    }
}

