/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.Attachment;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GsonMessageAttachmentVideoHtmlFactory
implements JsonDeserializer<Attachment.VideoHtml>,
JsonSerializer<Attachment.VideoHtml> {
    private static final String REPORT_THIS = "Please report this issue at https://github.com/slackapi/java-slack-sdk/issues";
    private final boolean failOnUnknownProperties;

    public GsonMessageAttachmentVideoHtmlFactory() {
        this(false);
    }

    public GsonMessageAttachmentVideoHtmlFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public Attachment.VideoHtml deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Attachment.VideoHtml result = new Attachment.VideoHtml();
        if (json.isJsonPrimitive()) {
            result.setHtml(json.getAsString());
            return result;
        }
        if (json.isJsonObject()) {
            JsonObject videoHtmlObject = json.getAsJsonObject();
            if (videoHtmlObject.has("source")) {
                result.setSource(videoHtmlObject.get("source").getAsString());
            }
            return result;
        }
        if (this.failOnUnknownProperties) {
            String message = "The whole value (" + json + ") is unsupported. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return result;
    }

    private List<String> parseStringArray(JsonElement json) throws JsonParseException {
        ArrayList<String> values = new ArrayList<String>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonPrimitive()) {
                values.add(elem.getAsString());
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values;
    }

    public JsonElement serialize(Attachment.VideoHtml src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.getHtml() != null) {
            return new JsonPrimitive(src.getHtml());
        }
        if (src.getSource() != null) {
            JsonObject json = new JsonObject();
            json.add("source", (JsonElement)new JsonPrimitive(src.getSource()));
            return json;
        }
        return JsonNull.INSTANCE;
    }
}

