/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.block.ActionsBlock;
import com.slack.api.model.block.CallBlock;
import com.slack.api.model.block.ContextBlock;
import com.slack.api.model.block.DividerBlock;
import com.slack.api.model.block.FileBlock;
import com.slack.api.model.block.HeaderBlock;
import com.slack.api.model.block.ImageBlock;
import com.slack.api.model.block.InputBlock;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.model.block.MarkdownBlock;
import com.slack.api.model.block.RichTextBlock;
import com.slack.api.model.block.SectionBlock;
import com.slack.api.model.block.ShareShortcutBlock;
import com.slack.api.model.block.UnknownBlock;
import com.slack.api.model.block.VideoBlock;
import java.lang.reflect.Type;

public class GsonLayoutBlockFactory
implements JsonDeserializer<LayoutBlock>,
JsonSerializer<LayoutBlock> {
    private final boolean failOnUnknownProperties;

    public GsonLayoutBlockFactory() {
        this(false);
    }

    public GsonLayoutBlockFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public LayoutBlock deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String typeName = prim.getAsString();
        Class<? extends LayoutBlock> clazz = this.getLayoutClassInstance(typeName);
        return (LayoutBlock)context.deserialize((JsonElement)jsonObject, clazz);
    }

    private Class<? extends LayoutBlock> getLayoutClassInstance(String typeName) {
        switch (typeName) {
            case "section": {
                return SectionBlock.class;
            }
            case "divider": {
                return DividerBlock.class;
            }
            case "image": {
                return ImageBlock.class;
            }
            case "context": {
                return ContextBlock.class;
            }
            case "call": {
                return CallBlock.class;
            }
            case "actions": {
                return ActionsBlock.class;
            }
            case "file": {
                return FileBlock.class;
            }
            case "input": {
                return InputBlock.class;
            }
            case "header": {
                return HeaderBlock.class;
            }
            case "markdown": {
                return MarkdownBlock.class;
            }
            case "video": {
                return VideoBlock.class;
            }
            case "rich_text": {
                return RichTextBlock.class;
            }
            case "share_shortcut": {
                return ShareShortcutBlock.class;
            }
        }
        if (this.failOnUnknownProperties) {
            throw new JsonParseException("Unsupported layout block type: " + typeName);
        }
        return UnknownBlock.class;
    }

    public JsonElement serialize(LayoutBlock src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }
}

