//[okio](../../../index.md)/[okio](../index.md)/[BufferedSink](index.md)/[flush](flush.md)

# flush

[common]\
expect abstract override fun [flush](flush.md)()

Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file.

```java
BufferedSink b0 = new Buffer();
BufferedSink b1 = Okio.buffer(b0);
BufferedSink b2 = Okio.buffer(b1);

b2.writeUtf8("hello");
assertEquals(5, b2.buffer().size());
assertEquals(0, b1.buffer().size());
assertEquals(0, b0.buffer().size());

b2.flush();
assertEquals(0, b2.buffer().size());
assertEquals(0, b1.buffer().size());
assertEquals(5, b0.buffer().size());
```

[jvm]\
actual abstract override fun [flush](flush.md)()