//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[deleteRecursively](delete-recursively.md)

# deleteRecursively

[jvm, js, native, wasm]\
[jvm]\
fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md))

[js, jvm, native, wasm]\
actual open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html))

[common]\
expect open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) = false)

Recursively deletes all children of [fileOrDirectory](delete-recursively.md) if it is a directory, then deletes [fileOrDirectory](delete-recursively.md) itself.

This function does not defend against race conditions. For example, if child files are created or deleted in [fileOrDirectory](delete-recursively.md) while this function is executing, this may fail with an [IOException](../-i-o-exception/index.md).

#### Parameters

common

| | |
|---|---|
| mustExist | true to throw an [IOException](../-i-o-exception/index.md) if there is nothing at [fileOrDirectory](delete-recursively.md) to     delete. |

#### Throws

| | |
|---|---|
| [IOException](../-i-o-exception/index.md) | if any [metadata](metadata.md), [list](list.md), or [delete](delete.md) operation fails. |