package com.vaadin.copilot;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;

import java.lang.annotation.Annotation;

import com.vaadin.flow.server.auth.AnonymousAllowed;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AccessRequirement {

    public enum Type {
        DENY_ALL(DenyAll.class),
        ANONYMOUS_ALLOWED(AnonymousAllowed.class),
        PERMIT_ALL(PermitAll.class),
        ROLES_ALLOWED(RolesAllowed.class);

        private final Class<? extends Annotation> annotationType;

        Type(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public Class<? extends Annotation> getAnnotationType() {
            return annotationType;
        }
    }

    private final Type type;
    private final String[] roles;

    public AccessRequirement(Type type) {
        this(type, null);
    }

    @JsonCreator
    public AccessRequirement(@JsonProperty("type") Type type, @JsonProperty("roles") String[] roles) {
        this.type = type;
        this.roles = roles;
    }

    public Type getType() {
        return type;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String[] getRoles() {
        return roles;
    }
}
