package com.vaadin.copilot.plugins.propertypanel;

import java.util.ArrayList;
import java.util.List;

import com.vaadin.copilot.ComponentPropertyType;

public class ComponentProperty {

    private String label;
    private Object value;
    private Object defaultValue;
    private ComponentPropertyType type;
    /**
     * Represents fully qualified class name of the property
     */
    private String qualifiedClassName;
    private boolean multiSelection = false;
    private List<ComponentPropertyOption> options = new ArrayList<>();
    // unique identifier. Method base name e.g. Enabled, Text, TooltipText
    private String propertyName;
    private boolean exceptionOnGettingDefaultValue;
    private boolean exceptionOnGettingValue;

    public ComponentProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public ComponentPropertyType getType() {
        return type;
    }

    public void setType(ComponentPropertyType type) {
        this.type = type;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Object getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isExceptionOnGettingDefaultValue() {
        return exceptionOnGettingDefaultValue;
    }

    public void setExceptionOnGettingDefaultValue(boolean exceptionOnGettingDefaultValue) {
        this.exceptionOnGettingDefaultValue = exceptionOnGettingDefaultValue;
    }

    public boolean isExceptionOnGettingValue() {
        return exceptionOnGettingValue;
    }

    public void setExceptionOnGettingValue(boolean exceptionOnGettingValue) {
        this.exceptionOnGettingValue = exceptionOnGettingValue;
    }

    public List<ComponentPropertyOption> getOptions() {
        return options;
    }

    public void setOptions(List<ComponentPropertyOption> options) {
        this.options = options;
    }

    public boolean isMultiSelection() {
        return multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public String getQualifiedClassName() {
        return qualifiedClassName;
    }

    public void setQualifiedClassName(String qualifiedClassName) {
        this.qualifiedClassName = qualifiedClassName;
    }

    public record ComponentPropertyOption(String label, Object value) {
    }
}
