/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.internal.BeanUtil;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class BeanValidator
implements com.vaadin.flow.data.binder.Validator<Object> {
    private String propertyName;
    private Class<?> beanType;

    public BeanValidator(Class<?> beanType, String propertyName) {
        if (!BeanUtil.checkBeanValidationAvailable()) {
            throw new IllegalStateException("Cannot create a " + BeanValidator.class.getSimpleName() + ": a JSR-303 Bean Validation implementation not found on the classpath");
        }
        Objects.requireNonNull(beanType, "bean class cannot be null");
        Objects.requireNonNull(propertyName, "property name cannot be null");
        this.beanType = beanType;
        this.propertyName = propertyName;
    }

    @Override
    public ValidationResult apply(Object value, ValueContext context) {
        Set violations = this.getJavaxBeanValidator().validateValue(this.beanType, this.propertyName, value, new Class[0]);
        Locale locale = context.getLocale().orElse(Locale.getDefault());
        Optional<ValidationResult> result = violations.stream().map(violation -> ValidationResult.error(this.getMessage((ConstraintViolation<?>)violation, locale))).findFirst();
        return result.orElse(ValidationResult.ok());
    }

    public String toString() {
        return String.format("%s[%s.%s]", this.getClass().getSimpleName(), this.beanType.getSimpleName(), this.propertyName);
    }

    protected static ValidatorFactory getJavaxBeanValidatorFactory() {
        return LazyFactoryInitializer.FACTORY;
    }

    public Validator getJavaxBeanValidator() {
        return BeanValidator.getJavaxBeanValidatorFactory().getValidator();
    }

    protected String getMessage(ConstraintViolation<?> violation, Locale locale) {
        return BeanValidator.getJavaxBeanValidatorFactory().getMessageInterpolator().interpolate(violation.getMessageTemplate(), this.createContext(violation), locale);
    }

    protected MessageInterpolator.Context createContext(ConstraintViolation<?> violation) {
        return new ContextImpl(violation);
    }

    private static class LazyFactoryInitializer
    implements Serializable {
        private static final ValidatorFactory FACTORY = LazyFactoryInitializer.getFactory();

        private LazyFactoryInitializer() {
        }

        private static ValidatorFactory getFactory() {
            return Validation.buildDefaultValidatorFactory();
        }
    }

    private static final class ContextImpl
    implements MessageInterpolator.Context,
    Serializable {
        private final ConstraintViolation<?> violation;

        private ContextImpl(ConstraintViolation<?> violation) {
            this.violation = violation;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.violation.getConstraintDescriptor();
        }

        public Object getValidatedValue() {
            return this.violation.getInvalidValue();
        }

        public <T> T unwrap(Class<T> type) {
            return (T)this.violation.unwrap(type);
        }
    }
}

