/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.server.Command;
import java.util.EventObject;
import java.util.Objects;

public class DataChangeEvent<T>
extends EventObject {
    private Command unregisterListenerCommand = null;

    public DataChangeEvent(DataProvider<T, ?> source) {
        super(source);
    }

    @Override
    public DataProvider<T, ?> getSource() {
        return (DataProvider)super.getSource();
    }

    void setUnregisterListenerCommand(Command unregisterListenerCommand) {
        this.unregisterListenerCommand = unregisterListenerCommand;
    }

    public void unregisterListener() throws IllegalStateException {
        if (this.unregisterListenerCommand == null) {
            throw new IllegalStateException("unregisterListener can only be called inside the event listener");
        }
        this.unregisterListenerCommand.execute();
    }

    public static class DataRefreshEvent<T>
    extends DataChangeEvent<T> {
        private final T item;
        private boolean refreshChildren;

        public DataRefreshEvent(DataProvider<T, ?> source, T item) {
            this(source, item, false);
        }

        public DataRefreshEvent(DataProvider<T, ?> source, T item, boolean refreshChildren) {
            super(source);
            Objects.requireNonNull(item, "Refreshed item can't be null");
            this.item = item;
            this.refreshChildren = refreshChildren;
        }

        public T getItem() {
            return this.item;
        }

        public boolean isRefreshChildren() {
            return this.refreshChildren;
        }
    }
}

