/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.bytecode.ClassFile;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.NameHelper;
import org.reflections.util.QueryBuilder;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionsClassFinder
implements ClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionsClassFinder.class);
    private final transient ClassLoader classLoader;
    private final transient Reflections reflections;
    private static final Vfs.UrlType IGNORE_NOT_HANDLED_FILES = new Vfs.UrlType(){

        public boolean matches(URL url) {
            return "file".equals(url.getProtocol());
        }

        public Vfs.Dir createDir(final URL url) {
            LOGGER.debug("Class finder cannot scan {} URL. Probably pointing to a not existing folder.", (Object)url);
            return new Vfs.Dir(){

                public String getPath() {
                    return url.getPath().replace("\\", "/");
                }

                public Iterable<Vfs.File> getFiles() {
                    return Collections.emptyList();
                }
            };
        }
    };

    public ReflectionsClassFinder(URL ... urls) {
        this(new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()), urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectionsClassFinder(ClassLoader classLoader, URL ... urls) {
        this.classLoader = classLoader;
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{classLoader}).setExpandSuperTypes(false).addUrls(urls);
        ConfigurationBuilder.DEFAULT_SCANNERS.forEach(xva$0 -> configurationBuilder.addScanners(new Scanner[]{xva$0}));
        configurationBuilder.addScanners(new Scanner[]{PackageScanner.INSTANCE});
        configurationBuilder.setInputsFilter(resourceName -> resourceName.endsWith(".class") && !resourceName.endsWith("module-info.class"));
        List defaultUrlTypes = Vfs.getDefaultUrlTypes();
        if (!defaultUrlTypes.contains(IGNORE_NOT_HANDLED_FILES)) {
            defaultUrlTypes.add(IGNORE_NOT_HANDLED_FILES);
        }
        try {
            this.reflections = new LoggingReflections((Configuration)configurationBuilder);
        }
        finally {
            defaultUrlTypes.remove(IGNORE_NOT_HANDLED_FILES);
        }
    }

    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        classes.addAll(this.reflections.getTypesAnnotatedWith(clazz, true));
        classes.addAll(this.getAnnotatedByRepeatedAnnotation(clazz));
        return this.sortedByClassName(classes);
    }

    private Set<Class<?>> getAnnotatedByRepeatedAnnotation(AnnotatedElement annotationClass) {
        Repeatable repeatableAnnotation = annotationClass.getAnnotation(Repeatable.class);
        if (repeatableAnnotation != null) {
            return this.reflections.getTypesAnnotatedWith(repeatableAnnotation.value(), true);
        }
        return Collections.emptySet();
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public boolean shouldInspectClass(String className) {
        if (!this.reflections.get(PackageScanner.INSTANCE.of(PackageScanner.extractPackageName(className))).isEmpty()) {
            return this.classLoader.getResource(className.replace('.', '/') + ".class") != null;
        }
        return false;
    }

    public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return this.sortedByClassName(this.reflections.getSubTypesOf(type));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private <T> Set<Class<? extends T>> sortedByClassName(Set<Class<? extends T>> source) {
        return source.stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static class PackageScanner
    implements Scanner,
    QueryBuilder,
    NameHelper {
        private static final PackageScanner INSTANCE = new PackageScanner();

        private PackageScanner() {
        }

        public List<Map.Entry<String, String>> scan(ClassFile classFile) {
            String packageName = PackageScanner.extractPackageName(classFile.getName());
            if (!packageName.isEmpty()) {
                return List.of(this.entry(packageName, packageName));
            }
            return List.of();
        }

        public String index() {
            return "PackageScanner";
        }

        static String extractPackageName(String className) {
            int dot = className.lastIndexOf(46);
            if (dot != -1) {
                return className.substring(0, dot);
            }
            return "";
        }
    }

    private static class LoggingReflections
    extends Reflections {
        LoggingReflections(Configuration configuration) {
            super(configuration);
        }

        public Class<?> forClass(String typeName, ClassLoader ... loaders) {
            Object type;
            if (primitiveNames.contains(typeName)) {
                return (Class)primitiveTypes.get(primitiveNames.indexOf(typeName));
            }
            if (typeName.contains("[")) {
                int i = typeName.indexOf("[");
                type = typeName.substring(0, i);
                String array = typeName.substring(i).replace("]", "");
                type = primitiveNames.contains(type) ? (String)primitiveDescriptors.get(primitiveNames.indexOf(type)) : "L" + (String)type + ";";
                type = array + (String)type;
            } else {
                type = typeName;
            }
            for (ClassLoader classLoader : ClasspathHelper.classLoaders((ClassLoader[])loaders)) {
                if (((String)type).contains("[")) {
                    try {
                        return Class.forName((String)type, false, classLoader);
                    }
                    catch (Throwable ignored) {
                        LOGGER.debug("Can't find class {}", type, (Object)ignored);
                    }
                }
                try {
                    return classLoader.loadClass((String)type);
                }
                catch (Throwable ignored) {
                    LOGGER.debug("Can't load class {}", type, (Object)ignored);
                }
            }
            return null;
        }
    }
}

