/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import org.slf4j.LoggerFactory;

class VersionsJsonFilter {
    private final ObjectNode userManagedDependencies;
    private final String dependenciesKey;
    private static final String OLDER_VERSION_WARNING = "Using user (package.json) pinned version '{}' of '{}' which is older than the current platform version '{}'";

    VersionsJsonFilter(ObjectNode packageJson, String dependenciesKey) {
        this.dependenciesKey = dependenciesKey;
        this.userManagedDependencies = this.collectUserManagedDependencies(packageJson);
    }

    ObjectNode getFilteredVersions(ObjectNode versions, String versionOrigin) {
        ObjectNode json = JacksonUtils.createObjectNode();
        for (String key : JacksonUtils.getKeys((JsonNode)versions)) {
            FrontendVersion version = FrontendUtils.getPackageVersionFromJson((JsonNode)versions, key, versionOrigin);
            if (version == null || version.getFullVersion().contains("SNAPSHOT")) continue;
            FrontendVersion userManagedVersion = FrontendUtils.getPackageVersionFromJson((JsonNode)this.userManagedDependencies, key, "/package.json -> { dependencies }");
            if (userManagedVersion != null && version.isNewerThan(userManagedVersion)) {
                LoggerFactory.getLogger((String)"Versions").warn(OLDER_VERSION_WARNING, new Object[]{this.userManagedDependencies.get(key).textValue(), key, versions.get(key).textValue()});
            }
            json.put(key, versions.get(key).textValue());
        }
        return json;
    }

    private ObjectNode collectUserManagedDependencies(ObjectNode packageJson) {
        ObjectNode json = JacksonUtils.createObjectNode();
        JsonNode vaadinDep = this.collectFrameworkVersions(packageJson);
        if (packageJson.has(this.dependenciesKey)) {
            JsonNode dependencies = packageJson.get(this.dependenciesKey);
            for (String key : JacksonUtils.getKeys(dependencies)) {
                if (!this.isUserChanged(key, vaadinDep, dependencies)) continue;
                json.put(key, dependencies.get(key).textValue());
            }
        }
        return json;
    }

    private boolean isUserChanged(String key, JsonNode vaadinDep, JsonNode dependencies) {
        if (vaadinDep.has(key)) {
            try {
                FrontendVersion vaadin = new FrontendVersion(key, vaadinDep.get(key).textValue());
                FrontendVersion dep = new FrontendVersion(key, dependencies.get(key).textValue());
                return !vaadin.isEqualTo(dep);
            }
            catch (NumberFormatException nfe) {
                LoggerFactory.getLogger((String)"VersionsFilter").debug("Received version with non numbers {} and {}", (Object)vaadinDep.get(key).textValue(), (Object)dependencies.get(key).textValue());
                return !vaadinDep.get(key).textValue().equals(dependencies.get(key).textValue());
            }
        }
        return true;
    }

    private JsonNode collectFrameworkVersions(ObjectNode packageJson) {
        if (packageJson.has("vaadin") && packageJson.get("vaadin").has(this.dependenciesKey)) {
            return packageJson.get("vaadin").get(this.dependenciesKey);
        }
        return JacksonUtils.createObjectNode();
    }
}

