/*
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.router;

import java.io.Serializable;

import com.vaadin.flow.server.RouteRegistry;

/**
 * Listener that gets notified when the registered routes for a
 * {@link RouteRegistry} are changed in some way.
 *
 * @since 1.3
 *
 * @see RouteRegistry#addRoutesChangeListener(RoutesChangedListener)
 */
@FunctionalInterface
public interface RoutesChangedListener extends Serializable {
    /**
     * Invoked when this listener receives a route change event from a
     * RouteRegistry.
     *
     * @param event
     *            event containing change data, not null
     */
    void routesChanged(RoutesChangedEvent event);

}
