/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.Capabilities;
import com.vaadin.pro.licensechecker.Capability;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.MissingLicenseKeyException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLicenseCheckerServiceInitListener
implements VaadinServiceInitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseLicenseCheckerServiceInitListener.class);
    private final String productName;
    private final String productVersion;

    protected BaseLicenseCheckerServiceInitListener(String productName, String productVersion) {
        this.productName = productName;
        this.productVersion = productVersion;
    }

    @Override
    public void serviceInit(ServiceInitEvent event) {
        VaadinService service = event.getSource();
        DeploymentConfiguration configuration = service.getDeploymentConfiguration();
        if (!configuration.isProductionMode()) {
            BuildType buildType = null;
            if (configuration.isDevToolsEnabled()) {
                try {
                    LicenseChecker.checkLicense((String)this.productName, (String)this.productVersion, buildType, url -> {
                        throw new MissingLicenseKeyException("No license key present");
                    }, (int)0, (Capabilities)Capabilities.of((Capability)Capability.PRE_TRIAL));
                }
                catch (MissingLicenseKeyException ex) {
                    LOGGER.debug("Missing license key for {} {} will be handled by Vaadin Dev Server", (Object)this.productName, (Object)this.productVersion);
                    CheckProductLicense.register(event, this.productName, this.productVersion);
                }
            } else {
                LicenseChecker.checkLicense((String)this.productName, (String)this.productVersion, (Capabilities)Capabilities.of((Capability)Capability.PRE_TRIAL), buildType);
            }
        }
    }

    private static final class CheckProductLicense
    implements IndexHtmlRequestListener {
        private final Set<Pair<String, String>> products = new LinkedHashSet<Pair<String, String>>();

        private CheckProductLicense() {
        }

        static void register(ServiceInitEvent event, String productName, String productVersion) {
            event.getAddedIndexHtmlRequestListeners().filter(CheckProductLicense.class::isInstance).map(CheckProductLicense.class::cast).findFirst().orElseGet(() -> {
                CheckProductLicense listener = new CheckProductLicense();
                event.addIndexHtmlRequestListener(listener);
                return listener;
            }).addProduct(productName, productVersion);
        }

        private void addProduct(String productName, String productVersion) {
            this.products.add(new Pair<String, String>(productName, productVersion));
        }

        @Override
        public void modifyIndexHtmlResponse(IndexHtmlResponse indexHtmlResponse) {
            StringBuilder script = new StringBuilder("window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.devTools = window.Vaadin.devTools || {};\nwindow.Vaadin.devTools.createdCvdlElements =\nwindow.Vaadin.devTools.createdCvdlElements || [];\n\nconst registerProduct = function(productName,productVersion) {\n    const product = {};\n    product.constructor['cvdlName'] = productName;\n    product.constructor['version'] = productVersion\n    product.tagName = `--${productName}`;\n    window.Vaadin.devTools.createdCvdlElements.push(product);\n};\n");
            this.products.forEach(product -> script.append("registerProduct('%s','%s');".formatted(product.getFirst(), product.getSecond())));
            Document document = indexHtmlResponse.getDocument();
            Element elm = new Element("script");
            elm.attr("initial", "");
            elm.appendChild((Node)new DataNode(script.toString()));
            document.head().insertChildren(0, new Node[]{elm});
        }
    }
}

