/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.core;

import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.core.SharedStorage;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractPlugin<C extends PluginConfiguration>
implements Plugin {
    private C configuration;
    private SharedStorage storage;

    protected AbstractPlugin() {
    }

    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(PluginConfiguration configuration) {
        if (configuration == null) {
            this.configuration = null;
            return;
        }
        Class configClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (configClass.equals(PluginConfiguration.class)) {
            throw new IllegalArgumentException(String.format("The '%s' plugin does not expect configuration set", this.getClass().getName()));
        }
        if (!configClass.isAssignableFrom(configuration.getClass())) {
            throw new IllegalArgumentException(String.format("Requires instance of %s , but got %s", configClass, configuration.getClass()));
        }
        this.configuration = configuration;
    }

    protected SharedStorage getStorage() {
        return this.storage;
    }

    @Override
    public void setStorage(SharedStorage storage) {
        this.storage = storage;
    }
}

