/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.transfertypes;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.jackson.JacksonPropertyModel;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.PropertyNode;
import com.vaadin.hilla.parser.plugins.transfertypes.MultipartFileUsageException;
import org.jspecify.annotations.NonNull;

public class MultipartFileCheckerPlugin
extends AbstractPlugin<PluginConfiguration> {
    private static final String MULTIPART_CLASS_NAME = "org.springframework.web.multipart.MultipartFile";

    public void enter(NodePath<?> nodePath) {
        ClassRefSignatureModel classRefSignatureModel;
        MethodNode methodNode;
        PropertyNode propertyNode;
        Object nodeType;
        Node node = nodePath.getNode();
        if (node instanceof PropertyNode && ClassInfoModel.isAssignableFrom((String)MULTIPART_CLASS_NAME, (Class)(nodeType = ((JacksonPropertyModel)(propertyNode = (PropertyNode)node).getSource()).get().getRawPrimaryType()))) {
            throw new MultipartFileUsageException("MultipartFile is not allowed in entity classes: " + ((Class)nodeType).getName());
        }
        nodeType = nodePath.getNode();
        if (nodeType instanceof MethodNode && (nodeType = ((MethodInfoModel)(methodNode = (MethodNode)nodeType).getSource()).getResultType()) instanceof ClassRefSignatureModel && ClassInfoModel.isAssignableFrom((String)MULTIPART_CLASS_NAME, (ClassInfoModel)(classRefSignatureModel = (ClassRefSignatureModel)nodeType).getClassInfo())) {
            throw new MultipartFileUsageException("MultipartFile is not allowed as return type: " + methodNode.getSource());
        }
    }

    public void exit(NodePath<?> nodePath) {
    }

    public @NonNull NodeDependencies scan(@NonNull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }
}

