/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.transfertypes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.mappedtypes.Order;
import com.vaadin.hilla.mappedtypes.Pageable;
import com.vaadin.hilla.mappedtypes.Sort;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.core.RootNode;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EntityNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import com.vaadin.hilla.runtime.transfertypes.EndpointSubscription;
import com.vaadin.hilla.runtime.transfertypes.File;
import com.vaadin.hilla.runtime.transfertypes.Flux;
import com.vaadin.hilla.runtime.transfertypes.ListSignal;
import com.vaadin.hilla.runtime.transfertypes.NumberSignal;
import com.vaadin.hilla.runtime.transfertypes.Signal;
import com.vaadin.hilla.runtime.transfertypes.ValueSignal;
import com.vaadin.hilla.transfertypes.annotations.FromModule;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.NonNull;

public final class TransferTypesPlugin
extends AbstractPlugin<PluginConfiguration> {
    private static final Map<String, Class<?>> classMap = new HashMap();

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
        Node node = nodePath.getNode();
        if (node instanceof EntityNode) {
            EntityNode entityNode = (EntityNode)node;
            node = nodePath.getParentPath().getNode();
            if (node instanceof RootNode) {
                RootNode rootNode = (RootNode)node;
                ClassInfoModel cls = (ClassInfoModel)entityNode.getSource();
                if (classMap.containsValue((Class)cls.get())) {
                    Schema schema = (Schema)entityNode.getTarget();
                    cls.getAnnotations().stream().filter(model -> model.getName().equals(FromModule.class.getName())).findFirst().ifPresent(annotationModel -> {
                        FromModule annotation = (FromModule)annotationModel.get();
                        String namedSpecifier = annotation.namedSpecifier();
                        String defaultSpecifier = annotation.defaultSpecifier();
                        if (namedSpecifier.isBlank() && defaultSpecifier.isBlank()) {
                            throw new IllegalArgumentException(String.format("@FromModule annotation for class %s must have at least one named specifier or a default specifier", cls.getName()));
                        }
                        HashMap<String, String> fromModule = new HashMap<String, String>();
                        fromModule.put("module", annotation.module());
                        if (!namedSpecifier.isBlank()) {
                            fromModule.put("named", namedSpecifier);
                        }
                        if (!defaultSpecifier.isBlank()) {
                            fromModule.put("default", defaultSpecifier);
                        }
                        schema.addExtension("x-from-module", fromModule);
                    });
                }
            }
        }
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    public @NonNull Node<?, ?> resolve(@NonNull Node<?, ?> node, @NonNull NodePath<?> nodePath) {
        if (!(node instanceof TypedNode)) {
            return node;
        }
        TypedNode typedNode = (TypedNode)node;
        return (Node)typedNode.processType(signature -> {
            if (!(signature instanceof ClassRefSignatureModel)) {
                return signature;
            }
            ClassRefSignatureModel classRef = (ClassRefSignatureModel)signature;
            String className = classRef.getClassInfo().getName();
            if (!classMap.containsKey(className)) {
                return signature;
            }
            ClassInfoModel mappedClassInfo = ClassInfoModel.of(classMap.get(className));
            return ClassRefSignatureModel.of((ClassInfoModel)mappedClassInfo, (List)classRef.getTypeArguments(), (List)classRef.getAnnotations());
        });
    }

    static {
        classMap.put("org.springframework.data.domain.Page", List.class);
        classMap.put("org.springframework.data.domain.Pageable", Pageable.class);
        classMap.put("org.springframework.data.domain.Sort$Order", Order.class);
        classMap.put("org.springframework.data.domain.Sort", Sort.class);
        classMap.put(UUID.class.getName(), String.class);
        classMap.put("reactor.core.publisher.Flux", Flux.class);
        classMap.put("com.vaadin.hilla.EndpointSubscription", EndpointSubscription.class);
        classMap.put(JsonNode.class.getName(), Object.class);
        classMap.put(ObjectNode.class.getName(), Object.class);
        classMap.put(ArrayNode.class.getName(), List.class);
        classMap.put("org.springframework.web.multipart.MultipartFile", File.class);
        classMap.put("com.vaadin.hilla.signals.Signal", Signal.class);
        classMap.put("com.vaadin.hilla.signals.ValueSignal", ValueSignal.class);
        classMap.put("com.vaadin.hilla.signals.NumberSignal", NumberSignal.class);
        classMap.put("com.vaadin.hilla.signals.ListSignal", ListSignal.class);
    }
}

