/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform
implements Serializable {
    static final String HILLA_POM_PROPERTIES = "META-INF/maven/com.vaadin/hilla/pom.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(Platform.class);
    static String hillaVersion = null;
    static String vaadinVersion = null;

    public static Optional<String> getVaadinVersion() {
        if (vaadinVersion == null) {
            try (InputStream vaadinPomProperties = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/maven/com.vaadin/vaadin-core/pom.properties");){
                if (vaadinPomProperties != null) {
                    Properties properties = new Properties();
                    properties.load(vaadinPomProperties);
                    vaadinVersion = properties.getProperty("version", "");
                } else {
                    LOGGER.info("Unable to determine Vaadin version. No META-INF/maven/com.vaadin/vaadin-core/pom.properties found");
                    vaadinVersion = "";
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to determine Vaadin version", (Throwable)e);
                vaadinVersion = "";
            }
        }
        return vaadinVersion.isEmpty() ? Optional.empty() : Optional.of(vaadinVersion);
    }

    public static Optional<String> getHillaVersion() {
        if (hillaVersion == null) {
            try (InputStream hillaPomProperties = Thread.currentThread().getContextClassLoader().getResourceAsStream(HILLA_POM_PROPERTIES);){
                if (hillaPomProperties != null) {
                    Properties properties = new Properties();
                    properties.load(hillaPomProperties);
                    hillaVersion = properties.getProperty("version", "");
                } else {
                    LOGGER.info("Unable to determine Hilla version. No {} found", (Object)HILLA_POM_PROPERTIES);
                    hillaVersion = "";
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to determine Hilla version", (Throwable)e);
                hillaVersion = "";
            }
        }
        return hillaVersion.isEmpty() ? Optional.empty() : Optional.of(hillaVersion);
    }
}

