/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dashboard;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dashboard.Dashboard;
import com.vaadin.flow.component.dashboard.DashboardChildDetachHandler;
import com.vaadin.flow.component.dashboard.DashboardWidget;
import com.vaadin.flow.component.dashboard.HasWidgets;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-dashboard-section")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.2"), @NpmPackage(value="@vaadin/dashboard", version="24.9.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/dashboard/src/vaadin-dashboard-section.js")})
public class DashboardSection
extends Component
implements HasWidgets {
    private final List<DashboardWidget> widgets = new ArrayList<DashboardWidget>();
    private final DashboardChildDetachHandler childDetachHandler = this.getChildDetachHandler();

    public DashboardSection() {
        this(null);
    }

    public DashboardSection(String title) {
        this.setTitle(title);
    }

    public String getTitle() {
        return this.getElement().getProperty("sectionTitle");
    }

    public void setTitle(String title) {
        this.getElement().setProperty("sectionTitle", title);
    }

    @Override
    public List<DashboardWidget> getWidgets() {
        return Collections.unmodifiableList(this.widgets);
    }

    public Stream<Component> getChildren() {
        return this.widgets.stream().map(Component.class::cast);
    }

    @Override
    public void add(Collection<DashboardWidget> widgets) {
        Objects.requireNonNull(widgets, "Widgets to add cannot be null.");
        widgets.forEach(widget -> Objects.requireNonNull(widget, "Widget to add cannot be null."));
        widgets.forEach(this::doAddWidget);
        this.updateClient();
    }

    @Override
    public void addWidgetAtIndex(int index, DashboardWidget widget) {
        Objects.requireNonNull(widget, "Widget to add cannot be null.");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a widget with a negative index.");
        }
        if (index > this.getWidgets().size()) {
            throw new IllegalArgumentException(String.format("Cannot add a widget with index %d when there are %d widgets", index, this.getWidgets().size()));
        }
        this.doAddWidgetAtIndex(index, widget);
        this.updateClient();
    }

    @Override
    public void remove(Collection<DashboardWidget> widgets) {
        Objects.requireNonNull(widgets, "Widgets to remove cannot be null.");
        ArrayList<DashboardWidget> toRemove = new ArrayList<DashboardWidget>(widgets.size());
        for (DashboardWidget widget : widgets) {
            Objects.requireNonNull(widget, "Widget to remove cannot be null.");
            Element parent = widget.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(this.getClass()).debug("Removal of a widget with no parent does nothing.");
                continue;
            }
            if (this.getElement().equals((Object)parent)) {
                toRemove.add(widget);
                continue;
            }
            throw new IllegalArgumentException("The given widget (" + widget + ") is not a child of this section");
        }
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this::doRemoveWidget);
            this.updateClient();
        }
    }

    @Override
    public void removeAll() {
        if (this.getWidgets().isEmpty()) {
            return;
        }
        this.doRemoveAll();
        this.updateClient();
    }

    public void removeFromParent() {
        this.getParent().ifPresent(parent -> ((Dashboard)parent).remove(this));
    }

    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException("Dashboard section does not support setting visibility");
    }

    public boolean isVisible() {
        return true;
    }

    private void doRemoveAll() {
        new ArrayList<DashboardWidget>(this.widgets).forEach(this::doRemoveWidget);
    }

    private void doRemoveWidget(DashboardWidget widget) {
        this.getElement().removeChild(new Element[]{widget.getElement()});
        this.widgets.remove((Object)widget);
    }

    private void doAddWidgetAtIndex(int index, DashboardWidget widget) {
        this.getElement().appendChild(new Element[]{widget.getElement()});
        this.widgets.add(index, widget);
    }

    private void doAddWidget(DashboardWidget widget) {
        this.getElement().appendChild(new Element[]{widget.getElement()});
        this.widgets.add(widget);
    }

    void reorderWidgets(List<DashboardWidget> orderedWidgets) {
        this.widgets.clear();
        this.widgets.addAll(orderedWidgets);
    }

    void updateClient() {
        this.childDetachHandler.refreshListeners();
        this.getParent().ifPresent(parent -> ((Dashboard)parent).updateClient());
    }

    private DashboardChildDetachHandler getChildDetachHandler() {
        return new DashboardChildDetachHandler(this){

            @Override
            void removeChild(Component child) {
                DashboardSection.this.widgets.remove(child);
                DashboardSection.this.updateClient();
            }
        };
    }
}

