/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class MapSerializer
implements Serializable {
    private final ObjectWriter writer;

    public MapSerializer() {
        SimpleModule module = new SimpleModule().addSerializer(StreamResource.class, (JsonSerializer)new StreamResourceSerializer());
        SimpleModule downloadModule = new SimpleModule().addSerializer(DownloadHandler.class, (JsonSerializer)new DownloadHandlerSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)downloadModule);
        this.writer = mapper.writer();
    }

    public JsonValue toJson(Object value) {
        String json;
        try {
            json = this.writer.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while serializing " + value.getClass().getSimpleName(), e);
        }
        return new JreJsonFactory().parse(json);
    }

    @Deprecated(since="24.8", forRemoval=true)
    private static class StreamResourceSerializer
    extends StdSerializer<StreamResource> {
        private final Map<StreamResource, URI> streamResourceURICache = new HashMap<StreamResource, URI>();

        public StreamResourceSerializer() {
            super(StreamResource.class);
        }

        public void serialize(StreamResource value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            URI uri = this.getURI(value);
            gen.writeString(uri.toString());
        }

        private URI getURI(StreamResource resource) {
            URI uri = this.streamResourceURICache.get(resource);
            if (uri == null) {
                StreamResourceRegistry resourceRegistry = UI.getCurrent().getSession().getResourceRegistry();
                StreamRegistration streamRegistration = resourceRegistry.registerResource((AbstractStreamResource)resource);
                uri = streamRegistration.getResourceUri();
                this.streamResourceURICache.put(resource, uri);
            }
            return uri;
        }
    }

    private static class DownloadHandlerSerializer
    extends StdSerializer<DownloadHandler> {
        private final Map<DownloadHandler, URI> streamResourceURICache = new HashMap<DownloadHandler, URI>();

        public DownloadHandlerSerializer() {
            super(DownloadHandler.class);
        }

        public void serialize(DownloadHandler value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            URI uri = this.getURI(value);
            gen.writeString(uri.toString());
        }

        private URI getURI(DownloadHandler resource) {
            URI uri = this.streamResourceURICache.get(resource);
            if (uri == null) {
                StreamResourceRegistry resourceRegistry = UI.getCurrent().getSession().getResourceRegistry();
                StreamRegistration streamRegistration = resourceRegistry.registerResource((ElementRequestHandler)resource);
                uri = streamRegistration.getResourceUri();
                this.streamResourceURICache.put(resource, uri);
            }
            return uri;
        }
    }
}

