/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.source;

import com.vaadin.flow.component.map.configuration.source.TileImageSource;
import java.util.Map;
import java.util.Objects;

public class TileWMSSource
extends TileImageSource {
    private final int gutter;
    private final Map<String, Object> params;
    private final String serverType;

    public TileWMSSource(Options options) {
        super(options);
        Objects.requireNonNull(options.params, "WMS request parameters must not be null");
        Objects.requireNonNull(options.params.get("LAYERS"), "WMS request parameter LAYERS must not be null");
        this.gutter = options.gutter;
        this.params = options.params;
        this.serverType = options.serverType;
    }

    @Override
    public String getType() {
        return "ol/source/TileWMS";
    }

    public int getGutter() {
        return this.gutter;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getServerType() {
        return this.serverType;
    }

    public static class Options
    extends TileImageSource.Options {
        private int gutter = 0;
        private Map<String, Object> params;
        private String serverType;

        public void setGutter(int gutter) {
            this.gutter = gutter;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public void setServerType(String serverType) {
            this.serverType = serverType;
        }
    }
}

