/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.popover;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.popover.PopoverPosition;
import com.vaadin.flow.component.popover.PopoverVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.internal.ModalRoot;
import com.vaadin.flow.component.shared.internal.OverlayClassListProxy;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachEvent;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

@Tag(value="vaadin-popover")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.5"), @NpmPackage(value="@vaadin/popover", version="24.9.5")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/popover/src/vaadin-popover.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./vaadin-popover/popover.ts")})
public class Popover
extends Component
implements HasAriaLabel,
HasComponents,
HasThemeVariant<PopoverVariant> {
    private static Integer defaultHideDelay;
    private static Integer defaultFocusDelay;
    private static Integer defaultHoverDelay;
    static final AtomicBoolean uiInitListenerRegistered;
    private Component target;
    private Registration targetAttachRegistration;
    private Registration targetDetachRegistration;
    private boolean autoAddedToTheUi;
    private boolean openOnClick = true;
    private boolean openOnHover = false;
    private boolean openOnFocus = false;
    private Map<Element, Registration> childDetachListenerMap = new HashMap<Element, Registration>();
    private ElementDetachListener childDetachListener = new ElementDetachListener(){

        public void onDetach(ElementDetachEvent e) {
            boolean childDetachedFromContainer;
            Element child = e.getSource();
            boolean bl = childDetachedFromContainer = !Popover.this.getElement().getChildren().anyMatch(containerChild -> Objects.equals(child, containerChild));
            if (childDetachedFromContainer) {
                Popover.this.childDetachListenerMap.get(child).remove();
                Popover.this.childDetachListenerMap.remove(child);
                Popover.this.updateVirtualChildNodeIds();
            }
        }
    };

    public Popover() {
        this.getElement().getNode().addAttachListener(this::attachComponentRenderer);
        this.getElement().setProperty("opened", false);
        this.updateTrigger();
        this.setOverlayRole("dialog");
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
    }

    public Popover(Component ... components) {
        this();
        this.add(components);
    }

    public static void setDefaultFocusDelay(int defaultFocusDelay) {
        Popover.defaultFocusDelay = defaultFocusDelay;
        Popover.applyConfiguration();
    }

    public static void setDefaultHideDelay(int defaultHideDelay) {
        Popover.defaultHideDelay = defaultHideDelay;
        Popover.applyConfiguration();
    }

    public static void setDefaultHoverDelay(int defaultHoverDelay) {
        Popover.defaultHoverDelay = defaultHoverDelay;
        Popover.applyConfiguration();
    }

    private static void applyConfiguration() {
        if (UI.getCurrent() != null) {
            Popover.applyConfigurationForUI(UI.getCurrent());
        }
        if (uiInitListenerRegistered.compareAndSet(false, true)) {
            VaadinService.getCurrent().addUIInitListener((UIInitListener & Serializable)e -> Popover.applyConfigurationForUI(e.getUI()));
        }
    }

    private static void applyConfigurationForUI(UI ui) {
        ui.getElement().executeJs("((window.Vaadin ||= {}).Flow ||= {}).popover ||= {}", new Serializable[0]);
        if (defaultHideDelay != null) {
            ui.getElement().executeJs("const popover = window.Vaadin.Flow.popover;popover.defaultHideDelay = $0;popover.setDefaultHideDelay?.($0)", new Serializable[]{defaultHideDelay});
        }
        if (defaultFocusDelay != null) {
            ui.getElement().executeJs("const popover = window.Vaadin.Flow.popover;popover.defaultFocusDelay = $0;popover.setDefaultFocusDelay?.($0)", new Serializable[]{defaultFocusDelay});
        }
        if (defaultHoverDelay != null) {
            ui.getElement().executeJs("const popover = window.Vaadin.Flow.popover;popover.defaultHoverDelay = $0;popover.setDefaultHoverDelay?.($0)", new Serializable[]{defaultHoverDelay});
        }
    }

    public void setOpened(boolean opened) {
        if (opened != this.isOpened()) {
            this.getElement().setProperty("opened", opened);
        }
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public void setModal(boolean modal) {
        this.getElement().setProperty("modal", modal);
    }

    public void setModal(boolean modal, boolean backdropVisible) {
        this.setModal(modal);
        this.setBackdropVisible(backdropVisible);
    }

    public boolean isModal() {
        return this.getElement().getProperty("modal", false);
    }

    public void setBackdropVisible(boolean backdropVisible) {
        this.getElement().setProperty("withBackdrop", backdropVisible);
    }

    public boolean isBackdropVisible() {
        return this.getElement().getProperty("withBackdrop", false);
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setOverlayRole(String role) {
        Objects.requireNonNull(role, "Role cannot be null");
        this.getElement().setProperty("overlayRole", role);
    }

    public String getOverlayRole() {
        return this.getElement().getProperty("overlayRole");
    }

    public boolean isCloseOnEsc() {
        return !this.getElement().getProperty("noCloseOnEsc", false);
    }

    public void setCloseOnEsc(boolean closeOnEsc) {
        this.getElement().setProperty("noCloseOnEsc", !closeOnEsc);
    }

    public boolean isCloseOnOutsideClick() {
        return !this.getElement().getProperty("noCloseOnOutsideClick", false);
    }

    public void setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.getElement().setProperty("noCloseOnOutsideClick", !closeOnOutsideClick);
    }

    public void setPosition(PopoverPosition position) {
        this.getElement().setProperty("position", position.getPosition());
    }

    public PopoverPosition getPosition() {
        String positionString = this.getElement().getProperty("position");
        return Arrays.stream(PopoverPosition.values()).filter(p -> p.getPosition().equals(positionString)).findFirst().orElse(null);
    }

    public void setFor(String id) {
        this.getElement().setProperty("for", id);
    }

    public String getFor() {
        return this.getElement().getProperty("for");
    }

    public void setFocusDelay(int focusDelay) {
        this.getElement().setProperty("focusDelay", (double)focusDelay);
    }

    public int getFocusDelay() {
        return this.getElement().getProperty("focusDelay", 0);
    }

    public void setHoverDelay(int hoverDelay) {
        this.getElement().setProperty("hoverDelay", (double)hoverDelay);
    }

    public int getHoverDelay() {
        return this.getElement().getProperty("hoverDelay", 0);
    }

    public void setHideDelay(int hideDelay) {
        this.getElement().setProperty("hideDelay", (double)hideDelay);
    }

    public int getHideDelay() {
        return this.getElement().getProperty("hideDelay", 0);
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnClick = openOnClick;
        this.updateTrigger();
    }

    public boolean isOpenOnClick() {
        return this.openOnClick;
    }

    public void setOpenOnFocus(boolean openOnFocus) {
        this.openOnFocus = openOnFocus;
        this.updateTrigger();
    }

    public boolean isOpenOnFocus() {
        return this.openOnFocus;
    }

    public void setOpenOnHover(boolean openOnHover) {
        this.openOnHover = openOnHover;
        this.updateTrigger();
    }

    public boolean isOpenOnHover() {
        return this.openOnHover;
    }

    private void updateTrigger() {
        JsonArray trigger = Json.createArray();
        if (this.isOpenOnClick()) {
            trigger.set(trigger.length(), "click");
        }
        if (this.isOpenOnHover()) {
            trigger.set(trigger.length(), "hover");
        }
        if (this.isOpenOnFocus()) {
            trigger.set(trigger.length(), "focus");
        }
        this.getElement().setPropertyJson("trigger", (JsonValue)trigger);
    }

    public void setTarget(Component target) {
        if (target instanceof Text) {
            throw new IllegalArgumentException("Text as a target is not supported. Consider wrapping the Text inside a Div.");
        }
        if (this.target != null) {
            this.targetAttachRegistration.remove();
            this.targetDetachRegistration.remove();
        }
        this.removeFromUiIfAutoAdded();
        this.target = target;
        if (target == null) {
            this.getElement().executeJs("this.target = null", new Serializable[0]);
            return;
        }
        target.getUI().ifPresent(this::onTargetAttach);
        this.targetAttachRegistration = target.addAttachListener((ComponentEventListener & Serializable)e -> this.onTargetAttach(e.getUI()));
        this.targetDetachRegistration = target.addDetachListener((ComponentEventListener & Serializable)e -> this.removeFromUiIfAutoAdded());
    }

    private void removeFromUiIfAutoAdded() {
        if (this.autoAddedToTheUi) {
            this.autoAddedToTheUi = false;
            Optional maybeParent = this.getParent();
            if (maybeParent.isPresent() && ((Component)maybeParent.get()).getChildren().anyMatch(child -> child == this)) {
                this.getElement().removeFromParent();
            }
        }
    }

    private void onTargetAttach(UI ui) {
        if (this.target != null) {
            if (this.getElement().getNode().getParent() == null) {
                this.getElement().removeFromTree(false);
                this.getModalParentComponent().ifPresentOrElse(modalParent -> {
                    this.updateSlotAttribute((Component)modalParent);
                    if (modalParent instanceof HasComponents) {
                        ((HasComponents)modalParent).add(new Component[]{this});
                    } else {
                        modalParent.getElement().appendChild(new Element[]{this.getElement()});
                    }
                }, () -> ui.addToModalComponent((Component)this));
                this.autoAddedToTheUi = true;
            }
            this.getElement().executeJs("this.target = $0", new Serializable[]{this.target.getElement()});
        }
    }

    private Optional<Component> getModalParentComponent() {
        Optional parent = this.target.getParent();
        while (parent.isPresent()) {
            Component parentComponent = (Component)parent.get();
            if (parentComponent.getClass().isAnnotationPresent(ModalRoot.class)) {
                return parent;
            }
            parent = parentComponent.getParent();
        }
        return Optional.empty();
    }

    private void updateSlotAttribute(Component modalParent) {
        this.getElement().removeAttribute("slot");
        ModalRoot annotation = modalParent.getClass().getAnnotation(ModalRoot.class);
        String slotValue = annotation.slot();
        if (slotValue != null && !slotValue.isEmpty()) {
            this.getElement().setAttribute("slot", slotValue);
        }
    }

    public Component getTarget() {
        return this.target;
    }

    public void setWidth(String width) {
        this.getElement().setProperty("contentWidth", width);
    }

    public void setHeight(String height) {
        this.getElement().setProperty("contentHeight", height);
    }

    public void add(Collection<Component> components) {
        super.add(components);
        this.updateVirtualChildNodeIds();
    }

    public void addComponentAtIndex(int index, Component component) {
        super.addComponentAtIndex(index, component);
        this.updateVirtualChildNodeIds();
    }

    private void attachComponentRenderer() {
        this.getElement().executeJs("Vaadin.FlowComponentHost.patchVirtualContainer(this)", new Serializable[0]);
        String appId = UI.getCurrent().getInternals().getAppId();
        this.getElement().executeJs("this.renderer = (root) => Vaadin.FlowComponentHost.setChildNodes($0, this.virtualChildNodeIds, root)", new Serializable[]{appId});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.updateVirtualChildNodeIds();
    }

    private void updateVirtualChildNodeIds() {
        this.getElement().getChildren().forEach(child -> {
            if (!this.childDetachListenerMap.containsKey(child)) {
                this.childDetachListenerMap.put((Element)child, child.addDetachListener(this.childDetachListener));
            }
        });
        this.getElement().setPropertyList("virtualChildNodeIds", this.getElement().getChildren().map(element -> element.getNode().getId()).collect(Collectors.toList()));
        this.getElement().callJsFunction("requestContentUpdate", new Serializable[0]);
    }

    public void setClassName(String className) {
        this.getClassNames().clear();
        if (className != null) {
            this.addClassNames(className.split(" "));
        }
    }

    public ClassList getClassNames() {
        return new OverlayClassListProxy((HasStyle)this);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("Popover does not support adding styles to overlay");
    }

    static {
        uiInitListenerRegistered = new AtomicBoolean(false);
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<Popover> {
        private final boolean opened;

        public OpenedChangeEvent(Popover source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

