/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.dom.Element;
import java.util.List;
import java.util.Optional;

public interface HasSideNavItems
extends HasElement {
    default public void addItem(SideNavItem ... items) {
        if (!1.$assertionsDisabled && items == null) {
            throw new AssertionError();
        }
        for (SideNavItem item : items) {
            this.setupSideNavItem(item);
            this.getElement().appendChild(new Element[]{item.getElement()});
        }
    }

    default public void addItemAsFirst(SideNavItem item) {
        this.addItemAtIndex(0, item);
    }

    default public void addItemAtIndex(int index, SideNavItem item) {
        if (!1.$assertionsDisabled && item == null) {
            throw new AssertionError();
        }
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a SideNavItem with a negative index");
        }
        List<SideNavItem> items = this.getItems();
        if (index > items.size()) {
            throw new IllegalArgumentException(String.format("Cannot insert item with index %d when there are %d items", index, items.size()));
        }
        if (index == items.size()) {
            this.addItem(item);
        } else {
            this.setupSideNavItem(item);
            int insertPosition = this.getElement().indexOfChild(items.get(index).getElement());
            this.getElement().insertChild(insertPosition, new Element[]{item.getElement()});
        }
    }

    default public List<SideNavItem> getItems() {
        return this.getElement().getChildren().map(Element::getComponent).flatMap(Optional::stream).filter(component -> component instanceof SideNavItem).map(component -> (SideNavItem)component).toList();
    }

    default public void remove(SideNavItem ... items) {
        for (SideNavItem item : items) {
            Optional parent = item.getParent();
            if (!parent.isPresent() || parent.get() != this) continue;
            this.getElement().removeChild(new Element[]{item.getElement()});
        }
    }

    default public void removeAll() {
        List<Element> items = this.getItems().stream().map(Component::getElement).toList();
        this.getElement().removeChild(items);
    }

    private void setupSideNavItem(SideNavItem item) {
        if (this instanceof SideNavItem) {
            item.getElement().setAttribute("slot", "children");
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

