/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.commands;

import com.vaadin.testbench.HasDriver;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.ScreenshotComparator;
import com.vaadin.testbench.commands.TestBenchCommands;
import com.vaadin.testbench.screenshot.ImageComparison;
import com.vaadin.testbench.screenshot.ReferenceNameGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBenchCommandExecutor
implements TestBenchCommands,
HasDriver {
    private TestBenchDriverProxy driver;
    private final ImageComparison imageComparison;
    private final ReferenceNameGenerator referenceNameGenerator;
    private boolean enableWaitForVaadin = true;
    private boolean autoScrollIntoView = true;
    String WAIT_FOR_VAADIN_SCRIPT = "if (document.readyState != 'complete') {  return false;}if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.devServerIsNotLoaded) {  return false;} else if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {  var clients = window.Vaadin.Flow.clients;  for (var client in clients) {    if (clients[client].isActive()) {      return false;    }  }  return true;} else {  return true;}";
    private Runnable waitForVaadinLoopHook;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TestBenchCommandExecutor.class);
    }

    public TestBenchCommandExecutor(ImageComparison imageComparison, ReferenceNameGenerator referenceNameGenerator) {
        this.imageComparison = imageComparison;
        this.referenceNameGenerator = referenceNameGenerator;
    }

    public void setDriver(TestBenchDriverProxy driver) {
        this.driver = driver;
    }

    @Override
    public String getRemoteControlName() {
        InetAddress ia = null;
        try {
            WebDriver realDriver = this.driver.getWrappedDriver();
            if (realDriver instanceof RemoteWebDriver) {
                RemoteWebDriver rwd = (RemoteWebDriver)realDriver;
                if (rwd.getCommandExecutor() instanceof HttpCommandExecutor) {
                    ia = InetAddress.getByName(((HttpCommandExecutor)rwd.getCommandExecutor()).getAddressOfRemoteServer().getHost());
                }
            } else {
                ia = InetAddress.getLocalHost();
            }
        }
        catch (UnknownHostException e) {
            TestBenchCommandExecutor.getLogger().warn("Could not find name of remote control", (Throwable)e);
            return "unknown";
        }
        if (ia != null) {
            return String.format("%s (%s)", ia.getCanonicalHostName(), ia.getHostAddress());
        }
        return null;
    }

    public void waitForVaadin() {
        if (!this.enableWaitForVaadin) {
            return;
        }
        long timeoutTime = System.currentTimeMillis() + 40000L;
        Boolean finished = false;
        while (System.currentTimeMillis() < timeoutTime && !finished.booleanValue()) {
            if (this.waitForVaadinLoopHook != null) {
                this.waitForVaadinLoopHook.run();
            }
            if ((finished = (Boolean)((JavascriptExecutor)this.getDriver().getWrappedDriver()).executeScript(this.WAIT_FOR_VAADIN_SCRIPT, new Object[0])) != null) continue;
            TestBenchCommandExecutor.getLogger().debug("waitForVaadin returned null, this should never happen");
            finished = false;
        }
    }

    @Override
    public boolean compareScreen(String referenceId) throws IOException {
        return ScreenshotComparator.compareScreen(referenceId, this.referenceNameGenerator, this.imageComparison, (TakesScreenshot)this.driver, (HasCapabilities)this.getDriver());
    }

    @Override
    public boolean compareScreen(File reference) throws IOException {
        TestBenchDriverProxy driver = this.getDriver();
        return ScreenshotComparator.compareScreen(reference, this.imageComparison, driver, driver);
    }

    @Override
    public boolean compareScreen(BufferedImage reference, String referenceName) throws IOException {
        TestBenchDriverProxy driver = this.getDriver();
        return ScreenshotComparator.compareScreen(reference, referenceName, this.imageComparison, (TakesScreenshot)driver, (HasCapabilities)driver);
    }

    @Override
    public long timeSpentRenderingLastRequest() {
        List<Long> timingValues = this.getTimingValues(false);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(0);
    }

    @Override
    public long totalTimeSpentRendering() {
        List<Long> timingValues = this.getTimingValues(false);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(1);
    }

    @Override
    public long timeSpentServicingLastRequest() {
        List<Long> timingValues = this.getTimingValues(true);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(3);
    }

    @Override
    public long totalTimeSpentServicingRequests() {
        List<Long> timingValues = this.getTimingValues(true);
        if (timingValues == null) {
            return -1L;
        }
        return timingValues.get(2);
    }

    private List<Long> getTimingValues(boolean poll) {
        if (poll) {
            this.executeScript("if (!window.Vaadin || !window.Vaadin.Flow || !window.Vaadin.Flow.clients) {  throw 'Performance data is only available when using Vaadin Flow';}for (client in window.Vaadin.Flow.clients) {\n  if (typeof window.Vaadin.Flow.clients[client].poll === typeof Function) {\n    window.Vaadin.Flow.clients[client].poll();\n  }\n}", new Object[0]);
        }
        return (List)this.executeScript("if (!window.Vaadin || !window.Vaadin.Flow || !window.Vaadin.Flow.clients) {  throw 'Performance data is only available when using Vaadin Flow';}var pd = [0,0,0,0];\nvar pdFound = false;\nfor (client in window.Vaadin.Flow.clients) {\n  if (typeof window.Vaadin.Flow.clients[client].getProfilingData === typeof Function) {\n    var p = window.Vaadin.Flow.clients[client].getProfilingData();\n    pd[0] += p[0];\n    pd[1] += p[1];\n    pd[2] += p[2];\n    pd[3] += p[3];\n    pdFound = true;\n  }\n}\nif (pdFound) {\n  return pd;\n} else {\n  throw 'Performance data is not available in production mode';\n}", new Object[0]);
    }

    @Override
    public void disableWaitForVaadin() {
        this.enableWaitForVaadin = false;
    }

    @Override
    public void enableWaitForVaadin() {
        this.enableWaitForVaadin = true;
    }

    @Override
    public boolean isAutoScrollIntoView() {
        return this.autoScrollIntoView;
    }

    @Override
    public void setAutoScrollIntoView(boolean autoScrollIntoView) {
        this.autoScrollIntoView = autoScrollIntoView;
    }

    public Object executeScript(String script, Object ... args) {
        return this.getDriver().executeScript(script, args);
    }

    protected Object executeAsyncScript(String script, Object ... args) {
        return this.getDriver().executeAsyncScript(script, args);
    }

    @Override
    public TestBenchDriverProxy getDriver() {
        return this.driver;
    }

    @Override
    public void resizeViewPortTo(int desiredWidth, int desiredHeight) throws UnsupportedOperationException {
        try {
            this.getDriver().manage().window().setPosition(new Point(0, 0));
            int extrah = 106;
            int extraw = 0;
            this.getDriver().manage().window().setSize(new Dimension(desiredWidth + extraw, desiredHeight + extrah));
            int actualWidth = this.detectViewportWidth();
            int actualHeight = this.detectViewportHeight();
            int diffW = desiredWidth - actualWidth;
            int diffH = desiredHeight - actualHeight;
            if (diffH != 0 || diffW != 0) {
                this.driver.manage().window().setSize(new Dimension(desiredWidth + extraw + diffW, desiredHeight + extrah + diffH));
            }
            actualWidth = this.detectViewportWidth();
            actualHeight = this.detectViewportHeight();
            if (desiredWidth != actualWidth || desiredHeight != actualHeight) {
                throw new Exception("Viewport size couldn't be set to the desired '" + desiredWidth + "," + desiredHeight + "' got '" + actualWidth + "," + actualHeight + "'.");
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Viewport couldn't be adjusted.", e);
        }
    }

    private int detectViewportHeight() {
        int height = ((Number)this.executeScript("function f() { if(typeof window.innerHeight != 'undefined') { return window.innerHeight; } if(document.documentElement && document.documentElement.offsetHeight) { return document.documentElement.offsetHeight; } w = document.body.clientHeight; if(navigator.userAgent.indexOf('Trident/5') != -1 && document.documentMode < 9) { w += 4; } return w;} return f();", new Object[0])).intValue();
        return height;
    }

    private int detectViewportWidth() {
        int width = ((Number)this.executeScript("function f() { if(typeof window.innerWidth != 'undefined') { return window.innerWidth; } if(document.documentElement && document.documentElement.offsetWidth) { return document.documentElement.offsetWidth; } w = document.body.clientWidth; if(navigator.userAgent.indexOf('Trident/5') != -1 && document.documentMode < 9) { w += 4; } return w;} return f();", new Object[0])).intValue();
        return width;
    }

    public void focusElement(TestBenchElement testBenchElement) {
        Object ret = this.executeScript("try { arguments[0].focus() } catch(e) {}; return null;", testBenchElement);
        assert (ret == null);
    }

    public ReferenceNameGenerator getReferenceNameGenerator() {
        return this.referenceNameGenerator;
    }

    public ImageComparison getImageComparison() {
        return this.imageComparison;
    }
}

