/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html.testbench;

import com.vaadin.flow.component.html.RangeInput;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.math.BigDecimal;

@Tests(value={RangeInput.class})
public class RangeInputTester
extends ComponentTester<RangeInput> {
    public RangeInputTester(RangeInput component) {
        super(component);
    }

    public Double getValue() {
        this.ensureVisible();
        return null;
    }

    public void setValue(Double value) {
        this.ensureComponentIsUsable();
        if (value == null) {
            throw new IllegalArgumentException("RangeInput doesn't allow null values");
        }
        if (value < ((RangeInput)this.getComponent()).getMin()) {
            throw new IllegalArgumentException("Value cannot be less than min. Got " + value + " but min is " + ((RangeInput)this.getComponent()).getMin());
        }
        if (value > ((RangeInput)this.getComponent()).getMax()) {
            throw new IllegalArgumentException("Value cannot be greater than min. Got " + value + " but max is " + ((RangeInput)this.getComponent()).getMax());
        }
        if (((RangeInput)this.getComponent()).getStep() != null && Math.abs(value - (Double)((RangeInput)this.getComponent()).getValue()) % ((RangeInput)this.getComponent()).getStep() != 0.0) {
            throw new IllegalArgumentException("Value cannot does not match step factory. Got " + value + " but current value is " + ((RangeInput)this.getComponent()).getValue() + " and step is " + ((RangeInput)this.getComponent()).getStep());
        }
        this.setValueAsUser(value);
    }

    public void increase() {
        this.increase(1);
    }

    public void increase(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("The 'times' parameter must be a non-negative integer.");
        }
        this.ensureComponentIsUsable();
        if (((RangeInput)this.getComponent()).getStep() == null) {
            throw new IllegalStateException("Cannot increase value if component step is not defined");
        }
        this.setValue((Double)((RangeInput)this.getComponent()).getValue() + ((RangeInput)this.getComponent()).getStep() * (double)times);
    }

    public void decrease() {
        this.decrease(1);
    }

    public void decrease(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("The 'times' parameter must be a non-negative integer.");
        }
        this.ensureComponentIsUsable();
        if (((RangeInput)this.getComponent()).getStep() == null) {
            throw new IllegalStateException("Cannot decrease value if component step is not defined");
        }
        double newValue = BigDecimal.valueOf((Double)((RangeInput)this.getComponent()).getValue()).subtract(BigDecimal.valueOf(((RangeInput)this.getComponent()).getStep() * (double)times)).doubleValue();
        this.setValue(newValue);
    }
}

