/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datetimepicker;

import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Tests(value={DateTimePicker.class})
public class DateTimePickerTester<T extends DateTimePicker>
extends ComponentTester<T> {
    public DateTimePickerTester(T component) {
        super(component);
    }

    public void setValue(LocalDateTime dateTime) {
        this.ensureComponentIsUsable();
        try {
            if (this.isInvalid(dateTime)) {
                throw new IllegalArgumentException("Given date is not a valid value");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setValueAsUser(dateTime);
    }

    private boolean isInvalid(LocalDateTime date) throws InvocationTargetException, IllegalAccessException {
        try {
            Method isInvalid = this.getMethod("isInvalid", LocalDate.class);
            return (Boolean)isInvalid.invoke(this.getComponent(), date);
        }
        catch (RuntimeException ex) {
            if (!(ex.getCause() instanceof NoSuchMethodException)) {
                throw ex;
            }
            return ((DateTimePicker)this.getComponent()).getDefaultValidator().apply((Object)date, null).isError();
        }
    }
}

