/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.component.timepicker.TimePickerVariant;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@Tag(value="vaadin-time-picker")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.6"), @NpmPackage(value="@vaadin/time-picker", version="24.9.6")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/time-picker/src/vaadin-time-picker.js"), @JsModule(value="./vaadin-time-picker/timepickerConnector.js")})
public class TimePicker
extends AbstractSinglePropertyField<TimePicker, LocalTime>
implements Focusable<TimePicker>,
HasAllowedCharPattern,
HasAriaLabel,
HasAutoOpen,
HasClearButton,
HasClientValidation,
InputField<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>, LocalTime>,
HasPrefix,
HasOverlayClassName,
HasThemeVariant<TimePickerVariant>,
HasValidationProperties,
HasValidator<LocalTime>,
HasPlaceholder {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private TimePickerI18n i18n;
    private Locale locale;
    private LocalTime max;
    private LocalTime min;
    private StateTree.ExecutionRegistration pendingLocaleUpdate;
    private String unparsableValue;
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<LocalTime>> validationStatusChangeListeners = new CopyOnWriteArrayList();
    private Validator<LocalTime> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (this.isInputUnparsable()) {
            return ValidationResult.error((String)this.getI18nErrorMessage(TimePickerI18n::getBadInputErrorMessage));
        }
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(TimePickerI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)((LocalTime)this.getEmptyValue()))).isError()) {
            return requiredResult;
        }
        ValidationResult maxResult = ValidationUtil.validateMaxConstraint((String)this.getI18nErrorMessage(TimePickerI18n::getMaxErrorMessage), (Comparable)value, (Comparable)this.max);
        if (maxResult.isError()) {
            return maxResult;
        }
        ValidationResult minResult = ValidationUtil.validateMinConstraint((String)this.getI18nErrorMessage(TimePickerI18n::getMinErrorMessage), (Comparable)value, (Comparable)this.min);
        if (minResult.isError()) {
            return minResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<TimePicker, LocalTime> validationController = new ValidationController((Component)this);

    public TimePicker() {
        this((LocalTime)null, true);
    }

    public TimePicker(LocalTime time) {
        this(time, false);
    }

    private TimePicker(LocalTime time, boolean isInitialValueOptional) {
        super("value", null, String.class, PARSER, FORMATTER);
        if (this.getElement().getProperty("value") == null || !isInitialValueOptional) {
            this.setPresentationValue(time);
        }
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)event -> this.setModelValue((LocalTime)this.getEmptyValue(), true));
        this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> this.fireEvent(new InvalidChangeEvent(this, event.isUserOriginated())));
    }

    public TimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public TimePicker(String label, LocalTime time) {
        this(time);
        this.setLabel(label);
    }

    public TimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TimePicker(LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this(time);
        this.addValueChangeListener(listener);
    }

    public TimePicker(String label, LocalTime time, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this(time);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public void setValue(LocalTime value) {
        LocalTime oldValue = (LocalTime)this.getValue();
        if (oldValue == null && value == null && this.isInputUnparsable()) {
            this.setModelValue((LocalTime)this.getEmptyValue(), false);
            return;
        }
        if (value != null) {
            value = value.truncatedTo(ChronoUnit.MILLIS);
        }
        super.setValue((Object)value);
    }

    protected void setModelValue(LocalTime newModelValue, boolean fromClient) {
        boolean isModelValueRemainedEmpty;
        LocalTime oldModelValue = (LocalTime)this.getValue();
        String oldUnparsableValue = this.unparsableValue;
        this.unparsableValue = fromClient && newModelValue == null && !this.getInputElementValue().isEmpty() ? this.getInputElementValue() : null;
        boolean bl = isModelValueRemainedEmpty = newModelValue == null && oldModelValue == null;
        if (fromClient && isModelValueRemainedEmpty) {
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        if (!fromClient && isModelValueRemainedEmpty && oldUnparsableValue != null) {
            this.setInputElementValue("");
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        super.setModelValue((Object)newModelValue, fromClient);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public Validator<LocalTime> getDefaultValidator() {
        return this.defaultValidator;
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalTime> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    private void fireValidationStatusChangeEvent() {
        ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
        this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<LocalTime>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
    }

    @Deprecated(since="24.8")
    protected boolean isInputValuePresent() {
        return !this.getInputElementValue().isEmpty();
    }

    protected final boolean isInputUnparsable() {
        return this.unparsableValue != null;
    }

    @Synchronize(property="_inputElementValue", value={"change", "unparsable-change"})
    private String getInputElementValue() {
        return this.getElement().getProperty("_inputElementValue", "");
    }

    private void setInputElementValue(String value) {
        this.getElement().setProperty("_inputElementValue", value);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public void setRequired(boolean required) {
        this.setRequiredIndicatorVisible(required);
    }

    public boolean isRequired() {
        return this.isRequiredIndicatorVisible();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        this.getElement().setProperty("step", StepsUtil.convertDurationToStepsValue(step));
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        double step = this.getElement().getProperty("step", 0.0);
        return StepsUtil.convertStepsValueToDuration(step);
    }

    public Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent> listener) {
        return this.addListener(InvalidChangeEvent.class, listener);
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)((LocalTime)this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestLocaleUpdate();
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.timepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        if (locale.getLanguage().isEmpty()) {
            throw new UnsupportedOperationException("Given Locale " + locale.getDisplayName() + " is not supported by time picker because it is missing the language information.");
        }
        this.locale = locale;
        this.requestLocaleUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void requestLocaleUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingLocaleUpdate != null) {
                this.pendingLocaleUpdate.remove();
            }
            this.pendingLocaleUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingLocaleUpdate = null;
                this.executeLocaleUpdate();
            });
        });
    }

    private void executeLocaleUpdate() {
        Locale appliedLocale = this.getLocale();
        StringBuilder bcp47LanguageTag = new StringBuilder(appliedLocale.getLanguage());
        if (!appliedLocale.getCountry().isEmpty()) {
            bcp47LanguageTag.append("-").append(appliedLocale.getCountry());
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callJsFunction("$connector.setLocale", new Serializable[]{bcp47LanguageTag.toString()}));
    }

    public void setMin(LocalTime min) {
        this.min = min;
        String minString = TimePicker.format(min);
        this.getElement().setProperty("min", minString == null ? "" : minString);
    }

    public LocalTime getMin() {
        return this.min;
    }

    public void setMax(LocalTime max) {
        this.max = max;
        String maxString = TimePicker.format(max);
        this.getElement().setProperty("max", maxString == null ? "" : maxString);
    }

    public LocalTime getMax() {
        return this.max;
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public static Stream<Locale> getSupportedAvailableLocales() {
        return Stream.of(Locale.getAvailableLocales()).filter(locale -> !locale.getLanguage().isEmpty());
    }

    private static String format(LocalTime time) {
        return time != null ? time.toString() : null;
    }

    public TimePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(TimePickerI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<TimePickerI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class InvalidChangeEvent
    extends ComponentEvent<TimePicker> {
        private final boolean invalid;

        public InvalidChangeEvent(TimePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.invalid = source.isInvalid();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }

    public static class TimePickerI18n
    implements Serializable {
        private String badInputErrorMessage;
        private String requiredErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;

        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public TimePickerI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public TimePickerI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public TimePickerI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public TimePickerI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }
    }
}

