/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption.handler;

import de.tototec.cmdoption.handler.CmdOptionHandler;
import de.tototec.cmdoption.handler.CmdOptionHandlerException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class CharArrayHandler
implements CmdOptionHandler {
    public boolean canHandle(AccessibleObject element, int argCount) {
        Method method;
        Class<?> type = null;
        if (element instanceof Field && argCount == 1) {
            type = ((Field)element).getType();
        } else if (element instanceof Method && argCount == 1 && (method = (Method)element).getParameterTypes().length == 1) {
            type = method.getParameterTypes()[0];
        }
        if (type != null && type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return Character.TYPE.equals(componentType) || Character.class.equals(componentType);
        }
        return false;
    }

    public void applyParams(Object config, AccessibleObject element, String[] args, String optionName) throws CmdOptionHandlerException {
        try {
            Field field = (Field)element;
            field.set(config, args[0]);
        }
        catch (Exception e) {
            throw new CmdOptionHandlerException("Could not apply parameters: " + Arrays.toString(args) + " to field " + element, e);
        }
    }
}

