/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public final class BinaryContent {
    private final byte[][] data;

    public static BinaryContent load(Class<?> templateClass, String resource, int ... lengths) {
        int total = lengths.length;
        byte[][] data = new byte[total][];
        try (InputStream is = templateClass.getResourceAsStream(resource);){
            for (int i = 0; i < total; ++i) {
                data[i] = BinaryContent.read(is, lengths[i]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new BinaryContent(data);
    }

    private static byte[] read(InputStream is, int length) throws IOException {
        int read;
        byte[] result = new byte[length];
        for (int offset = 0; offset < length; offset += read) {
            read = is.read(result, offset, length - offset);
            if (read != -1) continue;
            return result;
        }
        return result;
    }

    public BinaryContent(byte[][] data) {
        this.data = data;
    }

    public byte[] get(int index) {
        return this.data[index];
    }
}

