/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.button;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.dialog.ConfirmationDialog;

public class ConfirmButton
extends VButton {
    private Command action;
    private String confirmationPrompt = "Are you sure?";
    private String confirmationDescription;
    private String okText;
    private String cancelText;

    public ConfirmButton(String buttonCaption, Command action) {
        this.action = action;
        this.setText(buttonCaption);
        super.addClickListener((ComponentEventListener & Serializable)e -> this.prompt());
    }

    public ConfirmButton(Icon icon, Command action) {
        this.action = action;
        this.setIcon((Component)icon);
        super.addClickListener((ComponentEventListener & Serializable)e -> this.prompt());
    }

    public Registration addClickListener(ComponentEventListener<ClickEvent<Button>> listener) {
        this.action = (Command & Serializable)() -> listener.onComponentEvent(null);
        return (Registration & Serializable)() -> {
            this.action = (Command & Serializable)() -> {};
        };
    }

    @Override
    public Registration addClickListener(VButton.BasicClickListener clickListener) {
        this.action = (Command & Serializable)() -> clickListener.onClick();
        return (Registration & Serializable)() -> {
            this.action = (Command & Serializable)() -> {};
        };
    }

    public ConfirmButton withConfirmHandler(Command handler) {
        this.action = handler;
        return this;
    }

    protected ConfirmationDialog prompt() {
        ConfirmationDialog dialog = new ConfirmationDialog(this.getConfirmationPrompt(), this.action);
        if (this.confirmationDescription != null) {
            dialog.setConfirmationDescription(this.getConfirmationDescription());
        }
        if (this.okText != null) {
            dialog.setOkText(this.okText);
        }
        if (this.cancelText != null) {
            dialog.setCancelText(this.cancelText);
        }
        dialog.open();
        return dialog;
    }

    public String getConfirmationPrompt() {
        return this.confirmationPrompt;
    }

    public void setConfirmationPrompt(String confirmationPrompt) {
        this.confirmationPrompt = confirmationPrompt;
    }

    public ConfirmButton withConfirmationPrompt(String confirmationPrompt) {
        this.setConfirmationPrompt(confirmationPrompt);
        return this;
    }

    public ConfirmButton withConfirmationDescription(String description) {
        this.setConfirmationDescription(description);
        return this;
    }

    public void setConfirmationDescription(String description) {
        this.confirmationDescription = description;
    }

    public String getConfirmationDescription() {
        return this.confirmationDescription;
    }

    public ConfirmButton withOKText(String okText) {
        this.setOkText(okText);
        return this;
    }

    public void setOkText(String okText) {
        this.okText = okText;
    }

    public String getOkText() {
        return this.okText;
    }

    public ConfirmButton withCancelText(String cancelText) {
        this.setCancelText(cancelText);
        return this;
    }

    public String getCancelText() {
        return this.cancelText;
    }

    public void setCancelText(String cancelText) {
        this.cancelText = cancelText;
    }
}

