/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.datepicker.VDatePicker;
import org.vaadin.firitin.components.datetimepicker.VDateTimePicker;
import org.vaadin.firitin.components.textfield.VIntegerField;
import org.vaadin.firitin.components.textfield.VNumberField;
import org.vaadin.firitin.components.textfield.VTextField;
import org.vaadin.firitin.fields.EnumSelect;
import org.vaadin.firitin.fields.internalhtmltable.Table;
import org.vaadin.firitin.fields.internalhtmltable.TableCell;
import org.vaadin.firitin.fields.internalhtmltable.TableDataCell;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.form.AbstractForm;
import org.vaadin.firitin.form.FormBinder;

public class ElementCollectionField<T>
extends CustomField<List<T>> {
    private static final ObjectMapper jack = new ObjectMapper();
    private final Class<T> clazz;
    private final Class<?> editorClass;
    private List<T> value;
    protected Table table;
    private T newItem;
    private FormBinder newItemForm;
    private SerializableSupplier<Object> editorInstantiator;
    private BasicBeanDescription bbd;

    public ElementCollectionField(Class<T> clazz, Class<?> editorClass) {
        this.clazz = clazz;
        this.editorClass = editorClass;
        this.table = new Table();
        this.add(new Component[]{this.table});
    }

    public ElementCollectionField(Class<T> clazz) {
        this.clazz = clazz;
        this.editorClass = null;
        this.table = new Table();
        this.add(new Component[]{this.table});
    }

    public ElementCollectionField<T> withEditorInstantiator(SerializableSupplier<Object> editorInstantiator) {
        this.editorInstantiator = editorInstantiator;
        return this;
    }

    protected void configureColumneHeaders() {
        List<String> fieldNames;
        if (this.editorClass != null) {
            fieldNames = Arrays.stream(this.editorClass.getDeclaredFields()).map(f -> f.getName()).toList();
        } else {
            JavaType javaType = jack.getTypeFactory().constructType(this.clazz);
            this.bbd = (BasicBeanDescription)jack.getSerializationConfig().introspect(javaType);
            fieldNames = this.bbd.findProperties().stream().map(p -> p.getName()).toList();
        }
        TableRow tr = new TableRow();
        for (String fieldName : fieldNames) {
            tr.addHeaderCells(this.getHeaderForField(fieldName));
        }
        this.table.addRows(tr);
    }

    protected String getHeaderForField(String fieldName) {
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)fieldName), (String)" "));
    }

    protected void addDeleteButtonColumn(TableRow row, T item) {
        TableDataCell cell = row.addDataCell();
        cell.add(new Component[]{new VButton(VaadinIcon.TRASH.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.value.remove(item);
            row.getParent().ifPresent(p -> ((Table)p).removeRows(row));
            this.fireValueChange();
        })});
    }

    private void fireValueChange() {
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true));
    }

    private void addRowForNewItem() {
        if (!this.clazz.isRecord()) {
            this.newItem = this.instantiateNewItem();
        }
        this.newItemForm = this.addNewRow(this.newItem);
        this.getLastCell().setVisible(false);
    }

    private TableCell getLastCell() {
        TableRow lastRow = (TableRow)((Object)this.table.getRows().get(this.table.getRows().size() - 1));
        return lastRow.getCells().get(lastRow.getCells().size() - 1);
    }

    private FormBinder<T> addNewRow(T item) {
        TableRow tr;
        FormBinder<T> binder;
        Object row = this.instantiateRowObject();
        if (row != null) {
            binder = new FormBinder<T>(this.clazz, row);
        } else {
            Map<String, HasValue> propertyEditors = this.generateEditors();
            binder = new FormBinder<T>(this.clazz, propertyEditors);
        }
        if (row instanceof AbstractForm) {
            AbstractForm form = (AbstractForm)((Object)row);
            ((AbstractForm)((Object)row)).setEntity(item);
            tr = (TableRow)((Object)form.getContent().getChildren().findFirst().get());
        } else {
            List<String> bindings = binder.getBoundProperties();
            Component[] components = new Component[bindings.size()];
            for (int i = 0; i < bindings.size(); ++i) {
                String property = bindings.get(i);
                HasValue editor = binder.getEditor(property);
                components[i] = (Component)editor;
            }
            tr = new TableRow(components);
        }
        if (item != null) {
            binder.setValue(item);
        }
        this.addDeleteButtonColumn(tr, item);
        binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (binder == this.newItemForm) {
                if (e.isFromClient() && this.newItemForm.isValid()) {
                    if (this.newItem != null) {
                        this.value.add(this.newItem);
                    } else {
                        this.value.add(binder.getValue());
                    }
                    this.getLastCell().setVisible(true);
                    this.addRowForNewItem();
                    this.fireValueChange();
                }
            } else {
                if (this.clazz.isRecord()) {
                    List rows = this.table.getRows();
                    int index = rows.indexOf((Object)tr) - 1;
                    this.value.set(index, binder.getValue());
                }
                this.fireValueChange();
            }
        });
        this.table.addRows(tr);
        return binder;
    }

    private Map<String, HasValue> generateEditors() {
        HashMap<String, HasValue> editors = new HashMap<String, HasValue>();
        List properties = this.bbd.findProperties();
        for (BeanPropertyDefinition property : properties) {
            Class type = property.getRawPrimaryType();
            FluentComponent<VTextField> hv = null;
            if (String.class == type) {
                hv = new VTextField();
            } else if (Integer.class == type) {
                hv = new VIntegerField();
            } else if (Double.class == type) {
                hv = new VNumberField();
            } else if (LocalDate.class == type) {
                hv = new VDatePicker();
            } else if (LocalDateTime.class == type) {
                hv = new VDateTimePicker();
            } else if (Enum.class.isAssignableFrom(type)) {
                hv = new EnumSelect(type);
            } else {
                throw new UnsupportedOperationException("No field generated for type " + type.getName());
            }
            editors.put(property.getName(), (HasValue)hv);
        }
        return editors;
    }

    protected T instantiateNewItem() {
        try {
            return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object instantiateRowObject() {
        try {
            if (this.editorInstantiator != null) {
                return this.editorInstantiator.get();
            }
            if (this.editorClass != null) {
                return this.editorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<T> generateModelValue() {
        return this.value;
    }

    protected void setPresentationValue(List<T> ts) {
        this.value = ts;
        this.table.removeAllRows();
        this.configureColumneHeaders();
        this.value.forEach(this::addNewRow);
        this.addRowForNewItem();
    }
}

