/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import jakarta.validation.Configuration;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.components.button.DefaultButton;
import org.vaadin.firitin.components.button.DeleteButton;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.fields.ElementCollectionField;
import org.vaadin.firitin.form.FormBinder;
import org.vaadin.firitin.rad.AutoFormContext;
import org.vaadin.firitin.rad.PrettyPrinter;
import org.vaadin.firitin.rad.PropertyContext;
import org.vaadin.firitin.rad.PropertyContextImpl;
import org.vaadin.firitin.rad.PropertyHeaderPrinter;
import org.vaadin.firitin.rad.PropertyPrinter;
import org.vaadin.firitin.rad.ValueContext;

public class AutoForm<T>
extends Composite<Div>
implements ValueContext {
    public static final int SHORT_STRING_THRESHOLD = 50;
    private final FormBinder<T> formBinder;
    private final AutoFormContext autoFormContext;
    private final BasicBeanDescription beanDescription;
    private T value;
    private List<PropertyHeaderPrinter> headerPrinters = new ArrayList<PropertyHeaderPrinter>();
    private Validator validator;
    private Class<?>[] validationGroups;
    private boolean hasChanges;
    private SerializableConsumer<T> saveHandler;
    private SerializableConsumer<T> deleteHandler;
    private SerializableConsumer<T> resetHandler;
    private Dialog dialog;
    private Button saveButton = new DefaultButton("Save", (ComponentEventListener & Serializable)e -> {
        this.saveHandler.accept(this.getValue());
        if (this.dialog != null) {
            this.dialog.close();
        }
        this.hasChanges = false;
        if (this.isAttached()) {
            this.adjustSaveButtonState();
        }
    }){
        {
            this.setEnabled(false);
        }
    };
    private Button deleteButton = new DeleteButton((Command & Serializable)() -> {
        this.deleteHandler.accept(this.getValue());
        if (this.dialog != null) {
            this.dialog.close();
        }
    });
    private Button resetButton = new VButton("Reset", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> {
        this.resetHandler.accept(this.getValue());
        if (this.dialog != null) {
            this.dialog.close();
        }
    });

    AutoForm(AutoFormContext autoFormContext, BasicBeanDescription beanDescription, T value) {
        this.autoFormContext = autoFormContext;
        this.beanDescription = beanDescription;
        this.formBinder = new FormBinder(beanDescription);
        this.value = value;
        this.formBinder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.hasChanges = true;
                this.doBeanValidation();
                this.resetButton.setEnabled(true);
                this.adjustSaveButtonState();
            }
        });
    }

    private static boolean isLongString(Object object) {
        return object != null && object.toString().length() > 50;
    }

    static String toShortString(Object object) {
        String toString = object == null ? "" : object.toString();
        return AutoForm.toShortString(toString);
    }

    static String toShortString(String toString) {
        if (toString == null) {
            return "";
        }
        if (((String)toString).length() > 50) {
            toString = ((String)toString).substring(0, 50) + "...";
        }
        return toString;
    }

    static String deCamelCased(String propertyName) {
        String deCamelCased = propertyName.replaceAll("([a-z])([A-Z]+)", "$1 $2");
        deCamelCased = StringUtils.capitalize((String)deCamelCased);
        return deCamelCased;
    }

    private void buildTable() {
        FormLayout formLayout = new FormLayout();
        this.beanDescription.findProperties().forEach(p -> {
            if (this.autoFormContext.getHiddenProperties().contains(p.getName())) {
                return;
            }
            new PropertyContextImpl(this, (BeanPropertyDefinition)p);
            PropertyContext propertyContext = this.getPropertyContext((BeanPropertyDefinition)p);
            Object value = null;
            for (PropertyPrinter propertyPrinter : this.autoFormContext.getPropertyPrinters()) {
                Object propertyHeader;
                value = propertyPrinter.printValue(propertyContext);
                if (value == null) continue;
                if (HasValue.class.isAssignableFrom(value.getClass())) {
                    this.formBinder.bindProperty((BeanPropertyDefinition)p, (HasValue)value);
                }
                if (this.autoFormContext.isAnnotateTypes()) {
                    if (HasHelper.class.isAssignableFrom(value.getClass())) {
                        ((HasHelper)value).setHelperText(p.getPrimaryType().getRawClass().toString());
                    } else {
                        HasElement element = (HasElement)value;
                        element.getElement().setAttribute("title", p.getPrimaryType().getRawClass().toString());
                    }
                }
                if ((propertyHeader = propertyPrinter.getPropertyHeader(propertyContext)) == null) {
                    propertyHeader = this.headerPrinters.stream().map(headerPrinter -> headerPrinter.printHeader(propertyContext)).filter(h -> h != null).findFirst().orElse(PropertyHeaderPrinter.defaultHeader(propertyContext));
                }
                if (propertyHeader instanceof Component) {
                    Component c = (Component)propertyHeader;
                    throw new RuntimeException("WTF!?");
                }
                if (value == null || !(value instanceof HasLabel)) break;
                HasLabel hl = (HasLabel)value;
                hl.setLabel(propertyHeader.toString());
                break;
            }
            if (value != null) {
                if (value instanceof Component) {
                    Component c = (Component)value;
                    formLayout.add(new Component[]{c});
                    if (this.requireFullWidthForFormLayout(c)) {
                        formLayout.setColspan(c, 2);
                    }
                } else {
                    formLayout.add(value.toString());
                }
            } else {
                throw new RuntimeException("No printer found for " + p.getName());
            }
        });
        ((Div)this.getContent()).add(new Component[]{formLayout});
        if (this.value != null) {
            this.formBinder.setValue(this.value);
        }
    }

    protected boolean requireFullWidthForFormLayout(Component c) {
        if (c instanceof ElementCollectionField) {
            return true;
        }
        return c instanceof FormLayout || c.getClassNames().contains((Object)"full-width");
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ((Div)this.getContent()).removeAll();
        this.buildTable();
        Div display = new Div();
        display.setClassName("bean-validation-display");
        ((Div)this.getContent()).add(new Component[]{display});
        this.formBinder.setClassLevelViolationDisplay((HasComponents)display);
    }

    public AutoForm withPropertyHeaderPrinter(PropertyHeaderPrinter printer) {
        this.headerPrinters.add(0, printer);
        return this;
    }

    public Component getFormBody() {
        return this;
    }

    public T getValue() {
        return this.formBinder.getValue();
    }

    public FormBinder<T> getBinder() {
        return this.formBinder;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public ValueContext parent() {
        return null;
    }

    @Override
    public BasicBeanDescription beanDescription() {
        return this.beanDescription;
    }

    @Override
    public Locale getLocale() {
        return ((UI)this.getFormBody().getUI().get()).getLocale();
    }

    @Override
    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    @Override
    public PropertyContext getPropertyContext(BeanPropertyDefinition property) {
        return new PropertyContextImpl(this, property);
    }

    @Override
    public int getLevel() {
        return 0;
    }

    public void setSaveHandler(SerializableConsumer<T> saveHandler) {
        this.saveHandler = saveHandler;
    }

    public void setDeleteHandler(SerializableConsumer<T> deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public void setResetHandler(SerializableConsumer<T> resetHandler) {
        this.resetHandler = resetHandler;
    }

    public Component getActions() {
        if (this.resetHandler == null) {
            this.resetButton.setVisible(false);
        }
        if (this.deleteHandler == null) {
            this.deleteButton.setVisible(false);
        }
        if (this.saveHandler == null) {
            this.saveButton.setVisible(false);
        }
        return new HorizontalLayout(new Component[]{this.saveButton, this.deleteButton, this.resetButton});
    }

    @Deprecated(forRemoval=true)
    public AutoForm<T> withBeanValidation() {
        return this;
    }

    protected void adjustSaveButtonState() {
        if (this.value != null) {
            boolean valid = this.formBinder.isValid();
            this.saveButton.setEnabled(this.hasChanges && valid);
        }
    }

    protected void doBeanValidation() {
        if (this.autoFormContext.isDefaultBeanValidation()) {
            try {
                T object = this.getBinder().getValue();
                Class[] groups = this.getValidationGroups();
                Set constraintViolations = groups != null ? this.getValidator().validate(object, groups) : this.getValidator().validate(object, new Class[0]);
                constraintViolations.removeIf(v -> {
                    try {
                        Path propertyPath = v.getPropertyPath();
                        String propertyName = propertyPath.toString();
                        List<String> boundProperties = this.getBinder().getBoundProperties();
                        if (!boundProperties.contains(propertyName)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(AutoForm.class.getName()).log(Level.FINE, "Ignoring constraint violation", e);
                    }
                    return false;
                });
                this.formBinder.setConstraintViolations(constraintViolations);
            }
            catch (Throwable e) {
                new RuntimeException(e);
            }
        }
    }

    protected Validator getValidator() {
        if (this.validator == null) {
            final Locale locale = this.getLocale();
            Configuration configuration = Validation.byDefaultProvider().configure();
            final MessageInterpolator defaultMessageInterpolator = configuration.getDefaultMessageInterpolator();
            ValidatorFactory factory = configuration.messageInterpolator(new MessageInterpolator(){

                public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
                    return defaultMessageInterpolator.interpolate(messageTemplate, context, locale);
                }

                public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale2) {
                    return defaultMessageInterpolator.interpolate(messageTemplate, context, locale2);
                }
            }).buildValidatorFactory();
            this.validator = factory.getValidator();
        }
        return this.validator;
    }

    public Class<?>[] getValidationGroups() {
        return this.validationGroups;
    }

    public void setValidationGroups(Class<?> ... groups) {
        this.validationGroups = groups;
    }

    public Dialog openInDialog() {
        this.dialog = new Dialog();
        this.dialog.setHeaderTitle("Edit " + this.beanDescription.getBeanClass().getSimpleName());
        this.dialog.add(new Component[]{this});
        this.dialog.getFooter().add(new Component[]{this.getActions()});
        this.dialog.open();
        return this.dialog;
    }

    AutoFormContext getAutoFormContext() {
        return this.autoFormContext;
    }
}

