/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.decorator;

import io.dekorate.kubernetes.config.NodeSelector;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.knative.serving.v1.RevisionSpecFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Objects;

public class AddNodeSelectorToRevisionDecorator
extends NamedResourceDecorator<RevisionSpecFluent<?>> {
    private final NodeSelector nodeSelector;

    public AddNodeSelectorToRevisionDecorator(NodeSelector nodeSelector) {
        this(ANY, nodeSelector);
    }

    public AddNodeSelectorToRevisionDecorator(String deploymentName, NodeSelector nodeSelector) {
        super(deploymentName);
        this.nodeSelector = nodeSelector;
    }

    public void andThenVisit(RevisionSpecFluent<?> revisionSpec, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.nodeSelector.getKey()) && Strings.isNotNullOrEmpty((String)this.nodeSelector.getValue())) {
            HashMap<String, String> existing = revisionSpec.getNodeSelector();
            if (existing == null) {
                existing = new HashMap<String, String>();
            } else {
                existing.clear();
            }
            existing.put(this.nodeSelector.getKey(), this.nodeSelector.getValue());
            revisionSpec.withNodeSelector(existing);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddNodeSelectorToRevisionDecorator that = (AddNodeSelectorToRevisionDecorator)((Object)o);
        return Objects.equals(this.nodeSelector, that.nodeSelector);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector);
    }
}

