/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AnnotationBuilder;
import io.dekorate.kubernetes.config.AnnotationFluent;
import io.dekorate.kubernetes.config.ApplicationConfigurationFluent;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeBuilder;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeFluent;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureDiskVolumeBuilder;
import io.dekorate.kubernetes.config.AzureDiskVolumeFluent;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.AzureFileVolumeBuilder;
import io.dekorate.kubernetes.config.AzureFileVolumeFluent;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.ConfigMapVolumeFluent;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.config.CronJobBuilder;
import io.dekorate.kubernetes.config.CronJobFluent;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.EmptyDirVolumeBuilder;
import io.dekorate.kubernetes.config.EmptyDirVolumeFluent;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.GitRepoVolumeBuilder;
import io.dekorate.kubernetes.config.GitRepoVolumeFluent;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.HostAliasBuilder;
import io.dekorate.kubernetes.config.HostAliasFluent;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.JobBuilder;
import io.dekorate.kubernetes.config.JobFluent;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.LabelFluent;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountBuilder;
import io.dekorate.kubernetes.config.MountFluent;
import io.dekorate.kubernetes.config.NodeSelector;
import io.dekorate.kubernetes.config.NodeSelectorBuilder;
import io.dekorate.kubernetes.config.NodeSelectorFluent;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeFluent;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.PortFluent;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.config.ProbeFluent;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.ResourceRequirementsBuilder;
import io.dekorate.kubernetes.config.ResourceRequirementsFluent;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.RollingUpdateBuilder;
import io.dekorate.kubernetes.config.RollingUpdateFluent;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.config.SecretVolumeFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BaseConfigFluent<A extends BaseConfigFluent<A>>
extends ApplicationConfigurationFluent<A> {
    private String deploymentKind;
    private ArrayList<LabelBuilder> labels = new ArrayList();
    private ArrayList<AnnotationBuilder> annotations = new ArrayList();
    private ArrayList<EnvBuilder> envVars = new ArrayList();
    private String workingDir;
    private List<String> command = new ArrayList<String>();
    private List<String> arguments = new ArrayList<String>();
    private String serviceAccount;
    private ArrayList<PortBuilder> ports = new ArrayList();
    private ServiceType serviceType;
    private ArrayList<PersistentVolumeClaimVolumeBuilder> pvcVolumes = new ArrayList();
    private ArrayList<SecretVolumeBuilder> secretVolumes = new ArrayList();
    private ArrayList<ConfigMapVolumeBuilder> configMapVolumes = new ArrayList();
    private ArrayList<EmptyDirVolumeBuilder> emptyDirVolumes = new ArrayList();
    private ArrayList<GitRepoVolumeBuilder> gitRepoVolumes = new ArrayList();
    private ArrayList<AwsElasticBlockStoreVolumeBuilder> awsElasticBlockStoreVolumes = new ArrayList();
    private ArrayList<AzureDiskVolumeBuilder> azureDiskVolumes = new ArrayList();
    private ArrayList<AzureFileVolumeBuilder> azureFileVolumes = new ArrayList();
    private ArrayList<MountBuilder> mounts = new ArrayList();
    private ImagePullPolicy imagePullPolicy;
    private List<String> imagePullSecrets = new ArrayList<String>();
    private DeploymentStrategy deploymentStrategy;
    private RollingUpdateBuilder rollingUpdate;
    private ArrayList<HostAliasBuilder> hostAliases = new ArrayList();
    private NodeSelectorBuilder nodeSelector;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ProbeBuilder startupProbe;
    private ResourceRequirementsBuilder requestResources;
    private ResourceRequirementsBuilder limitResources;
    private ArrayList<ContainerBuilder> sidecars = new ArrayList();
    private Boolean autoDeployEnabled;
    private ArrayList<JobBuilder> jobs = new ArrayList();
    private ArrayList<CronJobBuilder> cronJobs = new ArrayList();

    public BaseConfigFluent() {
    }

    public BaseConfigFluent(BaseConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BaseConfig instance) {
        BaseConfig baseConfig = instance = instance != null ? instance : new BaseConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withPartOf(instance.getPartOf());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withDeploymentKind(instance.getDeploymentKind());
            this.withLabels(instance.getLabels());
            this.withAnnotations(instance.getAnnotations());
            this.withEnvVars(instance.getEnvVars());
            this.withWorkingDir(instance.getWorkingDir());
            this.withCommand(instance.getCommand());
            this.withArguments(instance.getArguments());
            this.withServiceAccount(instance.getServiceAccount());
            this.withPorts(instance.getPorts());
            this.withServiceType(instance.getServiceType());
            this.withPvcVolumes(instance.getPvcVolumes());
            this.withSecretVolumes(instance.getSecretVolumes());
            this.withConfigMapVolumes(instance.getConfigMapVolumes());
            this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
            this.withGitRepoVolumes(instance.getGitRepoVolumes());
            this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
            this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
            this.withAzureFileVolumes(instance.getAzureFileVolumes());
            this.withMounts(instance.getMounts());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withDeploymentStrategy(instance.getDeploymentStrategy());
            this.withRollingUpdate(instance.getRollingUpdate());
            this.withHostAliases(instance.getHostAliases());
            this.withNodeSelector(instance.getNodeSelector());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withStartupProbe(instance.getStartupProbe());
            this.withRequestResources(instance.getRequestResources());
            this.withLimitResources(instance.getLimitResources());
            this.withSidecars(instance.getSidecars());
            this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
            this.withJobs(instance.getJobs());
            this.withCronJobs(instance.getCronJobs());
        }
    }

    public String getDeploymentKind() {
        return this.deploymentKind;
    }

    public A withDeploymentKind(String deploymentKind) {
        this.deploymentKind = deploymentKind;
        return (A)((Object)this);
    }

    public boolean hasDeploymentKind() {
        return this.deploymentKind != null;
    }

    public A withLabels(Label ... labels) {
        if (this.labels != null) {
            this.labels.clear();
            this._visitables.remove((Object)"labels");
        }
        if (labels != null) {
            for (Label item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public Label[] buildLabels() {
        int size = this.labels != null ? this.labels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.labels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    public Label buildLabel(int index) {
        return this.labels.get(index).build();
    }

    public Label buildFirstLabel() {
        return this.labels.get(0).build();
    }

    public Label buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    public Label buildMatchingLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToLabels(int index, Label item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this.labels.size()) {
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        } else {
            this._visitables.get((Object)"labels").add(index, builder);
            this.labels.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToLabels(int index, Label item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this.labels.size()) {
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        } else {
            this._visitables.get((Object)"labels").set(index, builder);
            this.labels.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Label ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLabels(Collection<Label> items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Label ... items) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").remove((Object)builder);
            this.labels.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLabels(Collection<Label> items) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"labels").remove((Object)builder);
            this.labels.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLabels(Predicate<LabelBuilder> predicate) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        Iterator<LabelBuilder> each = this.labels.iterator();
        List visitables = this._visitables.get((Object)"labels");
        while (each.hasNext()) {
            LabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    public A addNewLabel(String key, String value, String[] kinds) {
        return this.addToLabels(new Label(key, value, kinds));
    }

    public LabelsNested<A> addNewLabel() {
        return new LabelsNested(-1, null);
    }

    public LabelsNested<A> addNewLabelLike(Label item) {
        return new LabelsNested(-1, item);
    }

    public LabelsNested<A> setNewLabelLike(int index, Label item) {
        return new LabelsNested(index, item);
    }

    public LabelsNested<A> editLabel(int index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    public LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public LabelsNested<A> editMatchingLabel(Predicate<LabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.test(this.labels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public A withAnnotations(Annotation ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
            this._visitables.remove((Object)"annotations");
        }
        if (annotations != null) {
            for (Annotation item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public Annotation[] buildAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    public Annotation buildAnnotation(int index) {
        return this.annotations.get(index).build();
    }

    public Annotation buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    public Annotation buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAnnotations(int index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(index, builder);
            this.annotations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAnnotations(int index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
            this.annotations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        Iterator<AnnotationBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public A addNewAnnotation(String key, String value, String[] kinds) {
        return this.addToAnnotations(new Annotation(key, value, kinds));
    }

    public AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNested(-1, null);
    }

    public AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
        return new AnnotationsNested(-1, item);
    }

    public AnnotationsNested<A> setNewAnnotationLike(int index, Annotation item) {
        return new AnnotationsNested(index, item);
    }

    public AnnotationsNested<A> editAnnotation(int index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    public AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public A withEnvVars(Env ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
            this._visitables.remove((Object)"envVars");
        }
        if (envVars != null) {
            for (Env item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)((Object)this);
    }

    public Env[] buildEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    public Env buildEnvVar(int index) {
        return this.envVars.get(index).build();
    }

    public Env buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    public Env buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.envVars.size()) {
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        } else {
            this._visitables.get((Object)"envVars").add(index, builder);
            this.envVars.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.envVars.size()) {
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        } else {
            this._visitables.get((Object)"envVars").set(index, builder);
            this.envVars.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvVars(Env ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvVars(Env ... items) {
        if (this.envVars == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").remove((Object)builder);
            this.envVars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").remove((Object)builder);
            this.envVars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnvVars(Predicate<EnvBuilder> predicate) {
        if (this.envVars == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.envVars.iterator();
        List visitables = this._visitables.get((Object)"envVars");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    public EnvVarsNested<A> addNewEnvVar() {
        return new EnvVarsNested(-1, null);
    }

    public EnvVarsNested<A> addNewEnvVarLike(Env item) {
        return new EnvVarsNested(-1, item);
    }

    public EnvVarsNested<A> setNewEnvVarLike(int index, Env item) {
        return new EnvVarsNested(index, item);
    }

    public EnvVarsNested<A> editEnvVar(int index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public EnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    public EnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.test(this.envVars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)((Object)this);
    }

    public boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getCommand() {
        int size = this.command != null ? this.command.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.command) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public A withArguments(String ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
            this._visitables.remove((Object)"arguments");
        }
        if (arguments != null) {
            for (String item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getArguments() {
        int size = this.arguments != null ? this.arguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.arguments) {
            result[index++] = item;
        }
        return result;
    }

    public A addToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(index, item);
        return (A)((Object)this);
    }

    public A setToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.set(index, item);
        return (A)((Object)this);
    }

    public A addToArguments(String ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToArguments(Collection<String> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromArguments(String ... items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.arguments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArguments(Collection<String> items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.arguments.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public Port[] buildPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(Port ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<Port> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<PortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            PortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(Port item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public A withServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return (A)((Object)this);
    }

    public boolean hasServiceType() {
        return this.serviceType != null;
    }

    public A withPvcVolumes(PersistentVolumeClaimVolume ... pvcVolumes) {
        if (this.pvcVolumes != null) {
            this.pvcVolumes.clear();
            this._visitables.remove((Object)"pvcVolumes");
        }
        if (pvcVolumes != null) {
            for (PersistentVolumeClaimVolume item : pvcVolumes) {
                this.addToPvcVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public PersistentVolumeClaimVolume[] buildPvcVolumes() {
        int size = this.pvcVolumes != null ? this.pvcVolumes.size() : 0;
        PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.pvcVolumes) {
            result[index++] = (PersistentVolumeClaimVolume)visitableBuilder.build();
        }
        return result;
    }

    public PersistentVolumeClaimVolume buildPvcVolume(int index) {
        return this.pvcVolumes.get(index).build();
    }

    public PersistentVolumeClaimVolume buildFirstPvcVolume() {
        return this.pvcVolumes.get(0).build();
    }

    public PersistentVolumeClaimVolume buildLastPvcVolume() {
        return this.pvcVolumes.get(this.pvcVolumes.size() - 1).build();
    }

    public PersistentVolumeClaimVolume buildMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToPvcVolumes(int index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        if (index < 0 || index >= this.pvcVolumes.size()) {
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        } else {
            this._visitables.get((Object)"pvcVolumes").add(index, builder);
            this.pvcVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPvcVolumes(int index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        if (index < 0 || index >= this.pvcVolumes.size()) {
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        } else {
            this._visitables.get((Object)"pvcVolumes").set(index, builder);
            this.pvcVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPvcVolumes(PersistentVolumeClaimVolume ... items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPvcVolumes(PersistentVolumeClaimVolume ... items) {
        if (this.pvcVolumes == null) {
            return (A)((Object)this);
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove((Object)builder);
            this.pvcVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        if (this.pvcVolumes == null) {
            return (A)((Object)this);
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove((Object)builder);
            this.pvcVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPvcVolumes(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        if (this.pvcVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<PersistentVolumeClaimVolumeBuilder> each = this.pvcVolumes.iterator();
        List visitables = this._visitables.get((Object)"pvcVolumes");
        while (each.hasNext()) {
            PersistentVolumeClaimVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasPvcVolumes() {
        return this.pvcVolumes != null && !this.pvcVolumes.isEmpty();
    }

    public A addNewPvcVolume(String volumeName, String claimName, Boolean readOnly) {
        return this.addToPvcVolumes(new PersistentVolumeClaimVolume(volumeName, claimName, readOnly));
    }

    public PvcVolumesNested<A> addNewPvcVolume() {
        return new PvcVolumesNested(-1, null);
    }

    public PvcVolumesNested<A> addNewPvcVolumeLike(PersistentVolumeClaimVolume item) {
        return new PvcVolumesNested(-1, item);
    }

    public PvcVolumesNested<A> setNewPvcVolumeLike(int index, PersistentVolumeClaimVolume item) {
        return new PvcVolumesNested(index, item);
    }

    public PvcVolumesNested<A> editPvcVolume(int index) {
        if (this.pvcVolumes.size() <= index) {
            throw new RuntimeException("Can't edit pvcVolumes. Index exceeds size.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    public PvcVolumesNested<A> editFirstPvcVolume() {
        if (this.pvcVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(0, this.buildPvcVolume(0));
    }

    public PvcVolumesNested<A> editLastPvcVolume() {
        int index = this.pvcVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    public PvcVolumesNested<A> editMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pvcVolumes.size(); ++i) {
            if (!predicate.test(this.pvcVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pvcVolumes. No match found.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    public A withSecretVolumes(SecretVolume ... secretVolumes) {
        if (this.secretVolumes != null) {
            this.secretVolumes.clear();
            this._visitables.remove((Object)"secretVolumes");
        }
        if (secretVolumes != null) {
            for (SecretVolume item : secretVolumes) {
                this.addToSecretVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public SecretVolume[] buildSecretVolumes() {
        int size = this.secretVolumes != null ? this.secretVolumes.size() : 0;
        SecretVolume[] result = new SecretVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.secretVolumes) {
            result[index++] = (SecretVolume)visitableBuilder.build();
        }
        return result;
    }

    public SecretVolume buildSecretVolume(int index) {
        return this.secretVolumes.get(index).build();
    }

    public SecretVolume buildFirstSecretVolume() {
        return this.secretVolumes.get(0).build();
    }

    public SecretVolume buildLastSecretVolume() {
        return this.secretVolumes.get(this.secretVolumes.size() - 1).build();
    }

    public SecretVolume buildMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToSecretVolumes(int index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        if (index < 0 || index >= this.secretVolumes.size()) {
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        } else {
            this._visitables.get((Object)"secretVolumes").add(index, builder);
            this.secretVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSecretVolumes(int index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        if (index < 0 || index >= this.secretVolumes.size()) {
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        } else {
            this._visitables.get((Object)"secretVolumes").set(index, builder);
            this.secretVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSecretVolumes(SecretVolume ... items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSecretVolumes(Collection<SecretVolume> items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSecretVolumes(SecretVolume ... items) {
        if (this.secretVolumes == null) {
            return (A)((Object)this);
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove((Object)builder);
            this.secretVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecretVolumes(Collection<SecretVolume> items) {
        if (this.secretVolumes == null) {
            return (A)((Object)this);
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove((Object)builder);
            this.secretVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSecretVolumes(Predicate<SecretVolumeBuilder> predicate) {
        if (this.secretVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<SecretVolumeBuilder> each = this.secretVolumes.iterator();
        List visitables = this._visitables.get((Object)"secretVolumes");
        while (each.hasNext()) {
            SecretVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasSecretVolumes() {
        return this.secretVolumes != null && !this.secretVolumes.isEmpty();
    }

    public SecretVolumesNested<A> addNewSecretVolume() {
        return new SecretVolumesNested(-1, null);
    }

    public SecretVolumesNested<A> addNewSecretVolumeLike(SecretVolume item) {
        return new SecretVolumesNested(-1, item);
    }

    public SecretVolumesNested<A> setNewSecretVolumeLike(int index, SecretVolume item) {
        return new SecretVolumesNested(index, item);
    }

    public SecretVolumesNested<A> editSecretVolume(int index) {
        if (this.secretVolumes.size() <= index) {
            throw new RuntimeException("Can't edit secretVolumes. Index exceeds size.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    public SecretVolumesNested<A> editFirstSecretVolume() {
        if (this.secretVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(0, this.buildSecretVolume(0));
    }

    public SecretVolumesNested<A> editLastSecretVolume() {
        int index = this.secretVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    public SecretVolumesNested<A> editMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretVolumes.size(); ++i) {
            if (!predicate.test(this.secretVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretVolumes. No match found.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    public A withConfigMapVolumes(ConfigMapVolume ... configMapVolumes) {
        if (this.configMapVolumes != null) {
            this.configMapVolumes.clear();
            this._visitables.remove((Object)"configMapVolumes");
        }
        if (configMapVolumes != null) {
            for (ConfigMapVolume item : configMapVolumes) {
                this.addToConfigMapVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public ConfigMapVolume[] buildConfigMapVolumes() {
        int size = this.configMapVolumes != null ? this.configMapVolumes.size() : 0;
        ConfigMapVolume[] result = new ConfigMapVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.configMapVolumes) {
            result[index++] = (ConfigMapVolume)visitableBuilder.build();
        }
        return result;
    }

    public ConfigMapVolume buildConfigMapVolume(int index) {
        return this.configMapVolumes.get(index).build();
    }

    public ConfigMapVolume buildFirstConfigMapVolume() {
        return this.configMapVolumes.get(0).build();
    }

    public ConfigMapVolume buildLastConfigMapVolume() {
        return this.configMapVolumes.get(this.configMapVolumes.size() - 1).build();
    }

    public ConfigMapVolume buildMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToConfigMapVolumes(int index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        if (index < 0 || index >= this.configMapVolumes.size()) {
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        } else {
            this._visitables.get((Object)"configMapVolumes").add(index, builder);
            this.configMapVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfigMapVolumes(int index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        if (index < 0 || index >= this.configMapVolumes.size()) {
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        } else {
            this._visitables.get((Object)"configMapVolumes").set(index, builder);
            this.configMapVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfigMapVolumes(ConfigMapVolume ... items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfigMapVolumes(Collection<ConfigMapVolume> items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfigMapVolumes(ConfigMapVolume ... items) {
        if (this.configMapVolumes == null) {
            return (A)((Object)this);
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove((Object)builder);
            this.configMapVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfigMapVolumes(Collection<ConfigMapVolume> items) {
        if (this.configMapVolumes == null) {
            return (A)((Object)this);
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove((Object)builder);
            this.configMapVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfigMapVolumes(Predicate<ConfigMapVolumeBuilder> predicate) {
        if (this.configMapVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigMapVolumeBuilder> each = this.configMapVolumes.iterator();
        List visitables = this._visitables.get((Object)"configMapVolumes");
        while (each.hasNext()) {
            ConfigMapVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasConfigMapVolumes() {
        return this.configMapVolumes != null && !this.configMapVolumes.isEmpty();
    }

    public ConfigMapVolumesNested<A> addNewConfigMapVolume() {
        return new ConfigMapVolumesNested(-1, null);
    }

    public ConfigMapVolumesNested<A> addNewConfigMapVolumeLike(ConfigMapVolume item) {
        return new ConfigMapVolumesNested(-1, item);
    }

    public ConfigMapVolumesNested<A> setNewConfigMapVolumeLike(int index, ConfigMapVolume item) {
        return new ConfigMapVolumesNested(index, item);
    }

    public ConfigMapVolumesNested<A> editConfigMapVolume(int index) {
        if (this.configMapVolumes.size() <= index) {
            throw new RuntimeException("Can't edit configMapVolumes. Index exceeds size.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    public ConfigMapVolumesNested<A> editFirstConfigMapVolume() {
        if (this.configMapVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(0, this.buildConfigMapVolume(0));
    }

    public ConfigMapVolumesNested<A> editLastConfigMapVolume() {
        int index = this.configMapVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    public ConfigMapVolumesNested<A> editMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configMapVolumes.size(); ++i) {
            if (!predicate.test(this.configMapVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configMapVolumes. No match found.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    public A withEmptyDirVolumes(EmptyDirVolume ... emptyDirVolumes) {
        if (this.emptyDirVolumes != null) {
            this.emptyDirVolumes.clear();
            this._visitables.remove((Object)"emptyDirVolumes");
        }
        if (emptyDirVolumes != null) {
            for (EmptyDirVolume item : emptyDirVolumes) {
                this.addToEmptyDirVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public EmptyDirVolume[] buildEmptyDirVolumes() {
        int size = this.emptyDirVolumes != null ? this.emptyDirVolumes.size() : 0;
        EmptyDirVolume[] result = new EmptyDirVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.emptyDirVolumes) {
            result[index++] = (EmptyDirVolume)visitableBuilder.build();
        }
        return result;
    }

    public EmptyDirVolume buildEmptyDirVolume(int index) {
        return this.emptyDirVolumes.get(index).build();
    }

    public EmptyDirVolume buildFirstEmptyDirVolume() {
        return this.emptyDirVolumes.get(0).build();
    }

    public EmptyDirVolume buildLastEmptyDirVolume() {
        return this.emptyDirVolumes.get(this.emptyDirVolumes.size() - 1).build();
    }

    public EmptyDirVolume buildMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToEmptyDirVolumes(int index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        if (index < 0 || index >= this.emptyDirVolumes.size()) {
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        } else {
            this._visitables.get((Object)"emptyDirVolumes").add(index, builder);
            this.emptyDirVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEmptyDirVolumes(int index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        if (index < 0 || index >= this.emptyDirVolumes.size()) {
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        } else {
            this._visitables.get((Object)"emptyDirVolumes").set(index, builder);
            this.emptyDirVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEmptyDirVolumes(EmptyDirVolume ... items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEmptyDirVolumes(EmptyDirVolume ... items) {
        if (this.emptyDirVolumes == null) {
            return (A)((Object)this);
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove((Object)builder);
            this.emptyDirVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        if (this.emptyDirVolumes == null) {
            return (A)((Object)this);
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove((Object)builder);
            this.emptyDirVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEmptyDirVolumes(Predicate<EmptyDirVolumeBuilder> predicate) {
        if (this.emptyDirVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<EmptyDirVolumeBuilder> each = this.emptyDirVolumes.iterator();
        List visitables = this._visitables.get((Object)"emptyDirVolumes");
        while (each.hasNext()) {
            EmptyDirVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasEmptyDirVolumes() {
        return this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty();
    }

    public A addNewEmptyDirVolume(String volumeName) {
        return this.addToEmptyDirVolumes(new EmptyDirVolume(volumeName));
    }

    public EmptyDirVolumesNested<A> addNewEmptyDirVolume() {
        return new EmptyDirVolumesNested(-1, null);
    }

    public EmptyDirVolumesNested<A> addNewEmptyDirVolumeLike(EmptyDirVolume item) {
        return new EmptyDirVolumesNested(-1, item);
    }

    public EmptyDirVolumesNested<A> setNewEmptyDirVolumeLike(int index, EmptyDirVolume item) {
        return new EmptyDirVolumesNested(index, item);
    }

    public EmptyDirVolumesNested<A> editEmptyDirVolume(int index) {
        if (this.emptyDirVolumes.size() <= index) {
            throw new RuntimeException("Can't edit emptyDirVolumes. Index exceeds size.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    public EmptyDirVolumesNested<A> editFirstEmptyDirVolume() {
        if (this.emptyDirVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(0, this.buildEmptyDirVolume(0));
    }

    public EmptyDirVolumesNested<A> editLastEmptyDirVolume() {
        int index = this.emptyDirVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    public EmptyDirVolumesNested<A> editMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.emptyDirVolumes.size(); ++i) {
            if (!predicate.test(this.emptyDirVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching emptyDirVolumes. No match found.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    public A withGitRepoVolumes(GitRepoVolume ... gitRepoVolumes) {
        if (this.gitRepoVolumes != null) {
            this.gitRepoVolumes.clear();
            this._visitables.remove((Object)"gitRepoVolumes");
        }
        if (gitRepoVolumes != null) {
            for (GitRepoVolume item : gitRepoVolumes) {
                this.addToGitRepoVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public GitRepoVolume[] buildGitRepoVolumes() {
        int size = this.gitRepoVolumes != null ? this.gitRepoVolumes.size() : 0;
        GitRepoVolume[] result = new GitRepoVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.gitRepoVolumes) {
            result[index++] = (GitRepoVolume)visitableBuilder.build();
        }
        return result;
    }

    public GitRepoVolume buildGitRepoVolume(int index) {
        return this.gitRepoVolumes.get(index).build();
    }

    public GitRepoVolume buildFirstGitRepoVolume() {
        return this.gitRepoVolumes.get(0).build();
    }

    public GitRepoVolume buildLastGitRepoVolume() {
        return this.gitRepoVolumes.get(this.gitRepoVolumes.size() - 1).build();
    }

    public GitRepoVolume buildMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
        for (GitRepoVolumeBuilder item : this.gitRepoVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
        for (GitRepoVolumeBuilder item : this.gitRepoVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToGitRepoVolumes(int index, GitRepoVolume item) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
        if (index < 0 || index >= this.gitRepoVolumes.size()) {
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
            this.gitRepoVolumes.add(builder);
        } else {
            this._visitables.get((Object)"gitRepoVolumes").add(index, builder);
            this.gitRepoVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGitRepoVolumes(int index, GitRepoVolume item) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
        if (index < 0 || index >= this.gitRepoVolumes.size()) {
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
            this.gitRepoVolumes.add(builder);
        } else {
            this._visitables.get((Object)"gitRepoVolumes").set(index, builder);
            this.gitRepoVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGitRepoVolumes(GitRepoVolume ... items) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
            this.gitRepoVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGitRepoVolumes(Collection<GitRepoVolume> items) {
        if (this.gitRepoVolumes == null) {
            this.gitRepoVolumes = new ArrayList();
        }
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").add(builder);
            this.gitRepoVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGitRepoVolumes(GitRepoVolume ... items) {
        if (this.gitRepoVolumes == null) {
            return (A)((Object)this);
        }
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").remove((Object)builder);
            this.gitRepoVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGitRepoVolumes(Collection<GitRepoVolume> items) {
        if (this.gitRepoVolumes == null) {
            return (A)((Object)this);
        }
        for (GitRepoVolume item : items) {
            GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
            this._visitables.get((Object)"gitRepoVolumes").remove((Object)builder);
            this.gitRepoVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGitRepoVolumes(Predicate<GitRepoVolumeBuilder> predicate) {
        if (this.gitRepoVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<GitRepoVolumeBuilder> each = this.gitRepoVolumes.iterator();
        List visitables = this._visitables.get((Object)"gitRepoVolumes");
        while (each.hasNext()) {
            GitRepoVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasGitRepoVolumes() {
        return this.gitRepoVolumes != null && !this.gitRepoVolumes.isEmpty();
    }

    public A addNewGitRepoVolume(String volumeName, String repository, String directory, String revision) {
        return this.addToGitRepoVolumes(new GitRepoVolume(volumeName, repository, directory, revision));
    }

    public GitRepoVolumesNested<A> addNewGitRepoVolume() {
        return new GitRepoVolumesNested(-1, null);
    }

    public GitRepoVolumesNested<A> addNewGitRepoVolumeLike(GitRepoVolume item) {
        return new GitRepoVolumesNested(-1, item);
    }

    public GitRepoVolumesNested<A> setNewGitRepoVolumeLike(int index, GitRepoVolume item) {
        return new GitRepoVolumesNested(index, item);
    }

    public GitRepoVolumesNested<A> editGitRepoVolume(int index) {
        if (this.gitRepoVolumes.size() <= index) {
            throw new RuntimeException("Can't edit gitRepoVolumes. Index exceeds size.");
        }
        return this.setNewGitRepoVolumeLike(index, this.buildGitRepoVolume(index));
    }

    public GitRepoVolumesNested<A> editFirstGitRepoVolume() {
        if (this.gitRepoVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first gitRepoVolumes. The list is empty.");
        }
        return this.setNewGitRepoVolumeLike(0, this.buildGitRepoVolume(0));
    }

    public GitRepoVolumesNested<A> editLastGitRepoVolume() {
        int index = this.gitRepoVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gitRepoVolumes. The list is empty.");
        }
        return this.setNewGitRepoVolumeLike(index, this.buildGitRepoVolume(index));
    }

    public GitRepoVolumesNested<A> editMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gitRepoVolumes.size(); ++i) {
            if (!predicate.test(this.gitRepoVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gitRepoVolumes. No match found.");
        }
        return this.setNewGitRepoVolumeLike(index, this.buildGitRepoVolume(index));
    }

    public A withAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... awsElasticBlockStoreVolumes) {
        if (this.awsElasticBlockStoreVolumes != null) {
            this.awsElasticBlockStoreVolumes.clear();
            this._visitables.remove((Object)"awsElasticBlockStoreVolumes");
        }
        if (awsElasticBlockStoreVolumes != null) {
            for (AwsElasticBlockStoreVolume item : awsElasticBlockStoreVolumes) {
                this.addToAwsElasticBlockStoreVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public AwsElasticBlockStoreVolume[] buildAwsElasticBlockStoreVolumes() {
        int size = this.awsElasticBlockStoreVolumes != null ? this.awsElasticBlockStoreVolumes.size() : 0;
        AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.awsElasticBlockStoreVolumes) {
            result[index++] = (AwsElasticBlockStoreVolume)visitableBuilder.build();
        }
        return result;
    }

    public AwsElasticBlockStoreVolume buildAwsElasticBlockStoreVolume(int index) {
        return this.awsElasticBlockStoreVolumes.get(index).build();
    }

    public AwsElasticBlockStoreVolume buildFirstAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(0).build();
    }

    public AwsElasticBlockStoreVolume buildLastAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(this.awsElasticBlockStoreVolumes.size() - 1).build();
    }

    public AwsElasticBlockStoreVolume buildMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAwsElasticBlockStoreVolumes(int index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        if (index < 0 || index >= this.awsElasticBlockStoreVolumes.size()) {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        } else {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(index, builder);
            this.awsElasticBlockStoreVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAwsElasticBlockStoreVolumes(int index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        if (index < 0 || index >= this.awsElasticBlockStoreVolumes.size()) {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        } else {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").set(index, builder);
            this.awsElasticBlockStoreVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)((Object)this);
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove((Object)builder);
            this.awsElasticBlockStoreVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)((Object)this);
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove((Object)builder);
            this.awsElasticBlockStoreVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAwsElasticBlockStoreVolumes(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AwsElasticBlockStoreVolumeBuilder> each = this.awsElasticBlockStoreVolumes.iterator();
        List visitables = this._visitables.get((Object)"awsElasticBlockStoreVolumes");
        while (each.hasNext()) {
            AwsElasticBlockStoreVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty();
    }

    public A addNewAwsElasticBlockStoreVolume(String volumeName, String volumeId, Integer partition, String fsType, Boolean readOnly) {
        return this.addToAwsElasticBlockStoreVolumes(new AwsElasticBlockStoreVolume(volumeName, volumeId, partition, fsType, readOnly));
    }

    public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolume() {
        return new AwsElasticBlockStoreVolumesNested(-1, null);
    }

    public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolumeLike(AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNested(-1, item);
    }

    public AwsElasticBlockStoreVolumesNested<A> setNewAwsElasticBlockStoreVolumeLike(int index, AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNested(index, item);
    }

    public AwsElasticBlockStoreVolumesNested<A> editAwsElasticBlockStoreVolume(int index) {
        if (this.awsElasticBlockStoreVolumes.size() <= index) {
            throw new RuntimeException("Can't edit awsElasticBlockStoreVolumes. Index exceeds size.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    public AwsElasticBlockStoreVolumesNested<A> editFirstAwsElasticBlockStoreVolume() {
        if (this.awsElasticBlockStoreVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(0, this.buildAwsElasticBlockStoreVolume(0));
    }

    public AwsElasticBlockStoreVolumesNested<A> editLastAwsElasticBlockStoreVolume() {
        int index = this.awsElasticBlockStoreVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    public AwsElasticBlockStoreVolumesNested<A> editMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.awsElasticBlockStoreVolumes.size(); ++i) {
            if (!predicate.test(this.awsElasticBlockStoreVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching awsElasticBlockStoreVolumes. No match found.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    public A withAzureDiskVolumes(AzureDiskVolume ... azureDiskVolumes) {
        if (this.azureDiskVolumes != null) {
            this.azureDiskVolumes.clear();
            this._visitables.remove((Object)"azureDiskVolumes");
        }
        if (azureDiskVolumes != null) {
            for (AzureDiskVolume item : azureDiskVolumes) {
                this.addToAzureDiskVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public AzureDiskVolume[] buildAzureDiskVolumes() {
        int size = this.azureDiskVolumes != null ? this.azureDiskVolumes.size() : 0;
        AzureDiskVolume[] result = new AzureDiskVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureDiskVolumes) {
            result[index++] = (AzureDiskVolume)visitableBuilder.build();
        }
        return result;
    }

    public AzureDiskVolume buildAzureDiskVolume(int index) {
        return this.azureDiskVolumes.get(index).build();
    }

    public AzureDiskVolume buildFirstAzureDiskVolume() {
        return this.azureDiskVolumes.get(0).build();
    }

    public AzureDiskVolume buildLastAzureDiskVolume() {
        return this.azureDiskVolumes.get(this.azureDiskVolumes.size() - 1).build();
    }

    public AzureDiskVolume buildMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAzureDiskVolumes(int index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        if (index < 0 || index >= this.azureDiskVolumes.size()) {
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureDiskVolumes").add(index, builder);
            this.azureDiskVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAzureDiskVolumes(int index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        if (index < 0 || index >= this.azureDiskVolumes.size()) {
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureDiskVolumes").set(index, builder);
            this.azureDiskVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAzureDiskVolumes(AzureDiskVolume ... items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAzureDiskVolumes(AzureDiskVolume ... items) {
        if (this.azureDiskVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove((Object)builder);
            this.azureDiskVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        if (this.azureDiskVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove((Object)builder);
            this.azureDiskVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAzureDiskVolumes(Predicate<AzureDiskVolumeBuilder> predicate) {
        if (this.azureDiskVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AzureDiskVolumeBuilder> each = this.azureDiskVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureDiskVolumes");
        while (each.hasNext()) {
            AzureDiskVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAzureDiskVolumes() {
        return this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty();
    }

    public AzureDiskVolumesNested<A> addNewAzureDiskVolume() {
        return new AzureDiskVolumesNested(-1, null);
    }

    public AzureDiskVolumesNested<A> addNewAzureDiskVolumeLike(AzureDiskVolume item) {
        return new AzureDiskVolumesNested(-1, item);
    }

    public AzureDiskVolumesNested<A> setNewAzureDiskVolumeLike(int index, AzureDiskVolume item) {
        return new AzureDiskVolumesNested(index, item);
    }

    public AzureDiskVolumesNested<A> editAzureDiskVolume(int index) {
        if (this.azureDiskVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureDiskVolumes. Index exceeds size.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    public AzureDiskVolumesNested<A> editFirstAzureDiskVolume() {
        if (this.azureDiskVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(0, this.buildAzureDiskVolume(0));
    }

    public AzureDiskVolumesNested<A> editLastAzureDiskVolume() {
        int index = this.azureDiskVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    public AzureDiskVolumesNested<A> editMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureDiskVolumes.size(); ++i) {
            if (!predicate.test(this.azureDiskVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureDiskVolumes. No match found.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    public A withAzureFileVolumes(AzureFileVolume ... azureFileVolumes) {
        if (this.azureFileVolumes != null) {
            this.azureFileVolumes.clear();
            this._visitables.remove((Object)"azureFileVolumes");
        }
        if (azureFileVolumes != null) {
            for (AzureFileVolume item : azureFileVolumes) {
                this.addToAzureFileVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public AzureFileVolume[] buildAzureFileVolumes() {
        int size = this.azureFileVolumes != null ? this.azureFileVolumes.size() : 0;
        AzureFileVolume[] result = new AzureFileVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureFileVolumes) {
            result[index++] = (AzureFileVolume)visitableBuilder.build();
        }
        return result;
    }

    public AzureFileVolume buildAzureFileVolume(int index) {
        return this.azureFileVolumes.get(index).build();
    }

    public AzureFileVolume buildFirstAzureFileVolume() {
        return this.azureFileVolumes.get(0).build();
    }

    public AzureFileVolume buildLastAzureFileVolume() {
        return this.azureFileVolumes.get(this.azureFileVolumes.size() - 1).build();
    }

    public AzureFileVolume buildMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAzureFileVolumes(int index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        if (index < 0 || index >= this.azureFileVolumes.size()) {
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureFileVolumes").add(index, builder);
            this.azureFileVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAzureFileVolumes(int index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        if (index < 0 || index >= this.azureFileVolumes.size()) {
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureFileVolumes").set(index, builder);
            this.azureFileVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAzureFileVolumes(AzureFileVolume ... items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAzureFileVolumes(Collection<AzureFileVolume> items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAzureFileVolumes(AzureFileVolume ... items) {
        if (this.azureFileVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove((Object)builder);
            this.azureFileVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAzureFileVolumes(Collection<AzureFileVolume> items) {
        if (this.azureFileVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove((Object)builder);
            this.azureFileVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAzureFileVolumes(Predicate<AzureFileVolumeBuilder> predicate) {
        if (this.azureFileVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AzureFileVolumeBuilder> each = this.azureFileVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureFileVolumes");
        while (each.hasNext()) {
            AzureFileVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAzureFileVolumes() {
        return this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty();
    }

    public A addNewAzureFileVolume(String volumeName, String shareName, String secretName, Boolean readOnly) {
        return this.addToAzureFileVolumes(new AzureFileVolume(volumeName, shareName, secretName, readOnly));
    }

    public AzureFileVolumesNested<A> addNewAzureFileVolume() {
        return new AzureFileVolumesNested(-1, null);
    }

    public AzureFileVolumesNested<A> addNewAzureFileVolumeLike(AzureFileVolume item) {
        return new AzureFileVolumesNested(-1, item);
    }

    public AzureFileVolumesNested<A> setNewAzureFileVolumeLike(int index, AzureFileVolume item) {
        return new AzureFileVolumesNested(index, item);
    }

    public AzureFileVolumesNested<A> editAzureFileVolume(int index) {
        if (this.azureFileVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureFileVolumes. Index exceeds size.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    public AzureFileVolumesNested<A> editFirstAzureFileVolume() {
        if (this.azureFileVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(0, this.buildAzureFileVolume(0));
    }

    public AzureFileVolumesNested<A> editLastAzureFileVolume() {
        int index = this.azureFileVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    public AzureFileVolumesNested<A> editMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureFileVolumes.size(); ++i) {
            if (!predicate.test(this.azureFileVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureFileVolumes. No match found.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    public A withMounts(Mount ... mounts) {
        if (this.mounts != null) {
            this.mounts.clear();
            this._visitables.remove((Object)"mounts");
        }
        if (mounts != null) {
            for (Mount item : mounts) {
                this.addToMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public Mount[] buildMounts() {
        int size = this.mounts != null ? this.mounts.size() : 0;
        Mount[] result = new Mount[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.mounts) {
            result[index++] = (Mount)visitableBuilder.build();
        }
        return result;
    }

    public Mount buildMount(int index) {
        return this.mounts.get(index).build();
    }

    public Mount buildFirstMount() {
        return this.mounts.get(0).build();
    }

    public Mount buildLastMount() {
        return this.mounts.get(this.mounts.size() - 1).build();
    }

    public Mount buildMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToMounts(int index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        MountBuilder builder = new MountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get((Object)"mounts").add(index, builder);
            this.mounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMounts(int index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        MountBuilder builder = new MountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get((Object)"mounts").set(index, builder);
            this.mounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMounts(Mount ... items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMounts(Collection<Mount> items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMounts(Mount ... items) {
        if (this.mounts == null) {
            return (A)((Object)this);
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").remove((Object)builder);
            this.mounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMounts(Collection<Mount> items) {
        if (this.mounts == null) {
            return (A)((Object)this);
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").remove((Object)builder);
            this.mounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMounts(Predicate<MountBuilder> predicate) {
        if (this.mounts == null) {
            return (A)((Object)this);
        }
        Iterator<MountBuilder> each = this.mounts.iterator();
        List visitables = this._visitables.get((Object)"mounts");
        while (each.hasNext()) {
            MountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasMounts() {
        return this.mounts != null && !this.mounts.isEmpty();
    }

    public A addNewMount(String name, String path, String subPath, Boolean readOnly) {
        return this.addToMounts(new Mount(name, path, subPath, readOnly));
    }

    public MountsNested<A> addNewMount() {
        return new MountsNested(-1, null);
    }

    public MountsNested<A> addNewMountLike(Mount item) {
        return new MountsNested(-1, item);
    }

    public MountsNested<A> setNewMountLike(int index, Mount item) {
        return new MountsNested(index, item);
    }

    public MountsNested<A> editMount(int index) {
        if (this.mounts.size() <= index) {
            throw new RuntimeException("Can't edit mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public MountsNested<A> editFirstMount() {
        if (this.mounts.size() == 0) {
            throw new RuntimeException("Can't edit first mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    public MountsNested<A> editLastMount() {
        int index = this.mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public MountsNested<A> editMatchingMount(Predicate<MountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (!predicate.test(this.mounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public A withImagePullSecrets(String ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove((Object)"imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (String item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getImagePullSecrets() {
        int size = this.imagePullSecrets != null ? this.imagePullSecrets.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.imagePullSecrets) {
            result[index++] = item;
        }
        return result;
    }

    public A addToImagePullSecrets(int index, String item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        this.imagePullSecrets.add(index, item);
        return (A)((Object)this);
    }

    public A setToImagePullSecrets(int index, String item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        this.imagePullSecrets.set(index, item);
        return (A)((Object)this);
    }

    public A addToImagePullSecrets(String ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToImagePullSecrets(Collection<String> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromImagePullSecrets(String ... items) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.imagePullSecrets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImagePullSecrets(Collection<String> items) {
        if (this.imagePullSecrets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.imagePullSecrets.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    public A withDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.deploymentStrategy = deploymentStrategy;
        return (A)((Object)this);
    }

    public boolean hasDeploymentStrategy() {
        return this.deploymentStrategy != null;
    }

    public RollingUpdate buildRollingUpdate() {
        return this.rollingUpdate != null ? this.rollingUpdate.build() : null;
    }

    public A withRollingUpdate(RollingUpdate rollingUpdate) {
        this._visitables.remove((Object)"rollingUpdate");
        if (rollingUpdate != null) {
            this.rollingUpdate = new RollingUpdateBuilder(rollingUpdate);
            this._visitables.get((Object)"rollingUpdate").add(this.rollingUpdate);
        } else {
            this.rollingUpdate = null;
            this._visitables.get((Object)"rollingUpdate").remove((Object)this.rollingUpdate);
        }
        return (A)((Object)this);
    }

    public boolean hasRollingUpdate() {
        return this.rollingUpdate != null;
    }

    public A withNewRollingUpdate(String maxUnavailable, String maxSurge) {
        return this.withRollingUpdate(new RollingUpdate(maxUnavailable, maxSurge));
    }

    public RollingUpdateNested<A> withNewRollingUpdate() {
        return new RollingUpdateNested(null);
    }

    public RollingUpdateNested<A> withNewRollingUpdateLike(RollingUpdate item) {
        return new RollingUpdateNested(item);
    }

    public RollingUpdateNested<A> editRollingUpdate() {
        return this.withNewRollingUpdateLike(Optional.ofNullable(this.buildRollingUpdate()).orElse(null));
    }

    public RollingUpdateNested<A> editOrNewRollingUpdate() {
        return this.withNewRollingUpdateLike(Optional.ofNullable(this.buildRollingUpdate()).orElse(new RollingUpdateBuilder().build()));
    }

    public RollingUpdateNested<A> editOrNewRollingUpdateLike(RollingUpdate item) {
        return this.withNewRollingUpdateLike(Optional.ofNullable(this.buildRollingUpdate()).orElse(item));
    }

    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove((Object)"hostAliases");
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)((Object)this);
    }

    public HostAlias[] buildHostAliases() {
        int size = this.hostAliases != null ? this.hostAliases.size() : 0;
        HostAlias[] result = new HostAlias[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.hostAliases) {
            result[index++] = (HostAlias)visitableBuilder.build();
        }
        return result;
    }

    public HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get((Object)"hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get((Object)"hostAliases").add(index, builder);
            this.hostAliases.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get((Object)"hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get((Object)"hostAliases").set(index, builder);
            this.hostAliases.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").remove((Object)builder);
            this.hostAliases.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get((Object)"hostAliases").remove((Object)builder);
            this.hostAliases.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)((Object)this);
        }
        Iterator<HostAliasBuilder> each = this.hostAliases.iterator();
        List visitables = this._visitables.get((Object)"hostAliases");
        while (each.hasNext()) {
            HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public A addNewHostAlias(String ip, String hostnames) {
        return this.addToHostAliases(new HostAlias(ip, hostnames));
    }

    public HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNested(-1, null);
    }

    public HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNested(-1, item);
    }

    public HostAliasesNested<A> setNewHostAliasLike(int index, HostAlias item) {
        return new HostAliasesNested(index, item);
    }

    public HostAliasesNested<A> editHostAlias(int index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    public HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public NodeSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    public A withNodeSelector(NodeSelector nodeSelector) {
        this._visitables.remove((Object)"nodeSelector");
        if (nodeSelector != null) {
            this.nodeSelector = new NodeSelectorBuilder(nodeSelector);
            this._visitables.get((Object)"nodeSelector").add(this.nodeSelector);
        } else {
            this.nodeSelector = null;
            this._visitables.get((Object)"nodeSelector").remove((Object)this.nodeSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A withNewNodeSelector(String key, String value) {
        return this.withNodeSelector(new NodeSelector(key, value));
    }

    public NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNested(null);
    }

    public NodeSelectorNested<A> withNewNodeSelectorLike(NodeSelector item) {
        return new NodeSelectorNested(item);
    }

    public NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(null));
    }

    public NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(new NodeSelectorBuilder().build()));
    }

    public NodeSelectorNested<A> editOrNewNodeSelectorLike(NodeSelector item) {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(item));
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove((Object)"livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove((Object)"readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    public A withStartupProbe(Probe startupProbe) {
        this._visitables.remove((Object)"startupProbe");
        if (startupProbe != null) {
            this.startupProbe = new ProbeBuilder(startupProbe);
            this._visitables.get((Object)"startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNested(null);
    }

    public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
        return new StartupProbeNested(item);
    }

    public StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(null));
    }

    public StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(new ProbeBuilder().build()));
    }

    public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(item));
    }

    public ResourceRequirements buildRequestResources() {
        return this.requestResources != null ? this.requestResources.build() : null;
    }

    public A withRequestResources(ResourceRequirements requestResources) {
        this._visitables.remove((Object)"requestResources");
        if (requestResources != null) {
            this.requestResources = new ResourceRequirementsBuilder(requestResources);
            this._visitables.get((Object)"requestResources").add(this.requestResources);
        } else {
            this.requestResources = null;
            this._visitables.get((Object)"requestResources").remove((Object)this.requestResources);
        }
        return (A)((Object)this);
    }

    public boolean hasRequestResources() {
        return this.requestResources != null;
    }

    public A withNewRequestResources(String memory, String cpu) {
        return this.withRequestResources(new ResourceRequirements(memory, cpu));
    }

    public RequestResourcesNested<A> withNewRequestResources() {
        return new RequestResourcesNested(null);
    }

    public RequestResourcesNested<A> withNewRequestResourcesLike(ResourceRequirements item) {
        return new RequestResourcesNested(item);
    }

    public RequestResourcesNested<A> editRequestResources() {
        return this.withNewRequestResourcesLike(Optional.ofNullable(this.buildRequestResources()).orElse(null));
    }

    public RequestResourcesNested<A> editOrNewRequestResources() {
        return this.withNewRequestResourcesLike(Optional.ofNullable(this.buildRequestResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public RequestResourcesNested<A> editOrNewRequestResourcesLike(ResourceRequirements item) {
        return this.withNewRequestResourcesLike(Optional.ofNullable(this.buildRequestResources()).orElse(item));
    }

    public ResourceRequirements buildLimitResources() {
        return this.limitResources != null ? this.limitResources.build() : null;
    }

    public A withLimitResources(ResourceRequirements limitResources) {
        this._visitables.remove((Object)"limitResources");
        if (limitResources != null) {
            this.limitResources = new ResourceRequirementsBuilder(limitResources);
            this._visitables.get((Object)"limitResources").add(this.limitResources);
        } else {
            this.limitResources = null;
            this._visitables.get((Object)"limitResources").remove((Object)this.limitResources);
        }
        return (A)((Object)this);
    }

    public boolean hasLimitResources() {
        return this.limitResources != null;
    }

    public A withNewLimitResources(String memory, String cpu) {
        return this.withLimitResources(new ResourceRequirements(memory, cpu));
    }

    public LimitResourcesNested<A> withNewLimitResources() {
        return new LimitResourcesNested(null);
    }

    public LimitResourcesNested<A> withNewLimitResourcesLike(ResourceRequirements item) {
        return new LimitResourcesNested(item);
    }

    public LimitResourcesNested<A> editLimitResources() {
        return this.withNewLimitResourcesLike(Optional.ofNullable(this.buildLimitResources()).orElse(null));
    }

    public LimitResourcesNested<A> editOrNewLimitResources() {
        return this.withNewLimitResourcesLike(Optional.ofNullable(this.buildLimitResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public LimitResourcesNested<A> editOrNewLimitResourcesLike(ResourceRequirements item) {
        return this.withNewLimitResourcesLike(Optional.ofNullable(this.buildLimitResources()).orElse(item));
    }

    public A withSidecars(Container ... sidecars) {
        if (this.sidecars != null) {
            this.sidecars.clear();
            this._visitables.remove((Object)"sidecars");
        }
        if (sidecars != null) {
            for (Container item : sidecars) {
                this.addToSidecars(item);
            }
        }
        return (A)((Object)this);
    }

    public Container[] buildSidecars() {
        int size = this.sidecars != null ? this.sidecars.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.sidecars) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    public Container buildSidecar(int index) {
        return this.sidecars.get(index).build();
    }

    public Container buildFirstSidecar() {
        return this.sidecars.get(0).build();
    }

    public Container buildLastSidecar() {
        return this.sidecars.get(this.sidecars.size() - 1).build();
    }

    public Container buildMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.sidecars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToSidecars(int index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.sidecars.size()) {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        } else {
            this._visitables.get((Object)"sidecars").add(index, builder);
            this.sidecars.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSidecars(int index, Container item) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.sidecars.size()) {
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        } else {
            this._visitables.get((Object)"sidecars").set(index, builder);
            this.sidecars.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecars(Container ... items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSidecars(Collection<Container> items) {
        if (this.sidecars == null) {
            this.sidecars = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").add(builder);
            this.sidecars.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSidecars(Container ... items) {
        if (this.sidecars == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").remove((Object)builder);
            this.sidecars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSidecars(Collection<Container> items) {
        if (this.sidecars == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"sidecars").remove((Object)builder);
            this.sidecars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecars(Predicate<ContainerBuilder> predicate) {
        if (this.sidecars == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerBuilder> each = this.sidecars.iterator();
        List visitables = this._visitables.get((Object)"sidecars");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasSidecars() {
        return this.sidecars != null && !this.sidecars.isEmpty();
    }

    public SidecarsNested<A> addNewSidecar() {
        return new SidecarsNested(-1, null);
    }

    public SidecarsNested<A> addNewSidecarLike(Container item) {
        return new SidecarsNested(-1, item);
    }

    public SidecarsNested<A> setNewSidecarLike(int index, Container item) {
        return new SidecarsNested(index, item);
    }

    public SidecarsNested<A> editSidecar(int index) {
        if (this.sidecars.size() <= index) {
            throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    public SidecarsNested<A> editFirstSidecar() {
        if (this.sidecars.size() == 0) {
            throw new RuntimeException("Can't edit first sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(0, this.buildSidecar(0));
    }

    public SidecarsNested<A> editLastSidecar() {
        int index = this.sidecars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecars. The list is empty.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    public SidecarsNested<A> editMatchingSidecar(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecars.size(); ++i) {
            if (!predicate.test(this.sidecars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecars. No match found.");
        }
        return this.setNewSidecarLike(index, this.buildSidecar(index));
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
        this.autoDeployEnabled = autoDeployEnabled;
        return (A)((Object)this);
    }

    public boolean hasAutoDeployEnabled() {
        return this.autoDeployEnabled != null;
    }

    public A withJobs(Job ... jobs) {
        if (this.jobs != null) {
            this.jobs.clear();
            this._visitables.remove((Object)"jobs");
        }
        if (jobs != null) {
            for (Job item : jobs) {
                this.addToJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public Job[] buildJobs() {
        int size = this.jobs != null ? this.jobs.size() : 0;
        Job[] result = new Job[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.jobs) {
            result[index++] = (Job)visitableBuilder.build();
        }
        return result;
    }

    public Job buildJob(int index) {
        return this.jobs.get(index).build();
    }

    public Job buildFirstJob() {
        return this.jobs.get(0).build();
    }

    public Job buildLastJob() {
        return this.jobs.get(this.jobs.size() - 1).build();
    }

    public Job buildMatchingJob(Predicate<JobBuilder> predicate) {
        for (JobBuilder item : this.jobs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingJob(Predicate<JobBuilder> predicate) {
        for (JobBuilder item : this.jobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToJobs(int index, Job item) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        JobBuilder builder = new JobBuilder(item);
        if (index < 0 || index >= this.jobs.size()) {
            this._visitables.get((Object)"jobs").add(builder);
            this.jobs.add(builder);
        } else {
            this._visitables.get((Object)"jobs").add(index, builder);
            this.jobs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToJobs(int index, Job item) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        JobBuilder builder = new JobBuilder(item);
        if (index < 0 || index >= this.jobs.size()) {
            this._visitables.get((Object)"jobs").add(builder);
            this.jobs.add(builder);
        } else {
            this._visitables.get((Object)"jobs").set(index, builder);
            this.jobs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToJobs(Job ... items) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").add(builder);
            this.jobs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToJobs(Collection<Job> items) {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").add(builder);
            this.jobs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromJobs(Job ... items) {
        if (this.jobs == null) {
            return (A)((Object)this);
        }
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").remove((Object)builder);
            this.jobs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJobs(Collection<Job> items) {
        if (this.jobs == null) {
            return (A)((Object)this);
        }
        for (Job item : items) {
            JobBuilder builder = new JobBuilder(item);
            this._visitables.get((Object)"jobs").remove((Object)builder);
            this.jobs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromJobs(Predicate<JobBuilder> predicate) {
        if (this.jobs == null) {
            return (A)((Object)this);
        }
        Iterator<JobBuilder> each = this.jobs.iterator();
        List visitables = this._visitables.get((Object)"jobs");
        while (each.hasNext()) {
            JobBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasJobs() {
        return this.jobs != null && !this.jobs.isEmpty();
    }

    public JobsNested<A> addNewJob() {
        return new JobsNested(-1, null);
    }

    public JobsNested<A> addNewJobLike(Job item) {
        return new JobsNested(-1, item);
    }

    public JobsNested<A> setNewJobLike(int index, Job item) {
        return new JobsNested(index, item);
    }

    public JobsNested<A> editJob(int index) {
        if (this.jobs.size() <= index) {
            throw new RuntimeException("Can't edit jobs. Index exceeds size.");
        }
        return this.setNewJobLike(index, this.buildJob(index));
    }

    public JobsNested<A> editFirstJob() {
        if (this.jobs.size() == 0) {
            throw new RuntimeException("Can't edit first jobs. The list is empty.");
        }
        return this.setNewJobLike(0, this.buildJob(0));
    }

    public JobsNested<A> editLastJob() {
        int index = this.jobs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jobs. The list is empty.");
        }
        return this.setNewJobLike(index, this.buildJob(index));
    }

    public JobsNested<A> editMatchingJob(Predicate<JobBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jobs.size(); ++i) {
            if (!predicate.test(this.jobs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jobs. No match found.");
        }
        return this.setNewJobLike(index, this.buildJob(index));
    }

    public A withCronJobs(CronJob ... cronJobs) {
        if (this.cronJobs != null) {
            this.cronJobs.clear();
            this._visitables.remove((Object)"cronJobs");
        }
        if (cronJobs != null) {
            for (CronJob item : cronJobs) {
                this.addToCronJobs(item);
            }
        }
        return (A)((Object)this);
    }

    public CronJob[] buildCronJobs() {
        int size = this.cronJobs != null ? this.cronJobs.size() : 0;
        CronJob[] result = new CronJob[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.cronJobs) {
            result[index++] = (CronJob)visitableBuilder.build();
        }
        return result;
    }

    public CronJob buildCronJob(int index) {
        return this.cronJobs.get(index).build();
    }

    public CronJob buildFirstCronJob() {
        return this.cronJobs.get(0).build();
    }

    public CronJob buildLastCronJob() {
        return this.cronJobs.get(this.cronJobs.size() - 1).build();
    }

    public CronJob buildMatchingCronJob(Predicate<CronJobBuilder> predicate) {
        for (CronJobBuilder item : this.cronJobs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCronJob(Predicate<CronJobBuilder> predicate) {
        for (CronJobBuilder item : this.cronJobs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToCronJobs(int index, CronJob item) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        CronJobBuilder builder = new CronJobBuilder(item);
        if (index < 0 || index >= this.cronJobs.size()) {
            this._visitables.get((Object)"cronJobs").add(builder);
            this.cronJobs.add(builder);
        } else {
            this._visitables.get((Object)"cronJobs").add(index, builder);
            this.cronJobs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCronJobs(int index, CronJob item) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        CronJobBuilder builder = new CronJobBuilder(item);
        if (index < 0 || index >= this.cronJobs.size()) {
            this._visitables.get((Object)"cronJobs").add(builder);
            this.cronJobs.add(builder);
        } else {
            this._visitables.get((Object)"cronJobs").set(index, builder);
            this.cronJobs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCronJobs(CronJob ... items) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").add(builder);
            this.cronJobs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCronJobs(Collection<CronJob> items) {
        if (this.cronJobs == null) {
            this.cronJobs = new ArrayList();
        }
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").add(builder);
            this.cronJobs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCronJobs(CronJob ... items) {
        if (this.cronJobs == null) {
            return (A)((Object)this);
        }
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").remove((Object)builder);
            this.cronJobs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCronJobs(Collection<CronJob> items) {
        if (this.cronJobs == null) {
            return (A)((Object)this);
        }
        for (CronJob item : items) {
            CronJobBuilder builder = new CronJobBuilder(item);
            this._visitables.get((Object)"cronJobs").remove((Object)builder);
            this.cronJobs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCronJobs(Predicate<CronJobBuilder> predicate) {
        if (this.cronJobs == null) {
            return (A)((Object)this);
        }
        Iterator<CronJobBuilder> each = this.cronJobs.iterator();
        List visitables = this._visitables.get((Object)"cronJobs");
        while (each.hasNext()) {
            CronJobBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasCronJobs() {
        return this.cronJobs != null && !this.cronJobs.isEmpty();
    }

    public CronJobsNested<A> addNewCronJob() {
        return new CronJobsNested(-1, null);
    }

    public CronJobsNested<A> addNewCronJobLike(CronJob item) {
        return new CronJobsNested(-1, item);
    }

    public CronJobsNested<A> setNewCronJobLike(int index, CronJob item) {
        return new CronJobsNested(index, item);
    }

    public CronJobsNested<A> editCronJob(int index) {
        if (this.cronJobs.size() <= index) {
            throw new RuntimeException("Can't edit cronJobs. Index exceeds size.");
        }
        return this.setNewCronJobLike(index, this.buildCronJob(index));
    }

    public CronJobsNested<A> editFirstCronJob() {
        if (this.cronJobs.size() == 0) {
            throw new RuntimeException("Can't edit first cronJobs. The list is empty.");
        }
        return this.setNewCronJobLike(0, this.buildCronJob(0));
    }

    public CronJobsNested<A> editLastCronJob() {
        int index = this.cronJobs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last cronJobs. The list is empty.");
        }
        return this.setNewCronJobLike(index, this.buildCronJob(index));
    }

    public CronJobsNested<A> editMatchingCronJob(Predicate<CronJobBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.cronJobs.size(); ++i) {
            if (!predicate.test(this.cronJobs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching cronJobs. No match found.");
        }
        return this.setNewCronJobLike(index, this.buildCronJob(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseConfigFluent that = (BaseConfigFluent)((Object)o);
        if (!Objects.equals(this.deploymentKind, that.deploymentKind)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.envVars, that.envVars)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceType, (Object)that.serviceType)) {
            return false;
        }
        if (!Objects.equals(this.pvcVolumes, that.pvcVolumes)) {
            return false;
        }
        if (!Objects.equals(this.secretVolumes, that.secretVolumes)) {
            return false;
        }
        if (!Objects.equals(this.configMapVolumes, that.configMapVolumes)) {
            return false;
        }
        if (!Objects.equals(this.emptyDirVolumes, that.emptyDirVolumes)) {
            return false;
        }
        if (!Objects.equals(this.gitRepoVolumes, that.gitRepoVolumes)) {
            return false;
        }
        if (!Objects.equals(this.awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureDiskVolumes, that.azureDiskVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureFileVolumes, that.azureFileVolumes)) {
            return false;
        }
        if (!Objects.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Objects.equals((Object)this.imagePullPolicy, (Object)that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals((Object)this.deploymentStrategy, (Object)that.deploymentStrategy)) {
            return false;
        }
        if (!Objects.equals((Object)this.rollingUpdate, (Object)that.rollingUpdate)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodeSelector, (Object)that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.startupProbe, (Object)that.startupProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.requestResources, (Object)that.requestResources)) {
            return false;
        }
        if (!Objects.equals((Object)this.limitResources, (Object)that.limitResources)) {
            return false;
        }
        if (!Objects.equals(this.sidecars, that.sidecars)) {
            return false;
        }
        if (!Objects.equals(this.autoDeployEnabled, that.autoDeployEnabled)) {
            return false;
        }
        if (!Objects.equals(this.jobs, that.jobs)) {
            return false;
        }
        return Objects.equals(this.cronJobs, that.cronJobs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.deploymentKind, this.labels, this.annotations, this.envVars, this.workingDir, this.command, this.arguments, this.serviceAccount, this.ports, this.serviceType, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.emptyDirVolumes, this.gitRepoVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.mounts, this.imagePullPolicy, this.imagePullSecrets, this.deploymentStrategy, this.rollingUpdate, this.hostAliases, this.nodeSelector, this.livenessProbe, this.readinessProbe, this.startupProbe, this.requestResources, this.limitResources, this.sidecars, this.autoDeployEnabled, this.jobs, this.cronJobs, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentKind != null) {
            sb.append("deploymentKind:");
            sb.append(this.deploymentKind + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.envVars != null && !this.envVars.isEmpty()) {
            sb.append("envVars:");
            sb.append(this.envVars + ",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(this.arguments + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.serviceType != null) {
            sb.append("serviceType:");
            sb.append((Object)((Object)this.serviceType) + ",");
        }
        if (this.pvcVolumes != null && !this.pvcVolumes.isEmpty()) {
            sb.append("pvcVolumes:");
            sb.append(this.pvcVolumes + ",");
        }
        if (this.secretVolumes != null && !this.secretVolumes.isEmpty()) {
            sb.append("secretVolumes:");
            sb.append(this.secretVolumes + ",");
        }
        if (this.configMapVolumes != null && !this.configMapVolumes.isEmpty()) {
            sb.append("configMapVolumes:");
            sb.append(this.configMapVolumes + ",");
        }
        if (this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty()) {
            sb.append("emptyDirVolumes:");
            sb.append(this.emptyDirVolumes + ",");
        }
        if (this.gitRepoVolumes != null && !this.gitRepoVolumes.isEmpty()) {
            sb.append("gitRepoVolumes:");
            sb.append(this.gitRepoVolumes + ",");
        }
        if (this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty()) {
            sb.append("awsElasticBlockStoreVolumes:");
            sb.append(this.awsElasticBlockStoreVolumes + ",");
        }
        if (this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty()) {
            sb.append("azureDiskVolumes:");
            sb.append(this.azureDiskVolumes + ",");
        }
        if (this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty()) {
            sb.append("azureFileVolumes:");
            sb.append(this.azureFileVolumes + ",");
        }
        if (this.mounts != null && !this.mounts.isEmpty()) {
            sb.append("mounts:");
            sb.append(this.mounts + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append((Object)((Object)this.imagePullPolicy) + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.deploymentStrategy != null) {
            sb.append("deploymentStrategy:");
            sb.append((Object)((Object)this.deploymentStrategy) + ",");
        }
        if (this.rollingUpdate != null) {
            sb.append("rollingUpdate:");
            sb.append((Object)((Object)this.rollingUpdate) + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append((Object)((Object)this.nodeSelector) + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append((Object)((Object)this.livenessProbe) + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append((Object)((Object)this.readinessProbe) + ",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append((Object)((Object)this.startupProbe) + ",");
        }
        if (this.requestResources != null) {
            sb.append("requestResources:");
            sb.append((Object)((Object)this.requestResources) + ",");
        }
        if (this.limitResources != null) {
            sb.append("limitResources:");
            sb.append((Object)((Object)this.limitResources) + ",");
        }
        if (this.sidecars != null && !this.sidecars.isEmpty()) {
            sb.append("sidecars:");
            sb.append(this.sidecars + ",");
        }
        if (this.autoDeployEnabled != null) {
            sb.append("autoDeployEnabled:");
            sb.append(this.autoDeployEnabled + ",");
        }
        if (this.jobs != null && !this.jobs.isEmpty()) {
            sb.append("jobs:");
            sb.append(this.jobs + ",");
        }
        if (this.cronJobs != null && !this.cronJobs.isEmpty()) {
            sb.append("cronJobs:");
            sb.append(this.cronJobs);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutoDeployEnabled() {
        return this.withAutoDeployEnabled(true);
    }

    public class CronJobsNested<N>
    extends CronJobFluent<CronJobsNested<N>>
    implements Nested<N> {
        CronJobBuilder builder;
        int index;

        CronJobsNested(int index, CronJob item) {
            this.index = index;
            this.builder = new CronJobBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToCronJobs(this.index, this.builder.build());
        }

        public N endCronJob() {
            return this.and();
        }
    }

    public class JobsNested<N>
    extends JobFluent<JobsNested<N>>
    implements Nested<N> {
        JobBuilder builder;
        int index;

        JobsNested(int index, Job item) {
            this.index = index;
            this.builder = new JobBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToJobs(this.index, this.builder.build());
        }

        public N endJob() {
            return this.and();
        }
    }

    public class SidecarsNested<N>
    extends ContainerFluent<SidecarsNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        SidecarsNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToSidecars(this.index, this.builder.build());
        }

        public N endSidecar() {
            return this.and();
        }
    }

    public class LimitResourcesNested<N>
    extends ResourceRequirementsFluent<LimitResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        LimitResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withLimitResources(this.builder.build());
        }

        public N endLimitResources() {
            return this.and();
        }
    }

    public class RequestResourcesNested<N>
    extends ResourceRequirementsFluent<RequestResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        RequestResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withRequestResources(this.builder.build());
        }

        public N endRequestResources() {
            return this.and();
        }
    }

    public class StartupProbeNested<N>
    extends ProbeFluent<StartupProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        StartupProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withStartupProbe(this.builder.build());
        }

        public N endStartupProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class NodeSelectorNested<N>
    extends NodeSelectorFluent<NodeSelectorNested<N>>
    implements Nested<N> {
        NodeSelectorBuilder builder;

        NodeSelectorNested(NodeSelector item) {
            this.builder = new NodeSelectorBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withNodeSelector(this.builder.build());
        }

        public N endNodeSelector() {
            return this.and();
        }
    }

    public class HostAliasesNested<N>
    extends HostAliasFluent<HostAliasesNested<N>>
    implements Nested<N> {
        HostAliasBuilder builder;
        int index;

        HostAliasesNested(int index, HostAlias item) {
            this.index = index;
            this.builder = new HostAliasBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToHostAliases(this.index, this.builder.build());
        }

        public N endHostAlias() {
            return this.and();
        }
    }

    public class RollingUpdateNested<N>
    extends RollingUpdateFluent<RollingUpdateNested<N>>
    implements Nested<N> {
        RollingUpdateBuilder builder;

        RollingUpdateNested(RollingUpdate item) {
            this.builder = new RollingUpdateBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.withRollingUpdate(this.builder.build());
        }

        public N endRollingUpdate() {
            return this.and();
        }
    }

    public class MountsNested<N>
    extends MountFluent<MountsNested<N>>
    implements Nested<N> {
        MountBuilder builder;
        int index;

        MountsNested(int index, Mount item) {
            this.index = index;
            this.builder = new MountBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToMounts(this.index, this.builder.build());
        }

        public N endMount() {
            return this.and();
        }
    }

    public class AzureFileVolumesNested<N>
    extends AzureFileVolumeFluent<AzureFileVolumesNested<N>>
    implements Nested<N> {
        AzureFileVolumeBuilder builder;
        int index;

        AzureFileVolumesNested(int index, AzureFileVolume item) {
            this.index = index;
            this.builder = new AzureFileVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToAzureFileVolumes(this.index, this.builder.build());
        }

        public N endAzureFileVolume() {
            return this.and();
        }
    }

    public class AzureDiskVolumesNested<N>
    extends AzureDiskVolumeFluent<AzureDiskVolumesNested<N>>
    implements Nested<N> {
        AzureDiskVolumeBuilder builder;
        int index;

        AzureDiskVolumesNested(int index, AzureDiskVolume item) {
            this.index = index;
            this.builder = new AzureDiskVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToAzureDiskVolumes(this.index, this.builder.build());
        }

        public N endAzureDiskVolume() {
            return this.and();
        }
    }

    public class AwsElasticBlockStoreVolumesNested<N>
    extends AwsElasticBlockStoreVolumeFluent<AwsElasticBlockStoreVolumesNested<N>>
    implements Nested<N> {
        AwsElasticBlockStoreVolumeBuilder builder;
        int index;

        AwsElasticBlockStoreVolumesNested(int index, AwsElasticBlockStoreVolume item) {
            this.index = index;
            this.builder = new AwsElasticBlockStoreVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToAwsElasticBlockStoreVolumes(this.index, this.builder.build());
        }

        public N endAwsElasticBlockStoreVolume() {
            return this.and();
        }
    }

    public class GitRepoVolumesNested<N>
    extends GitRepoVolumeFluent<GitRepoVolumesNested<N>>
    implements Nested<N> {
        GitRepoVolumeBuilder builder;
        int index;

        GitRepoVolumesNested(int index, GitRepoVolume item) {
            this.index = index;
            this.builder = new GitRepoVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToGitRepoVolumes(this.index, this.builder.build());
        }

        public N endGitRepoVolume() {
            return this.and();
        }
    }

    public class EmptyDirVolumesNested<N>
    extends EmptyDirVolumeFluent<EmptyDirVolumesNested<N>>
    implements Nested<N> {
        EmptyDirVolumeBuilder builder;
        int index;

        EmptyDirVolumesNested(int index, EmptyDirVolume item) {
            this.index = index;
            this.builder = new EmptyDirVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToEmptyDirVolumes(this.index, this.builder.build());
        }

        public N endEmptyDirVolume() {
            return this.and();
        }
    }

    public class ConfigMapVolumesNested<N>
    extends ConfigMapVolumeFluent<ConfigMapVolumesNested<N>>
    implements Nested<N> {
        ConfigMapVolumeBuilder builder;
        int index;

        ConfigMapVolumesNested(int index, ConfigMapVolume item) {
            this.index = index;
            this.builder = new ConfigMapVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToConfigMapVolumes(this.index, this.builder.build());
        }

        public N endConfigMapVolume() {
            return this.and();
        }
    }

    public class SecretVolumesNested<N>
    extends SecretVolumeFluent<SecretVolumesNested<N>>
    implements Nested<N> {
        SecretVolumeBuilder builder;
        int index;

        SecretVolumesNested(int index, SecretVolume item) {
            this.index = index;
            this.builder = new SecretVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToSecretVolumes(this.index, this.builder.build());
        }

        public N endSecretVolume() {
            return this.and();
        }
    }

    public class PvcVolumesNested<N>
    extends PersistentVolumeClaimVolumeFluent<PvcVolumesNested<N>>
    implements Nested<N> {
        PersistentVolumeClaimVolumeBuilder builder;
        int index;

        PvcVolumesNested(int index, PersistentVolumeClaimVolume item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimVolumeBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToPvcVolumes(this.index, this.builder.build());
        }

        public N endPvcVolume() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends PortFluent<PortsNested<N>>
    implements Nested<N> {
        PortBuilder builder;
        int index;

        PortsNested(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class EnvVarsNested<N>
    extends EnvFluent<EnvVarsNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvVarsNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToEnvVars(this.index, this.builder.build());
        }

        public N endEnvVar() {
            return this.and();
        }
    }

    public class AnnotationsNested<N>
    extends AnnotationFluent<AnnotationsNested<N>>
    implements Nested<N> {
        AnnotationBuilder builder;
        int index;

        AnnotationsNested(int index, Annotation item) {
            this.index = index;
            this.builder = new AnnotationBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToAnnotations(this.index, this.builder.build());
        }

        public N endAnnotation() {
            return this.and();
        }
    }

    public class LabelsNested<N>
    extends LabelFluent<LabelsNested<N>>
    implements Nested<N> {
        LabelBuilder builder;
        int index;

        LabelsNested(int index, Label item) {
            this.index = index;
            this.builder = new LabelBuilder(this, item);
        }

        public N and() {
            return (N)BaseConfigFluent.this.setToLabels(this.index, this.builder.build());
        }

        public N endLabel() {
            return this.and();
        }
    }
}

