/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;

@Description(value="Add an Azure File volume to the Pod spec.")
public class AddAzureFileVolumeDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final AzureFileVolume volume;

    public AddAzureFileVolumeDecorator(AzureFileVolume volume) {
        this(ANY, volume);
    }

    public AddAzureFileVolumeDecorator(String name, AzureFileVolume volume) {
        super(name);
        this.volume = volume;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        ((PodSpecFluent.VolumesNested)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewAzureFile().withSecretName(this.volume.getSecretName())).withShareName(this.volume.getShareName())).withReadOnly(Boolean.valueOf(this.volume.isReadOnly()))).endAzureFile()).endVolume();
    }
}

