/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.Arrays;

@Description(value="Add a label to the matching resources (filtered by name and/or kinds).")
public class AddLabelDecorator
extends NamedResourceDecorator<ObjectMetaFluent> {
    private final Label label;

    public AddLabelDecorator(Label label) {
        this(ANY, label);
    }

    public AddLabelDecorator(String name, Label label) {
        super(ANY, name);
        this.label = label;
    }

    public AddLabelDecorator(String name, String key, String value, String ... kinds) {
        super(ANY, name);
        this.label = new Label(key, value, kinds);
    }

    public Label getLabel() {
        return this.label;
    }

    public String getLabelKey() {
        return this.label.getKey();
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveLabelDecorator.class};
    }

    @Override
    public void andThenVisit(ObjectMetaFluent item, String kind, ObjectMeta resourceMeta) {
        if (this.label.getKinds() == null || this.label.getKinds().length == 0 || Arrays.asList(this.label.getKinds()).contains(kind)) {
            item.addToLabels(this.label.getKey(), this.label.getValue());
        }
    }

    @Override
    public void andThenVisit(ObjectMetaFluent item, ObjectMeta resourceMeta) {
        item.addToLabels(this.label.getKey(), this.label.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddLabelDecorator other = (AddLabelDecorator)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

