/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.utils.Predicates;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Description(value="Add port to to the specified container(s).")
public class AddPortDecorator
extends ApplicationContainerDecorator<ContainerBuilder>
implements WithConfigReferences {
    private final Port port;

    public AddPortDecorator(Port port) {
        this(ANY, ANY, port);
    }

    public AddPortDecorator(String deployment, String container, Port port) {
        super(deployment, container);
        this.port = port;
    }

    @Override
    public void andThenVisit(ContainerBuilder container) {
        if (container.buildPorts().stream().anyMatch(Predicates.matches((Port)this.port))) {
            ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.editMatchingPort(Predicates.builderMatches((Port)this.port)).withName(this.port.getName())).withHostPort(null)).withContainerPort(this.port.getContainerPort())).withProtocol(this.port.getProtocol() != null ? this.port.getProtocol().name() : Protocol.TCP.name())).endPort();
        } else {
            ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withName(this.port.getName())).withHostPort(null)).withContainerPort(this.port.getContainerPort())).withProtocol(this.port.getProtocol() != null ? this.port.getProtocol().name() : Protocol.TCP.name())).endPort();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddPortDecorator addPortDecorator = (AddPortDecorator)o;
        return Objects.equals(this.port, addPortDecorator.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }

    public List<ConfigReference> getConfigReferences() {
        String property = ConfigReference.joinProperties((String[])new String[]{"ports." + this.port.getName()});
        return Arrays.asList(new ConfigReference.Builder(property, new String[]{this.pathForDeployment(), this.pathForService()}).withValue((Object)this.port.getContainerPort()).withDescription("The port number to use for " + this.port.getName() + ".").build());
    }

    private String pathForDeployment() {
        String portFilter = ".ports.(name == " + this.port.getName() + ").containerPort";
        String path = "spec.template.spec.containers." + portFilter;
        if (!Strings.equals((String)this.getDeploymentName(), (String)ANY) && !Strings.equals((String)this.getContainerName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ").spec.template.spec.containers.(name == " + this.getContainerName() + ")" + portFilter;
        } else if (!Strings.equals((String)this.getDeploymentName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ").spec.template.spec.containers." + portFilter;
        } else if (!Strings.equals((String)this.getContainerName(), (String)ANY)) {
            path = "spec.template.spec.containers.(name == " + this.getContainerName() + ")" + portFilter;
        }
        return path;
    }

    private String pathForService() {
        String path = "spec.ports.(name == " + this.port.getName() + ").targetPort";
        if (!Strings.equals((String)this.getDeploymentName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ")." + path;
        }
        return path;
    }
}

