/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;

@Description(value="Add a ServiceAccount resource to the list of generated resources.")
public class AddServiceAccountResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String deploymentName;
    private final String serviceAccountName;

    public AddServiceAccountResourceDecorator() {
        this(null, null);
    }

    public AddServiceAccountResourceDecorator(String deploymentName) {
        this(deploymentName, deploymentName);
    }

    public AddServiceAccountResourceDecorator(String deploymentName, String serviceAccountName) {
        this.deploymentName = deploymentName;
        this.serviceAccountName = serviceAccountName;
    }

    public void visit(KubernetesListBuilder list) {
        String serviceAccountName;
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list, this.deploymentName);
        String string = serviceAccountName = Strings.isNotNullOrEmpty((String)this.serviceAccountName) ? this.serviceAccountName : meta.getName();
        if (this.contains(list, "v1", "ServiceAccount", serviceAccountName)) {
            return;
        }
        ((KubernetesListFluent.ServiceAccountItemsNested)((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)list.addNewServiceAccountItem().withNewMetadata().withName(serviceAccountName)).withLabels(meta.getLabels())).endMetadata()).endServiceAccountItem();
    }
}

