/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.db;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.util.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class TimeBoundHealthCheck {
    private final ExecutorService executorService;
    private final Duration duration;

    public TimeBoundHealthCheck(ExecutorService executorService, Duration duration) {
        this.executorService = executorService;
        this.duration = duration;
    }

    public HealthCheck.Result check(Callable<HealthCheck.Result> c) {
        try {
            return this.executorService.submit(c).get(this.duration.getQuantity(), this.duration.getUnit());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.unhealthy();
    }

    private HealthCheck.Result unhealthy() {
        return HealthCheck.Result.unhealthy((String)"Unable to successfully check in %s", (Object[])new Object[]{this.duration});
    }
}

