/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3;

import java.util.Objects;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;

public class NamePrependingTemplateEngine
implements TemplateEngine {
    private final TemplateEngine originalEngine;

    public NamePrependingTemplateEngine(TemplateEngine originalEngine) {
        this.originalEngine = Objects.requireNonNull(originalEngine, "'originalEngine' cannot be null'");
    }

    public String render(String template, StatementContext ctx) {
        ExtensionMethod extensionMethod = ctx.getExtensionMethod();
        String originalResult = this.originalEngine.render(template, ctx);
        if (extensionMethod == null) {
            return originalResult;
        }
        StringBuilder query = new StringBuilder(originalResult.length() + 100);
        query.append("/* ");
        String className = extensionMethod.getType().getSimpleName();
        if (!className.isEmpty()) {
            query.append(className).append('.');
        }
        query.append(extensionMethod.getMethod().getName());
        query.append(" */ ");
        query.append(originalResult);
        return query.toString();
    }
}

